% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_ml_task_runs}
\alias{glue_get_ml_task_runs}
\title{Gets a list of runs for a machine learning transform}
\usage{
glue_get_ml_task_runs(TransformId, NextToken, MaxResults, Filter, Sort)
}
\arguments{
\item{TransformId}{[required] The unique identifier of the machine learning transform.}

\item{NextToken}{A token for pagination of the results. The default is empty.}

\item{MaxResults}{The maximum number of results to return.}

\item{Filter}{The filter criteria, in the \code{TaskRunFilterCriteria} structure, for the
task run.}

\item{Sort}{The sorting criteria, in the \code{TaskRunSortCriteria} structure, for the
task run.}
}
\description{
Gets a list of runs for a machine learning transform. Machine learning
task runs are asynchronous tasks that AWS Glue runs on your behalf as
part of various machine learning workflows. You can get a sortable,
filterable list of machine learning task runs by calling \code{GetMLTaskRuns}
with their parent transform\'s \code{TransformID} and other optional
parameters as documented in this section.
}
\details{
This operation returns a list of historic runs and must be paginated.
}
\section{Request syntax}{
\preformatted{svc$get_ml_task_runs(
  TransformId = "string",
  NextToken = "string",
  MaxResults = 123,
  Filter = list(
    TaskRunType = "EVALUATION"|"LABELING_SET_GENERATION"|"IMPORT_LABELS"|"EXPORT_LABELS"|"FIND_MATCHES",
    Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
    StartedBefore = as.POSIXct(
      "2015-01-01"
    ),
    StartedAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  Sort = list(
    Column = "TASK_RUN_TYPE"|"STATUS"|"STARTED",
    SortDirection = "DESCENDING"|"ASCENDING"
  )
)
}
}

\keyword{internal}
