% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_send_test_event_notification}
\alias{mturk_send_test_event_notification}
\title{The SendTestEventNotification operation causes Amazon Mechanical Turk to
send a notification message as if a HIT event occurred, according to the
provided notification specification}
\usage{
mturk_send_test_event_notification(Notification, TestEventType)
}
\arguments{
\item{Notification}{[required] The notification specification to test. This value is identical to the
value you would provide to the UpdateNotificationSettings operation when
you establish the notification specification for a HIT type.}

\item{TestEventType}{[required] The event to simulate to test the notification specification. This event
is included in the test message even if the notification specification
does not include the event type. The notification specification does not
filter out the test event.}
}
\description{
The \code{SendTestEventNotification} operation causes Amazon Mechanical Turk
to send a notification message as if a HIT event occurred, according to
the provided notification specification. This allows you to test
notifications without setting up notifications for a real HIT type and
trying to trigger them using the website. When you call this operation,
the service attempts to send the test notification immediately.
}
\section{Request syntax}{
\preformatted{svc$send_test_event_notification(
  Notification = list(
    Destination = "string",
    Transport = "Email"|"SQS"|"SNS",
    Version = "string",
    EventTypes = list(
      "AssignmentAccepted"|"AssignmentAbandoned"|"AssignmentReturned"|"AssignmentSubmitted"|"AssignmentRejected"|"AssignmentApproved"|"HITCreated"|"HITExpired"|"HITReviewable"|"HITExtended"|"HITDisposed"|"Ping"
    )
  ),
  TestEventType = "AssignmentAccepted"|"AssignmentAbandoned"|"AssignmentReturned"|"AssignmentSubmitted"|"AssignmentRejected"|"AssignmentApproved"|"HITCreated"|"HITExpired"|"HITReviewable"|"HITExtended"|"HITDisposed"|"Ping"
)
}
}

\keyword{internal}
