# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include emr_service.R
NULL

#' Adds an instance fleet to a running cluster
#'
#' Adds an instance fleet to a running cluster.
#' 
#' The instance fleet configuration is available only in Amazon EMR
#' versions 4.8.0 and later, excluding 5.0.x.
#'
#' @usage
#' emr_add_instance_fleet(ClusterId, InstanceFleet)
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param InstanceFleet &#91;required&#93; Specifies the configuration of the instance fleet.
#'
#' @section Request syntax:
#' ```
#' svc$add_instance_fleet(
#'   ClusterId = "string",
#'   InstanceFleet = list(
#'     Name = "string",
#'     InstanceFleetType = "MASTER"|"CORE"|"TASK",
#'     TargetOnDemandCapacity = 123,
#'     TargetSpotCapacity = 123,
#'     InstanceTypeConfigs = list(
#'       list(
#'         InstanceType = "string",
#'         WeightedCapacity = 123,
#'         BidPrice = "string",
#'         BidPriceAsPercentageOfOnDemandPrice = 123.0,
#'         EbsConfiguration = list(
#'           EbsBlockDeviceConfigs = list(
#'             list(
#'               VolumeSpecification = list(
#'                 VolumeType = "string",
#'                 Iops = 123,
#'                 SizeInGB = 123
#'               ),
#'               VolumesPerInstance = 123
#'             )
#'           ),
#'           EbsOptimized = TRUE|FALSE
#'         ),
#'         Configurations = list(
#'           list(
#'             Classification = "string",
#'             Configurations = list(),
#'             Properties = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     LaunchSpecifications = list(
#'       SpotSpecification = list(
#'         TimeoutDurationMinutes = 123,
#'         TimeoutAction = "SWITCH_TO_ON_DEMAND"|"TERMINATE_CLUSTER",
#'         BlockDurationMinutes = 123,
#'         AllocationStrategy = "capacity-optimized"
#'       ),
#'       OnDemandSpecification = list(
#'         AllocationStrategy = "lowest-price"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_add_instance_fleet
emr_add_instance_fleet <- function(ClusterId, InstanceFleet) {
  op <- new_operation(
    name = "AddInstanceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_instance_fleet_input(ClusterId = ClusterId, InstanceFleet = InstanceFleet)
  output <- .emr$add_instance_fleet_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_instance_fleet <- emr_add_instance_fleet

#' Adds one or more instance groups to a running cluster
#'
#' Adds one or more instance groups to a running cluster.
#'
#' @usage
#' emr_add_instance_groups(InstanceGroups, JobFlowId)
#'
#' @param InstanceGroups &#91;required&#93; Instance groups to add.
#' @param JobFlowId &#91;required&#93; Job flow in which to add the instance groups.
#'
#' @section Request syntax:
#' ```
#' svc$add_instance_groups(
#'   InstanceGroups = list(
#'     list(
#'       Name = "string",
#'       Market = "ON_DEMAND"|"SPOT",
#'       InstanceRole = "MASTER"|"CORE"|"TASK",
#'       BidPrice = "string",
#'       InstanceType = "string",
#'       InstanceCount = 123,
#'       Configurations = list(
#'         list(
#'           Classification = "string",
#'           Configurations = list(),
#'           Properties = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       EbsConfiguration = list(
#'         EbsBlockDeviceConfigs = list(
#'           list(
#'             VolumeSpecification = list(
#'               VolumeType = "string",
#'               Iops = 123,
#'               SizeInGB = 123
#'             ),
#'             VolumesPerInstance = 123
#'           )
#'         ),
#'         EbsOptimized = TRUE|FALSE
#'       ),
#'       AutoScalingPolicy = list(
#'         Constraints = list(
#'           MinCapacity = 123,
#'           MaxCapacity = 123
#'         ),
#'         Rules = list(
#'           list(
#'             Name = "string",
#'             Description = "string",
#'             Action = list(
#'               Market = "ON_DEMAND"|"SPOT",
#'               SimpleScalingPolicyConfiguration = list(
#'                 AdjustmentType = "CHANGE_IN_CAPACITY"|"PERCENT_CHANGE_IN_CAPACITY"|"EXACT_CAPACITY",
#'                 ScalingAdjustment = 123,
#'                 CoolDown = 123
#'               )
#'             ),
#'             Trigger = list(
#'               CloudWatchAlarmDefinition = list(
#'                 ComparisonOperator = "GREATER_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"LESS_THAN_OR_EQUAL",
#'                 EvaluationPeriods = 123,
#'                 MetricName = "string",
#'                 Namespace = "string",
#'                 Period = 123,
#'                 Statistic = "SAMPLE_COUNT"|"AVERAGE"|"SUM"|"MINIMUM"|"MAXIMUM",
#'                 Threshold = 123.0,
#'                 Unit = "NONE"|"SECONDS"|"MICRO_SECONDS"|"MILLI_SECONDS"|"BYTES"|"KILO_BYTES"|"MEGA_BYTES"|"GIGA_BYTES"|"TERA_BYTES"|"BITS"|"KILO_BITS"|"MEGA_BITS"|"GIGA_BITS"|"TERA_BITS"|"PERCENT"|"COUNT"|"BYTES_PER_SECOND"|"KILO_BYTES_PER_SECOND"|"MEGA_BYTES_PER_SECOND"|"GIGA_BYTES_PER_SECOND"|"TERA_BYTES_PER_SECOND"|"BITS_PER_SECOND"|"KILO_BITS_PER_SECOND"|"MEGA_BITS_PER_SECOND"|"GIGA_BITS_PER_SECOND"|"TERA_BITS_PER_SECOND"|"COUNT_PER_SECOND",
#'                 Dimensions = list(
#'                   list(
#'                     Key = "string",
#'                     Value = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   JobFlowId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_add_instance_groups
emr_add_instance_groups <- function(InstanceGroups, JobFlowId) {
  op <- new_operation(
    name = "AddInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_instance_groups_input(InstanceGroups = InstanceGroups, JobFlowId = JobFlowId)
  output <- .emr$add_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_instance_groups <- emr_add_instance_groups

#' AddJobFlowSteps adds new steps to a running cluster
#'
#' AddJobFlowSteps adds new steps to a running cluster. A maximum of 256
#' steps are allowed in each job flow.
#' 
#' If your cluster is long-running (such as a Hive data warehouse) or
#' complex, you may require more than 256 steps to process your data. You
#' can bypass the 256-step limitation in various ways, including using SSH
#' to connect to the master node and submitting queries directly to the
#' software running on the master node, such as Hive and Hadoop. For more
#' information on how to do this, see [Add More than 256 Steps to a
#' Cluster](https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html)
#' in the *Amazon EMR Management Guide*.
#' 
#' A step specifies the location of a JAR file stored either on the master
#' node of the cluster or in Amazon S3. Each step is performed by the main
#' function of the main class of the JAR file. The main class can be
#' specified either in the manifest of the JAR or by using the MainFunction
#' parameter of the step.
#' 
#' Amazon EMR executes each step in the order listed. For a step to be
#' considered complete, the main function must exit with a zero exit code
#' and all Hadoop jobs started while the step was running must have
#' completed and run successfully.
#' 
#' You can only add steps to a cluster that is in one of the following
#' states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
#'
#' @usage
#' emr_add_job_flow_steps(JobFlowId, Steps)
#'
#' @param JobFlowId &#91;required&#93; A string that uniquely identifies the job flow. This identifier is
#' returned by RunJobFlow and can also be obtained from ListClusters.
#' @param Steps &#91;required&#93; A list of StepConfig to be executed by the job flow.
#'
#' @section Request syntax:
#' ```
#' svc$add_job_flow_steps(
#'   JobFlowId = "string",
#'   Steps = list(
#'     list(
#'       Name = "string",
#'       ActionOnFailure = "TERMINATE_JOB_FLOW"|"TERMINATE_CLUSTER"|"CANCEL_AND_WAIT"|"CONTINUE",
#'       HadoopJarStep = list(
#'         Properties = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         ),
#'         Jar = "string",
#'         MainClass = "string",
#'         Args = list(
#'           "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_add_job_flow_steps
emr_add_job_flow_steps <- function(JobFlowId, Steps) {
  op <- new_operation(
    name = "AddJobFlowSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_job_flow_steps_input(JobFlowId = JobFlowId, Steps = Steps)
  output <- .emr$add_job_flow_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_job_flow_steps <- emr_add_job_flow_steps

#' Adds tags to an Amazon EMR resource
#'
#' Adds tags to an Amazon EMR resource. Tags make it easier to associate
#' clusters in various ways, such as grouping clusters to track your Amazon
#' EMR resource allocation costs. For more information, see [Tag
#' Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
#'
#' @usage
#' emr_add_tags(ResourceId, Tags)
#'
#' @param ResourceId &#91;required&#93; The Amazon EMR resource identifier to which tags will be added. This
#' value must be a cluster identifier.
#' @param Tags &#91;required&#93; A list of tags to associate with a cluster and propagate to EC2
#' instances. Tags are user-defined key/value pairs that consist of a
#' required key string with a maximum of 128 characters, and an optional
#' value string with a maximum of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   ResourceId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_add_tags
emr_add_tags <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_tags_input(ResourceId = ResourceId, Tags = Tags)
  output <- .emr$add_tags_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_tags <- emr_add_tags

#' Cancels a pending step or steps in a running cluster
#'
#' Cancels a pending step or steps in a running cluster. Available only in
#' Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum
#' of 256 steps are allowed in each CancelSteps request. CancelSteps is
#' idempotent but asynchronous; it does not guarantee a step will be
#' canceled, even if the request is successfully submitted. You can only
#' cancel steps that are in a `PENDING` state.
#'
#' @usage
#' emr_cancel_steps(ClusterId, StepIds, StepCancellationOption)
#'
#' @param ClusterId &#91;required&#93; The `ClusterID` for which specified steps will be canceled. Use
#' RunJobFlow and ListClusters to get ClusterIDs.
#' @param StepIds &#91;required&#93; The list of `StepIDs` to cancel. Use ListSteps to get steps and their
#' states for the specified cluster.
#' @param StepCancellationOption The option to choose for cancelling `RUNNING` steps. By default, the
#' value is `SEND_INTERRUPT`.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_steps(
#'   ClusterId = "string",
#'   StepIds = list(
#'     "string"
#'   ),
#'   StepCancellationOption = "SEND_INTERRUPT"|"TERMINATE_PROCESS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_cancel_steps
emr_cancel_steps <- function(ClusterId, StepIds, StepCancellationOption = NULL) {
  op <- new_operation(
    name = "CancelSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$cancel_steps_input(ClusterId = ClusterId, StepIds = StepIds, StepCancellationOption = StepCancellationOption)
  output <- .emr$cancel_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$cancel_steps <- emr_cancel_steps

#' Creates a security configuration, which is stored in the service and can
#' be specified when a cluster is created
#'
#' Creates a security configuration, which is stored in the service and can
#' be specified when a cluster is created.
#'
#' @usage
#' emr_create_security_configuration(Name, SecurityConfiguration)
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#' @param SecurityConfiguration &#91;required&#93; The security configuration details in JSON format. For JSON parameters
#' and examples, see [Use Security Configurations to Set Up Cluster
#' Security](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html)
#' in the *Amazon EMR Management Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_security_configuration(
#'   Name = "string",
#'   SecurityConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_create_security_configuration
emr_create_security_configuration <- function(Name, SecurityConfiguration) {
  op <- new_operation(
    name = "CreateSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$create_security_configuration_input(Name = Name, SecurityConfiguration = SecurityConfiguration)
  output <- .emr$create_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$create_security_configuration <- emr_create_security_configuration

#' Deletes a security configuration
#'
#' Deletes a security configuration.
#'
#' @usage
#' emr_delete_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_delete_security_configuration
emr_delete_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DeleteSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$delete_security_configuration_input(Name = Name)
  output <- .emr$delete_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$delete_security_configuration <- emr_delete_security_configuration

#' Provides cluster-level details including status, hardware and software
#' configuration, VPC settings, and so on
#'
#' Provides cluster-level details including status, hardware and software
#' configuration, VPC settings, and so on.
#'
#' @usage
#' emr_describe_cluster(ClusterId)
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster(
#'   ClusterId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_describe_cluster
emr_describe_cluster <- function(ClusterId) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_cluster_input(ClusterId = ClusterId)
  output <- .emr$describe_cluster_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_cluster <- emr_describe_cluster

#' This API is deprecated and will eventually be removed
#'
#' This API is deprecated and will eventually be removed. We recommend you
#' use ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and
#' ListBootstrapActions instead.
#' 
#' DescribeJobFlows returns a list of job flows that match all of the
#' supplied parameters. The parameters can include a list of job flow IDs,
#' job flow states, and restrictions on job flow creation date and time.
#' 
#' Regardless of supplied parameters, only job flows created within the
#' last two months are returned.
#' 
#' If no parameters are supplied, then job flows matching either of the
#' following criteria are returned:
#' 
#' -   Job flows created and completed in the last two weeks
#' 
#' -   Job flows created within the last two months that are in one of the
#'     following states: `RUNNING`, `WAITING`, `SHUTTING_DOWN`, `STARTING`
#' 
#' Amazon EMR can return a maximum of 512 job flow descriptions.
#'
#' @usage
#' emr_describe_job_flows(CreatedAfter, CreatedBefore, JobFlowIds,
#'   JobFlowStates)
#'
#' @param CreatedAfter Return only job flows created after this date and time.
#' @param CreatedBefore Return only job flows created before this date and time.
#' @param JobFlowIds Return only job flows whose job flow ID is contained in this list.
#' @param JobFlowStates Return only job flows whose state is contained in this list.
#'
#' @section Request syntax:
#' ```
#' svc$describe_job_flows(
#'   CreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   JobFlowIds = list(
#'     "string"
#'   ),
#'   JobFlowStates = list(
#'     "STARTING"|"BOOTSTRAPPING"|"RUNNING"|"WAITING"|"SHUTTING_DOWN"|"TERMINATED"|"COMPLETED"|"FAILED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_describe_job_flows
emr_describe_job_flows <- function(CreatedAfter = NULL, CreatedBefore = NULL, JobFlowIds = NULL, JobFlowStates = NULL) {
  op <- new_operation(
    name = "DescribeJobFlows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_job_flows_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, JobFlowIds = JobFlowIds, JobFlowStates = JobFlowStates)
  output <- .emr$describe_job_flows_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_job_flows <- emr_describe_job_flows

#' Provides the details of a security configuration by returning the
#' configuration JSON
#'
#' Provides the details of a security configuration by returning the
#' configuration JSON.
#'
#' @usage
#' emr_describe_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#'
#' @section Request syntax:
#' ```
#' svc$describe_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_describe_security_configuration
emr_describe_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DescribeSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_security_configuration_input(Name = Name)
  output <- .emr$describe_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_security_configuration <- emr_describe_security_configuration

#' Provides more detail about the cluster step
#'
#' Provides more detail about the cluster step.
#'
#' @usage
#' emr_describe_step(ClusterId, StepId)
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster with steps to describe.
#' @param StepId &#91;required&#93; The identifier of the step to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_step(
#'   ClusterId = "string",
#'   StepId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_describe_step
emr_describe_step <- function(ClusterId, StepId) {
  op <- new_operation(
    name = "DescribeStep",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_step_input(ClusterId = ClusterId, StepId = StepId)
  output <- .emr$describe_step_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_step <- emr_describe_step

#' Returns the Amazon EMR block public access configuration for your AWS
#' account in the current Region
#'
#' Returns the Amazon EMR block public access configuration for your AWS
#' account in the current Region. For more information see [Configure Block
#' Public Access for Amazon
#' EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
#' in the *Amazon EMR Management Guide*.
#'
#' @usage
#' emr_get_block_public_access_configuration()
#'
#' @section Request syntax:
#' ```
#' svc$get_block_public_access_configuration()
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_get_block_public_access_configuration
emr_get_block_public_access_configuration <- function() {
  op <- new_operation(
    name = "GetBlockPublicAccessConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_block_public_access_configuration_input()
  output <- .emr$get_block_public_access_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_block_public_access_configuration <- emr_get_block_public_access_configuration

#' Fetches the attached managed scaling policy for an Amazon EMR cluster
#'
#' Fetches the attached managed scaling policy for an Amazon EMR cluster.
#'
#' @usage
#' emr_get_managed_scaling_policy(ClusterId)
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the cluster for which the managed scaling policy
#' will be fetched.
#'
#' @section Request syntax:
#' ```
#' svc$get_managed_scaling_policy(
#'   ClusterId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_get_managed_scaling_policy
emr_get_managed_scaling_policy <- function(ClusterId) {
  op <- new_operation(
    name = "GetManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_managed_scaling_policy_input(ClusterId = ClusterId)
  output <- .emr$get_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_managed_scaling_policy <- emr_get_managed_scaling_policy

#' Provides information about the bootstrap actions associated with a
#' cluster
#'
#' Provides information about the bootstrap actions associated with a
#' cluster.
#'
#' @usage
#' emr_list_bootstrap_actions(ClusterId, Marker)
#'
#' @param ClusterId &#91;required&#93; The cluster identifier for the bootstrap actions to list.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_bootstrap_actions(
#'   ClusterId = "string",
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_bootstrap_actions
emr_list_bootstrap_actions <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListBootstrapActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_bootstrap_actions_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_bootstrap_actions_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_bootstrap_actions <- emr_list_bootstrap_actions

#' Provides the status of all clusters visible to this AWS account
#'
#' Provides the status of all clusters visible to this AWS account. Allows
#' you to filter the list of clusters based on certain criteria; for
#' example, filtering by cluster creation date and time or by status. This
#' call returns a maximum of 50 clusters per call, but returns a marker to
#' track the paging of the cluster list across multiple ListClusters calls.
#'
#' @usage
#' emr_list_clusters(CreatedAfter, CreatedBefore, ClusterStates, Marker)
#'
#' @param CreatedAfter The creation date and time beginning value filter for listing clusters.
#' @param CreatedBefore The creation date and time end value filter for listing clusters.
#' @param ClusterStates The cluster state filters to apply when listing clusters.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_clusters(
#'   CreatedAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreatedBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ClusterStates = list(
#'     "STARTING"|"BOOTSTRAPPING"|"RUNNING"|"WAITING"|"TERMINATING"|"TERMINATED"|"TERMINATED_WITH_ERRORS"
#'   ),
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_clusters
emr_list_clusters <- function(CreatedAfter = NULL, CreatedBefore = NULL, ClusterStates = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_clusters_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, ClusterStates = ClusterStates, Marker = Marker)
  output <- .emr$list_clusters_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_clusters <- emr_list_clusters

#' Lists all available details about the instance fleets in a cluster
#'
#' Lists all available details about the instance fleets in a cluster.
#' 
#' The instance fleet configuration is available only in Amazon EMR
#' versions 4.8.0 and later, excluding 5.0.x versions.
#'
#' @usage
#' emr_list_instance_fleets(ClusterId, Marker)
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_instance_fleets(
#'   ClusterId = "string",
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_instance_fleets
emr_list_instance_fleets <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListInstanceFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instance_fleets_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_instance_fleets_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instance_fleets <- emr_list_instance_fleets

#' Provides all available details about the instance groups in a cluster
#'
#' Provides all available details about the instance groups in a cluster.
#'
#' @usage
#' emr_list_instance_groups(ClusterId, Marker)
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the instance groups.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_instance_groups(
#'   ClusterId = "string",
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_instance_groups
emr_list_instance_groups <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instance_groups_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instance_groups <- emr_list_instance_groups

#' Provides information for all active EC2 instances and EC2 instances
#' terminated in the last 30 days, up to a maximum of 2,000
#'
#' Provides information for all active EC2 instances and EC2 instances
#' terminated in the last 30 days, up to a maximum of 2,000. EC2 instances
#' in any of the following states are considered active:
#' AWAITING\\_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
#'
#' @usage
#' emr_list_instances(ClusterId, InstanceGroupId, InstanceGroupTypes,
#'   InstanceFleetId, InstanceFleetType, InstanceStates, Marker)
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the instances.
#' @param InstanceGroupId The identifier of the instance group for which to list the instances.
#' @param InstanceGroupTypes The type of instance group for which to list the instances.
#' @param InstanceFleetId The unique identifier of the instance fleet.
#' @param InstanceFleetType The node type of the instance fleet. For example MASTER, CORE, or TASK.
#' @param InstanceStates A list of instance states that will filter the instances returned with
#' this request.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_instances(
#'   ClusterId = "string",
#'   InstanceGroupId = "string",
#'   InstanceGroupTypes = list(
#'     "MASTER"|"CORE"|"TASK"
#'   ),
#'   InstanceFleetId = "string",
#'   InstanceFleetType = "MASTER"|"CORE"|"TASK",
#'   InstanceStates = list(
#'     "AWAITING_FULFILLMENT"|"PROVISIONING"|"BOOTSTRAPPING"|"RUNNING"|"TERMINATED"
#'   ),
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_instances
emr_list_instances <- function(ClusterId, InstanceGroupId = NULL, InstanceGroupTypes = NULL, InstanceFleetId = NULL, InstanceFleetType = NULL, InstanceStates = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instances_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId, InstanceGroupTypes = InstanceGroupTypes, InstanceFleetId = InstanceFleetId, InstanceFleetType = InstanceFleetType, InstanceStates = InstanceStates, Marker = Marker)
  output <- .emr$list_instances_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instances <- emr_list_instances

#' Lists all the security configurations visible to this account, providing
#' their creation dates and times, and their names
#'
#' Lists all the security configurations visible to this account, providing
#' their creation dates and times, and their names. This call returns a
#' maximum of 50 clusters per call, but returns a marker to track the
#' paging of the cluster list across multiple ListSecurityConfigurations
#' calls.
#'
#' @usage
#' emr_list_security_configurations(Marker)
#'
#' @param Marker The pagination token that indicates the set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_security_configurations(
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_security_configurations
emr_list_security_configurations <- function(Marker = NULL) {
  op <- new_operation(
    name = "ListSecurityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_security_configurations_input(Marker = Marker)
  output <- .emr$list_security_configurations_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_security_configurations <- emr_list_security_configurations

#' Provides a list of steps for the cluster in reverse order unless you
#' specify stepIds with the request of filter by StepStates
#'
#' Provides a list of steps for the cluster in reverse order unless you
#' specify `stepIds` with the request of filter by `StepStates`. You can
#' specify a maximum of ten `stepIDs`.
#'
#' @usage
#' emr_list_steps(ClusterId, StepStates, StepIds, Marker)
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the steps.
#' @param StepStates The filter to limit the step list based on certain states.
#' @param StepIds The filter to limit the step list based on the identifier of the steps.
#' You can specify a maximum of ten Step IDs. The character constraint
#' applies to the overall length of the array.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_steps(
#'   ClusterId = "string",
#'   StepStates = list(
#'     "PENDING"|"CANCEL_PENDING"|"RUNNING"|"COMPLETED"|"CANCELLED"|"FAILED"|"INTERRUPTED"
#'   ),
#'   StepIds = list(
#'     "string"
#'   ),
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_list_steps
emr_list_steps <- function(ClusterId, StepStates = NULL, StepIds = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_steps_input(ClusterId = ClusterId, StepStates = StepStates, StepIds = StepIds, Marker = Marker)
  output <- .emr$list_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_steps <- emr_list_steps

#' Modifies the number of steps that can be executed concurrently for the
#' cluster specified using ClusterID
#'
#' Modifies the number of steps that can be executed concurrently for the
#' cluster specified using ClusterID.
#'
#' @usage
#' emr_modify_cluster(ClusterId, StepConcurrencyLevel)
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param StepConcurrencyLevel The number of steps that can be executed concurrently. You can specify a
#' maximum of 256 steps.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster(
#'   ClusterId = "string",
#'   StepConcurrencyLevel = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_modify_cluster
emr_modify_cluster <- function(ClusterId, StepConcurrencyLevel = NULL) {
  op <- new_operation(
    name = "ModifyCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_cluster_input(ClusterId = ClusterId, StepConcurrencyLevel = StepConcurrencyLevel)
  output <- .emr$modify_cluster_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_cluster <- emr_modify_cluster

#' Modifies the target On-Demand and target Spot capacities for the
#' instance fleet with the specified InstanceFleetID within the cluster
#' specified using ClusterID
#'
#' Modifies the target On-Demand and target Spot capacities for the
#' instance fleet with the specified InstanceFleetID within the cluster
#' specified using ClusterID. The call either succeeds or fails atomically.
#' 
#' The instance fleet configuration is available only in Amazon EMR
#' versions 4.8.0 and later, excluding 5.0.x versions.
#'
#' @usage
#' emr_modify_instance_fleet(ClusterId, InstanceFleet)
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param InstanceFleet &#91;required&#93; The unique identifier of the instance fleet.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_fleet(
#'   ClusterId = "string",
#'   InstanceFleet = list(
#'     InstanceFleetId = "string",
#'     TargetOnDemandCapacity = 123,
#'     TargetSpotCapacity = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_modify_instance_fleet
emr_modify_instance_fleet <- function(ClusterId, InstanceFleet) {
  op <- new_operation(
    name = "ModifyInstanceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_instance_fleet_input(ClusterId = ClusterId, InstanceFleet = InstanceFleet)
  output <- .emr$modify_instance_fleet_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_instance_fleet <- emr_modify_instance_fleet

#' ModifyInstanceGroups modifies the number of nodes and configuration
#' settings of an instance group
#'
#' ModifyInstanceGroups modifies the number of nodes and configuration
#' settings of an instance group. The input parameters include the new
#' target instance count for the group and the instance group ID. The call
#' will either succeed or fail atomically.
#'
#' @usage
#' emr_modify_instance_groups(ClusterId, InstanceGroups)
#'
#' @param ClusterId The ID of the cluster to which the instance group belongs.
#' @param InstanceGroups Instance groups to change.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_groups(
#'   ClusterId = "string",
#'   InstanceGroups = list(
#'     list(
#'       InstanceGroupId = "string",
#'       InstanceCount = 123,
#'       EC2InstanceIdsToTerminate = list(
#'         "string"
#'       ),
#'       ShrinkPolicy = list(
#'         DecommissionTimeout = 123,
#'         InstanceResizePolicy = list(
#'           InstancesToTerminate = list(
#'             "string"
#'           ),
#'           InstancesToProtect = list(
#'             "string"
#'           ),
#'           InstanceTerminationTimeout = 123
#'         )
#'       ),
#'       Configurations = list(
#'         list(
#'           Classification = "string",
#'           Configurations = list(),
#'           Properties = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_modify_instance_groups
emr_modify_instance_groups <- function(ClusterId = NULL, InstanceGroups = NULL) {
  op <- new_operation(
    name = "ModifyInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_instance_groups_input(ClusterId = ClusterId, InstanceGroups = InstanceGroups)
  output <- .emr$modify_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_instance_groups <- emr_modify_instance_groups

#' Creates or updates an automatic scaling policy for a core instance group
#' or task instance group in an Amazon EMR cluster
#'
#' Creates or updates an automatic scaling policy for a core instance group
#' or task instance group in an Amazon EMR cluster. The automatic scaling
#' policy defines how an instance group dynamically adds and terminates EC2
#' instances in response to the value of a CloudWatch metric.
#'
#' @usage
#' emr_put_auto_scaling_policy(ClusterId, InstanceGroupId,
#'   AutoScalingPolicy)
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of a cluster. The instance group to which the automatic
#' scaling policy is applied is within this cluster.
#' @param InstanceGroupId &#91;required&#93; Specifies the ID of the instance group to which the automatic scaling
#' policy is applied.
#' @param AutoScalingPolicy &#91;required&#93; Specifies the definition of the automatic scaling policy.
#'
#' @section Request syntax:
#' ```
#' svc$put_auto_scaling_policy(
#'   ClusterId = "string",
#'   InstanceGroupId = "string",
#'   AutoScalingPolicy = list(
#'     Constraints = list(
#'       MinCapacity = 123,
#'       MaxCapacity = 123
#'     ),
#'     Rules = list(
#'       list(
#'         Name = "string",
#'         Description = "string",
#'         Action = list(
#'           Market = "ON_DEMAND"|"SPOT",
#'           SimpleScalingPolicyConfiguration = list(
#'             AdjustmentType = "CHANGE_IN_CAPACITY"|"PERCENT_CHANGE_IN_CAPACITY"|"EXACT_CAPACITY",
#'             ScalingAdjustment = 123,
#'             CoolDown = 123
#'           )
#'         ),
#'         Trigger = list(
#'           CloudWatchAlarmDefinition = list(
#'             ComparisonOperator = "GREATER_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"LESS_THAN_OR_EQUAL",
#'             EvaluationPeriods = 123,
#'             MetricName = "string",
#'             Namespace = "string",
#'             Period = 123,
#'             Statistic = "SAMPLE_COUNT"|"AVERAGE"|"SUM"|"MINIMUM"|"MAXIMUM",
#'             Threshold = 123.0,
#'             Unit = "NONE"|"SECONDS"|"MICRO_SECONDS"|"MILLI_SECONDS"|"BYTES"|"KILO_BYTES"|"MEGA_BYTES"|"GIGA_BYTES"|"TERA_BYTES"|"BITS"|"KILO_BITS"|"MEGA_BITS"|"GIGA_BITS"|"TERA_BITS"|"PERCENT"|"COUNT"|"BYTES_PER_SECOND"|"KILO_BYTES_PER_SECOND"|"MEGA_BYTES_PER_SECOND"|"GIGA_BYTES_PER_SECOND"|"TERA_BYTES_PER_SECOND"|"BITS_PER_SECOND"|"KILO_BITS_PER_SECOND"|"MEGA_BITS_PER_SECOND"|"GIGA_BITS_PER_SECOND"|"TERA_BITS_PER_SECOND"|"COUNT_PER_SECOND",
#'             Dimensions = list(
#'               list(
#'                 Key = "string",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_put_auto_scaling_policy
emr_put_auto_scaling_policy <- function(ClusterId, InstanceGroupId, AutoScalingPolicy) {
  op <- new_operation(
    name = "PutAutoScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_auto_scaling_policy_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId, AutoScalingPolicy = AutoScalingPolicy)
  output <- .emr$put_auto_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_auto_scaling_policy <- emr_put_auto_scaling_policy

#' Creates or updates an Amazon EMR block public access configuration for
#' your AWS account in the current Region
#'
#' Creates or updates an Amazon EMR block public access configuration for
#' your AWS account in the current Region. For more information see
#' [Configure Block Public Access for Amazon
#' EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
#' in the *Amazon EMR Management Guide*.
#'
#' @usage
#' emr_put_block_public_access_configuration(
#'   BlockPublicAccessConfiguration)
#'
#' @param BlockPublicAccessConfiguration &#91;required&#93; A configuration for Amazon EMR block public access. The configuration
#' applies to all clusters created in your account for the current Region.
#' The configuration specifies whether block public access is enabled. If
#' block public access is enabled, security groups associated with the
#' cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
#' ::/0 on a port, unless the port is specified as an exception using
#' `PermittedPublicSecurityGroupRuleRanges` in the
#' `BlockPublicAccessConfiguration`. By default, Port 22 (SSH) is an
#' exception, and public access is allowed on this port. You can change
#' this by updating `BlockPublicSecurityGroupRules` to remove the
#' exception.
#' 
#' For accounts that created clusters in a Region before November 25, 2019,
#' block public access is disabled by default in that Region. To use this
#' feature, you must manually enable and configure it. For accounts that
#' did not create an EMR cluster in a Region before this date, block public
#' access is enabled by default in that Region.
#'
#' @section Request syntax:
#' ```
#' svc$put_block_public_access_configuration(
#'   BlockPublicAccessConfiguration = list(
#'     BlockPublicSecurityGroupRules = TRUE|FALSE,
#'     PermittedPublicSecurityGroupRuleRanges = list(
#'       list(
#'         MinRange = 123,
#'         MaxRange = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_put_block_public_access_configuration
emr_put_block_public_access_configuration <- function(BlockPublicAccessConfiguration) {
  op <- new_operation(
    name = "PutBlockPublicAccessConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_block_public_access_configuration_input(BlockPublicAccessConfiguration = BlockPublicAccessConfiguration)
  output <- .emr$put_block_public_access_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_block_public_access_configuration <- emr_put_block_public_access_configuration

#' Creates or updates a managed scaling policy for an Amazon EMR cluster
#'
#' Creates or updates a managed scaling policy for an Amazon EMR cluster.
#' The managed scaling policy defines the limits for resources, such as EC2
#' instances that can be added or terminated from a cluster. The policy
#' only applies to the core and task nodes. The master node cannot be
#' scaled after initial configuration.
#'
#' @usage
#' emr_put_managed_scaling_policy(ClusterId, ManagedScalingPolicy)
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of an EMR cluster where the managed scaling policy is
#' attached.
#' @param ManagedScalingPolicy &#91;required&#93; Specifies the constraints for the managed scaling policy.
#'
#' @section Request syntax:
#' ```
#' svc$put_managed_scaling_policy(
#'   ClusterId = "string",
#'   ManagedScalingPolicy = list(
#'     ComputeLimits = list(
#'       UnitType = "InstanceFleetUnits"|"Instances"|"VCPU",
#'       MinimumCapacityUnits = 123,
#'       MaximumCapacityUnits = 123,
#'       MaximumOnDemandCapacityUnits = 123,
#'       MaximumCoreCapacityUnits = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_put_managed_scaling_policy
emr_put_managed_scaling_policy <- function(ClusterId, ManagedScalingPolicy) {
  op <- new_operation(
    name = "PutManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_managed_scaling_policy_input(ClusterId = ClusterId, ManagedScalingPolicy = ManagedScalingPolicy)
  output <- .emr$put_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_managed_scaling_policy <- emr_put_managed_scaling_policy

#' Removes an automatic scaling policy from a specified instance group
#' within an EMR cluster
#'
#' Removes an automatic scaling policy from a specified instance group
#' within an EMR cluster.
#'
#' @usage
#' emr_remove_auto_scaling_policy(ClusterId, InstanceGroupId)
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of a cluster. The instance group to which the automatic
#' scaling policy is applied is within this cluster.
#' @param InstanceGroupId &#91;required&#93; Specifies the ID of the instance group to which the scaling policy is
#' applied.
#'
#' @section Request syntax:
#' ```
#' svc$remove_auto_scaling_policy(
#'   ClusterId = "string",
#'   InstanceGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_remove_auto_scaling_policy
emr_remove_auto_scaling_policy <- function(ClusterId, InstanceGroupId) {
  op <- new_operation(
    name = "RemoveAutoScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_auto_scaling_policy_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId)
  output <- .emr$remove_auto_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_auto_scaling_policy <- emr_remove_auto_scaling_policy

#' Removes a managed scaling policy from a specified EMR cluster
#'
#' Removes a managed scaling policy from a specified EMR cluster.
#'
#' @usage
#' emr_remove_managed_scaling_policy(ClusterId)
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the cluster from which the managed scaling policy
#' will be removed.
#'
#' @section Request syntax:
#' ```
#' svc$remove_managed_scaling_policy(
#'   ClusterId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_remove_managed_scaling_policy
emr_remove_managed_scaling_policy <- function(ClusterId) {
  op <- new_operation(
    name = "RemoveManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_managed_scaling_policy_input(ClusterId = ClusterId)
  output <- .emr$remove_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_managed_scaling_policy <- emr_remove_managed_scaling_policy

#' Removes tags from an Amazon EMR resource
#'
#' Removes tags from an Amazon EMR resource. Tags make it easier to
#' associate clusters in various ways, such as grouping clusters to track
#' your Amazon EMR resource allocation costs. For more information, see
#' [Tag
#' Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
#' 
#' The following example removes the stack tag with value Prod from a
#' cluster:
#'
#' @usage
#' emr_remove_tags(ResourceId, TagKeys)
#'
#' @param ResourceId &#91;required&#93; The Amazon EMR resource identifier from which tags will be removed. This
#' value must be a cluster identifier.
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from a resource.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags(
#'   ResourceId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_remove_tags
emr_remove_tags <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_tags_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .emr$remove_tags_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_tags <- emr_remove_tags

#' RunJobFlow creates and starts running a new cluster (job flow)
#'
#' RunJobFlow creates and starts running a new cluster (job flow). The
#' cluster runs the steps specified. After the steps complete, the cluster
#' stops and the HDFS partition is lost. To prevent loss of data, configure
#' the last step of the job flow to store results in Amazon S3. If the
#' JobFlowInstancesConfig `KeepJobFlowAliveWhenNoSteps` parameter is set to
#' `TRUE`, the cluster transitions to the WAITING state rather than
#' shutting down after the steps have completed.
#' 
#' For additional protection, you can set the JobFlowInstancesConfig
#' `TerminationProtected` parameter to `TRUE` to lock the cluster and
#' prevent it from being terminated by API call, user intervention, or in
#' the event of a job flow error.
#' 
#' A maximum of 256 steps are allowed in each job flow.
#' 
#' If your cluster is long-running (such as a Hive data warehouse) or
#' complex, you may require more than 256 steps to process your data. You
#' can bypass the 256-step limitation in various ways, including using the
#' SSH shell to connect to the master node and submitting queries directly
#' to the software running on the master node, such as Hive and Hadoop. For
#' more information on how to do this, see [Add More than 256 Steps to a
#' Cluster](https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html)
#' in the *Amazon EMR Management Guide*.
#' 
#' For long running clusters, we recommend that you periodically store your
#' results.
#' 
#' The instance fleets configuration is available only in Amazon EMR
#' versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow
#' request can contain InstanceFleets parameters or InstanceGroups
#' parameters, but not both.
#'
#' @usage
#' emr_run_job_flow(Name, LogUri, LogEncryptionKmsKeyId, AdditionalInfo,
#'   AmiVersion, ReleaseLabel, Instances, Steps, BootstrapActions,
#'   SupportedProducts, NewSupportedProducts, Applications, Configurations,
#'   VisibleToAllUsers, JobFlowRole, ServiceRole, Tags,
#'   SecurityConfiguration, AutoScalingRole, ScaleDownBehavior, CustomAmiId,
#'   EbsRootVolumeSize, RepoUpgradeOnBoot, KerberosAttributes,
#'   StepConcurrencyLevel, ManagedScalingPolicy)
#'
#' @param Name &#91;required&#93; The name of the job flow.
#' @param LogUri The location in Amazon S3 to write the log files of the job flow. If a
#' value is not provided, logs are not created.
#' @param LogEncryptionKmsKeyId The AWS KMS customer master key (CMK) used for encrypting log files. If
#' a value is not provided, the logs will remain encrypted by AES-256. This
#' attribute is only available with EMR version 5.30.0 and later, excluding
#' EMR 6.0.0.
#' @param AdditionalInfo A JSON string for selecting additional features.
#' @param AmiVersion Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR
#' releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI,
#' use `CustomAmiID`.
#' @param ReleaseLabel The Amazon EMR release label, which determines the version of
#' open-source application packages installed on the cluster. Release
#' labels are in the form `emr-x.x.x`, where x.x.x is an Amazon EMR release
#' version such as `emr-5.14.0`. For more information about Amazon EMR
#' release versions and included application versions and features, see
#' <https://docs.aws.amazon.com/emr/latest/ReleaseGuide/>. The release
#' label applies only to Amazon EMR releases version 4.0 and later. Earlier
#' versions use `AmiVersion`.
#' @param Instances &#91;required&#93; A specification of the number and type of Amazon EC2 instances.
#' @param Steps A list of steps to run.
#' @param BootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster
#' nodes.
#' @param SupportedProducts For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
#' later, use Applications.
#' 
#' A list of strings that indicates third-party software to use. For more
#' information, see the [Amazon EMR Developer
#' Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf).
#' Currently supported values are:
#' 
#' -   \"mapr-m3\" - launch the job flow using MapR M3 Edition.
#' 
#' -   \"mapr-m5\" - launch the job flow using MapR M5 Edition.
#' @param NewSupportedProducts For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
#' later, use Applications.
#' 
#' A list of strings that indicates third-party software to use with the
#' job flow that accepts a user argument list. EMR accepts and forwards the
#' argument list to the corresponding installation script as bootstrap
#' action arguments. For more information, see \"Launch a Job Flow on the
#' MapR Distribution for Hadoop\" in the [Amazon EMR Developer
#' Guide](https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf).
#' Supported values are:
#' 
#' -   \"mapr-m3\" - launch the cluster using MapR M3 Edition.
#' 
#' -   \"mapr-m5\" - launch the cluster using MapR M5 Edition.
#' 
#' -   \"mapr\" with the user arguments specifying \"\\--edition,m3\" or
#'     \"\\--edition,m5\" - launch the job flow using MapR M3 or M5 Edition
#'     respectively.
#' 
#' -   \"mapr-m7\" - launch the cluster using MapR M7 Edition.
#' 
#' -   \"hunk\" - launch the cluster with the Hunk Big Data Analtics
#'     Platform.
#' 
#' -   \"hue\"- launch the cluster with Hue installed.
#' 
#' -   \"spark\" - launch the cluster with Apache Spark installed.
#' 
#' -   \"ganglia\" - launch the cluster with the Ganglia Monitoring System
#'     installed.
#' @param Applications Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of
#' applications for Amazon EMR to install and configure when launching the
#' cluster. For a list of applications available for each Amazon EMR
#' release version, see the [Amazon EMR Release
#' Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/).
#' @param Configurations For Amazon EMR releases 4.0 and later. The list of configurations
#' supplied for the EMR cluster you are creating.
#' @param VisibleToAllUsers A value of `true` indicates that all IAM users in the AWS account can
#' perform cluster actions if they have the proper IAM policy permissions.
#' This is the default. A value of `false` indicates that only the IAM user
#' who created the cluster can perform actions.
#' @param JobFlowRole Also called instance profile and EC2 role. An IAM role for an EMR
#' cluster. The EC2 instances of the cluster assume this role. The default
#' role is `EMR_EC2_DefaultRole`. In order to use the default role, you
#' must have already created it using the CLI or console.
#' @param ServiceRole The IAM role that will be assumed by the Amazon EMR service to access
#' AWS resources on your behalf.
#' @param Tags A list of tags to associate with a cluster and propagate to Amazon EC2
#' instances.
#' @param SecurityConfiguration The name of a security configuration to apply to the cluster.
#' @param AutoScalingRole An IAM role for automatic scaling policies. The default role is
#' `EMR_AutoScaling_DefaultRole`. The IAM role provides permissions that
#' the automatic scaling feature requires to launch and terminate EC2
#' instances in an instance group.
#' @param ScaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an
#' automatic scale-in activity occurs or an instance group is resized.
#' `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes
#' at the instance-hour boundary, regardless of when the request to
#' terminate the instance was submitted. This option is only available with
#' Amazon EMR 5.1.0 and later and is the default for clusters created using
#' that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR
#' blacklists and drains tasks from nodes before terminating the Amazon EC2
#' instances, regardless of the instance-hour boundary. With either
#' behavior, Amazon EMR removes the least active nodes first and blocks
#' instance termination if it could lead to HDFS corruption.
#' `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version
#' 4.1.0 and later, and is the default for versions of Amazon EMR earlier
#' than 5.1.0.
#' @param CustomAmiId Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
#' Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when
#' it launches cluster EC2 instances. For more information about custom
#' AMIs in Amazon EMR, see [Using a Custom
#' AMI](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html)
#' in the *Amazon EMR Management Guide*. If omitted, the cluster uses the
#' base Linux AMI for the `ReleaseLabel` specified. For Amazon EMR versions
#' 2.x and 3.x, use `AmiVersion` instead.
#' 
#' For information about creating a custom AMI, see [Creating an Amazon
#' EBS-Backed Linux
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
#' in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*.
#' For information about finding an AMI ID, see [Finding a Linux
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html).
#' @param EbsRootVolumeSize The size, in GiB, of the EBS root device volume of the Linux AMI that is
#' used for each EC2 instance. Available in Amazon EMR version 4.x and
#' later.
#' @param RepoUpgradeOnBoot Applies only when `CustomAmiID` is used. Specifies which updates from
#' the Amazon Linux AMI package repositories to apply automatically when
#' the instance boots using the AMI. If omitted, the default is `SECURITY`,
#' which indicates that only security updates are applied. If `NONE` is
#' specified, no updates are applied, and all updates must be applied
#' manually.
#' @param KerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is
#' enabled using a security configuration. For more information see [Use
#' Kerberos
#' Authentication](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
#' in the *EMR Management Guide*.
#' @param StepConcurrencyLevel Specifies the number of steps that can be executed concurrently. The
#' default value is `1`. The maximum value is `256`.
#' @param ManagedScalingPolicy The specified managed scaling policy for an Amazon EMR cluster.
#'
#' @section Request syntax:
#' ```
#' svc$run_job_flow(
#'   Name = "string",
#'   LogUri = "string",
#'   LogEncryptionKmsKeyId = "string",
#'   AdditionalInfo = "string",
#'   AmiVersion = "string",
#'   ReleaseLabel = "string",
#'   Instances = list(
#'     MasterInstanceType = "string",
#'     SlaveInstanceType = "string",
#'     InstanceCount = 123,
#'     InstanceGroups = list(
#'       list(
#'         Name = "string",
#'         Market = "ON_DEMAND"|"SPOT",
#'         InstanceRole = "MASTER"|"CORE"|"TASK",
#'         BidPrice = "string",
#'         InstanceType = "string",
#'         InstanceCount = 123,
#'         Configurations = list(
#'           list(
#'             Classification = "string",
#'             Configurations = list(),
#'             Properties = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         EbsConfiguration = list(
#'           EbsBlockDeviceConfigs = list(
#'             list(
#'               VolumeSpecification = list(
#'                 VolumeType = "string",
#'                 Iops = 123,
#'                 SizeInGB = 123
#'               ),
#'               VolumesPerInstance = 123
#'             )
#'           ),
#'           EbsOptimized = TRUE|FALSE
#'         ),
#'         AutoScalingPolicy = list(
#'           Constraints = list(
#'             MinCapacity = 123,
#'             MaxCapacity = 123
#'           ),
#'           Rules = list(
#'             list(
#'               Name = "string",
#'               Description = "string",
#'               Action = list(
#'                 Market = "ON_DEMAND"|"SPOT",
#'                 SimpleScalingPolicyConfiguration = list(
#'                   AdjustmentType = "CHANGE_IN_CAPACITY"|"PERCENT_CHANGE_IN_CAPACITY"|"EXACT_CAPACITY",
#'                   ScalingAdjustment = 123,
#'                   CoolDown = 123
#'                 )
#'               ),
#'               Trigger = list(
#'                 CloudWatchAlarmDefinition = list(
#'                   ComparisonOperator = "GREATER_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"LESS_THAN_OR_EQUAL",
#'                   EvaluationPeriods = 123,
#'                   MetricName = "string",
#'                   Namespace = "string",
#'                   Period = 123,
#'                   Statistic = "SAMPLE_COUNT"|"AVERAGE"|"SUM"|"MINIMUM"|"MAXIMUM",
#'                   Threshold = 123.0,
#'                   Unit = "NONE"|"SECONDS"|"MICRO_SECONDS"|"MILLI_SECONDS"|"BYTES"|"KILO_BYTES"|"MEGA_BYTES"|"GIGA_BYTES"|"TERA_BYTES"|"BITS"|"KILO_BITS"|"MEGA_BITS"|"GIGA_BITS"|"TERA_BITS"|"PERCENT"|"COUNT"|"BYTES_PER_SECOND"|"KILO_BYTES_PER_SECOND"|"MEGA_BYTES_PER_SECOND"|"GIGA_BYTES_PER_SECOND"|"TERA_BYTES_PER_SECOND"|"BITS_PER_SECOND"|"KILO_BITS_PER_SECOND"|"MEGA_BITS_PER_SECOND"|"GIGA_BITS_PER_SECOND"|"TERA_BITS_PER_SECOND"|"COUNT_PER_SECOND",
#'                   Dimensions = list(
#'                     list(
#'                       Key = "string",
#'                       Value = "string"
#'                     )
#'                   )
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     InstanceFleets = list(
#'       list(
#'         Name = "string",
#'         InstanceFleetType = "MASTER"|"CORE"|"TASK",
#'         TargetOnDemandCapacity = 123,
#'         TargetSpotCapacity = 123,
#'         InstanceTypeConfigs = list(
#'           list(
#'             InstanceType = "string",
#'             WeightedCapacity = 123,
#'             BidPrice = "string",
#'             BidPriceAsPercentageOfOnDemandPrice = 123.0,
#'             EbsConfiguration = list(
#'               EbsBlockDeviceConfigs = list(
#'                 list(
#'                   VolumeSpecification = list(
#'                     VolumeType = "string",
#'                     Iops = 123,
#'                     SizeInGB = 123
#'                   ),
#'                   VolumesPerInstance = 123
#'                 )
#'               ),
#'               EbsOptimized = TRUE|FALSE
#'             ),
#'             Configurations = list(
#'               list(
#'                 Classification = "string",
#'                 Configurations = list(),
#'                 Properties = list(
#'                   "string"
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         LaunchSpecifications = list(
#'           SpotSpecification = list(
#'             TimeoutDurationMinutes = 123,
#'             TimeoutAction = "SWITCH_TO_ON_DEMAND"|"TERMINATE_CLUSTER",
#'             BlockDurationMinutes = 123,
#'             AllocationStrategy = "capacity-optimized"
#'           ),
#'           OnDemandSpecification = list(
#'             AllocationStrategy = "lowest-price"
#'           )
#'         )
#'       )
#'     ),
#'     Ec2KeyName = "string",
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       AvailabilityZones = list(
#'         "string"
#'       )
#'     ),
#'     KeepJobFlowAliveWhenNoSteps = TRUE|FALSE,
#'     TerminationProtected = TRUE|FALSE,
#'     HadoopVersion = "string",
#'     Ec2SubnetId = "string",
#'     Ec2SubnetIds = list(
#'       "string"
#'     ),
#'     EmrManagedMasterSecurityGroup = "string",
#'     EmrManagedSlaveSecurityGroup = "string",
#'     ServiceAccessSecurityGroup = "string",
#'     AdditionalMasterSecurityGroups = list(
#'       "string"
#'     ),
#'     AdditionalSlaveSecurityGroups = list(
#'       "string"
#'     )
#'   ),
#'   Steps = list(
#'     list(
#'       Name = "string",
#'       ActionOnFailure = "TERMINATE_JOB_FLOW"|"TERMINATE_CLUSTER"|"CANCEL_AND_WAIT"|"CONTINUE",
#'       HadoopJarStep = list(
#'         Properties = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         ),
#'         Jar = "string",
#'         MainClass = "string",
#'         Args = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   BootstrapActions = list(
#'     list(
#'       Name = "string",
#'       ScriptBootstrapAction = list(
#'         Path = "string",
#'         Args = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   SupportedProducts = list(
#'     "string"
#'   ),
#'   NewSupportedProducts = list(
#'     list(
#'       Name = "string",
#'       Args = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Applications = list(
#'     list(
#'       Name = "string",
#'       Version = "string",
#'       Args = list(
#'         "string"
#'       ),
#'       AdditionalInfo = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Configurations = list(
#'     list(
#'       Classification = "string",
#'       Configurations = list(),
#'       Properties = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   VisibleToAllUsers = TRUE|FALSE,
#'   JobFlowRole = "string",
#'   ServiceRole = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   SecurityConfiguration = "string",
#'   AutoScalingRole = "string",
#'   ScaleDownBehavior = "TERMINATE_AT_INSTANCE_HOUR"|"TERMINATE_AT_TASK_COMPLETION",
#'   CustomAmiId = "string",
#'   EbsRootVolumeSize = 123,
#'   RepoUpgradeOnBoot = "SECURITY"|"NONE",
#'   KerberosAttributes = list(
#'     Realm = "string",
#'     KdcAdminPassword = "string",
#'     CrossRealmTrustPrincipalPassword = "string",
#'     ADDomainJoinUser = "string",
#'     ADDomainJoinPassword = "string"
#'   ),
#'   StepConcurrencyLevel = 123,
#'   ManagedScalingPolicy = list(
#'     ComputeLimits = list(
#'       UnitType = "InstanceFleetUnits"|"Instances"|"VCPU",
#'       MinimumCapacityUnits = 123,
#'       MaximumCapacityUnits = 123,
#'       MaximumOnDemandCapacityUnits = 123,
#'       MaximumCoreCapacityUnits = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_run_job_flow
emr_run_job_flow <- function(Name, LogUri = NULL, LogEncryptionKmsKeyId = NULL, AdditionalInfo = NULL, AmiVersion = NULL, ReleaseLabel = NULL, Instances, Steps = NULL, BootstrapActions = NULL, SupportedProducts = NULL, NewSupportedProducts = NULL, Applications = NULL, Configurations = NULL, VisibleToAllUsers = NULL, JobFlowRole = NULL, ServiceRole = NULL, Tags = NULL, SecurityConfiguration = NULL, AutoScalingRole = NULL, ScaleDownBehavior = NULL, CustomAmiId = NULL, EbsRootVolumeSize = NULL, RepoUpgradeOnBoot = NULL, KerberosAttributes = NULL, StepConcurrencyLevel = NULL, ManagedScalingPolicy = NULL) {
  op <- new_operation(
    name = "RunJobFlow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$run_job_flow_input(Name = Name, LogUri = LogUri, LogEncryptionKmsKeyId = LogEncryptionKmsKeyId, AdditionalInfo = AdditionalInfo, AmiVersion = AmiVersion, ReleaseLabel = ReleaseLabel, Instances = Instances, Steps = Steps, BootstrapActions = BootstrapActions, SupportedProducts = SupportedProducts, NewSupportedProducts = NewSupportedProducts, Applications = Applications, Configurations = Configurations, VisibleToAllUsers = VisibleToAllUsers, JobFlowRole = JobFlowRole, ServiceRole = ServiceRole, Tags = Tags, SecurityConfiguration = SecurityConfiguration, AutoScalingRole = AutoScalingRole, ScaleDownBehavior = ScaleDownBehavior, CustomAmiId = CustomAmiId, EbsRootVolumeSize = EbsRootVolumeSize, RepoUpgradeOnBoot = RepoUpgradeOnBoot, KerberosAttributes = KerberosAttributes, StepConcurrencyLevel = StepConcurrencyLevel, ManagedScalingPolicy = ManagedScalingPolicy)
  output <- .emr$run_job_flow_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$run_job_flow <- emr_run_job_flow

#' SetTerminationProtection locks a cluster (job flow) so the EC2 instances
#' in the cluster cannot be terminated by user intervention, an API call,
#' or in the event of a job-flow error
#'
#' SetTerminationProtection locks a cluster (job flow) so the EC2 instances
#' in the cluster cannot be terminated by user intervention, an API call,
#' or in the event of a job-flow error. The cluster still terminates upon
#' successful completion of the job flow. Calling
#' `SetTerminationProtection` on a cluster is similar to calling the Amazon
#' EC2 `DisableAPITermination` API on all EC2 instances in a cluster.
#' 
#' `SetTerminationProtection` is used to prevent accidental termination of
#' a cluster and to ensure that in the event of an error, the instances
#' persist so that you can recover any data stored in their ephemeral
#' instance storage.
#' 
#' To terminate a cluster that has been locked by setting
#' `SetTerminationProtection` to `true`, you must first unlock the job flow
#' by a subsequent call to `SetTerminationProtection` in which you set the
#' value to `false`.
#' 
#' For more information, see[Managing Cluster
#' Termination](https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html)
#' in the *Amazon EMR Management Guide*.
#'
#' @usage
#' emr_set_termination_protection(JobFlowIds, TerminationProtected)
#'
#' @param JobFlowIds &#91;required&#93; A list of strings that uniquely identify the clusters to protect. This
#' identifier is returned by RunJobFlow and can also be obtained from
#' DescribeJobFlows .
#' @param TerminationProtected &#91;required&#93; A Boolean that indicates whether to protect the cluster and prevent the
#' Amazon EC2 instances in the cluster from shutting down due to API calls,
#' user intervention, or job-flow error.
#'
#' @section Request syntax:
#' ```
#' svc$set_termination_protection(
#'   JobFlowIds = list(
#'     "string"
#'   ),
#'   TerminationProtected = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_set_termination_protection
emr_set_termination_protection <- function(JobFlowIds, TerminationProtected) {
  op <- new_operation(
    name = "SetTerminationProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$set_termination_protection_input(JobFlowIds = JobFlowIds, TerminationProtected = TerminationProtected)
  output <- .emr$set_termination_protection_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$set_termination_protection <- emr_set_termination_protection

#' Sets the Cluster$VisibleToAllUsers value, which determines whether the
#' cluster is visible to all IAM users of the AWS account associated with
#' the cluster
#'
#' Sets the Cluster\\$VisibleToAllUsers value, which determines whether the
#' cluster is visible to all IAM users of the AWS account associated with
#' the cluster. Only the IAM user who created the cluster or the AWS
#' account root user can call this action. The default value, `true`,
#' indicates that all IAM users in the AWS account can perform cluster
#' actions if they have the proper IAM policy permissions. If set to
#' `false`, only the IAM user that created the cluster can perform actions.
#' This action works on running clusters. You can override the default
#' `true` setting when you create a cluster by using the
#' `VisibleToAllUsers` parameter with `RunJobFlow`.
#'
#' @usage
#' emr_set_visible_to_all_users(JobFlowIds, VisibleToAllUsers)
#'
#' @param JobFlowIds &#91;required&#93; The unique identifier of the job flow (cluster).
#' @param VisibleToAllUsers &#91;required&#93; A value of `true` indicates that all IAM users in the AWS account can
#' perform cluster actions if they have the proper IAM policy permissions.
#' This is the default. A value of `false` indicates that only the IAM user
#' who created the cluster can perform actions.
#'
#' @section Request syntax:
#' ```
#' svc$set_visible_to_all_users(
#'   JobFlowIds = list(
#'     "string"
#'   ),
#'   VisibleToAllUsers = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_set_visible_to_all_users
emr_set_visible_to_all_users <- function(JobFlowIds, VisibleToAllUsers) {
  op <- new_operation(
    name = "SetVisibleToAllUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$set_visible_to_all_users_input(JobFlowIds = JobFlowIds, VisibleToAllUsers = VisibleToAllUsers)
  output <- .emr$set_visible_to_all_users_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$set_visible_to_all_users <- emr_set_visible_to_all_users

#' TerminateJobFlows shuts a list of clusters (job flows) down
#'
#' TerminateJobFlows shuts a list of clusters (job flows) down. When a job
#' flow is shut down, any step not yet completed is canceled and the EC2
#' instances on which the cluster is running are stopped. Any log files not
#' already saved are uploaded to Amazon S3 if a LogUri was specified when
#' the cluster was created.
#' 
#' The maximum number of clusters allowed is 10. The call to
#' `TerminateJobFlows` is asynchronous. Depending on the configuration of
#' the cluster, it may take up to 1-5 minutes for the cluster to completely
#' terminate and release allocated resources, such as Amazon EC2 instances.
#'
#' @usage
#' emr_terminate_job_flows(JobFlowIds)
#'
#' @param JobFlowIds &#91;required&#93; A list of job flows to be shutdown.
#'
#' @section Request syntax:
#' ```
#' svc$terminate_job_flows(
#'   JobFlowIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname emr_terminate_job_flows
emr_terminate_job_flows <- function(JobFlowIds) {
  op <- new_operation(
    name = "TerminateJobFlows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$terminate_job_flows_input(JobFlowIds = JobFlowIds)
  output <- .emr$terminate_job_flows_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$terminate_job_flows <- emr_terminate_job_flows
