% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_tags_for_resource}
\alias{athena_list_tags_for_resource}
\title{Lists the tags associated with an Athena workgroup or data catalog
resource}
\usage{
athena_list_tags_for_resource(ResourceARN, NextToken, MaxResults)
}
\arguments{
\item{ResourceARN}{[required] Lists the tags for the resource with the specified ARN.}

\item{NextToken}{The token for the next set of results, or null if there are no
additional results for this request, where the request lists the tags
for the resource with the specified ARN.}

\item{MaxResults}{The maximum number of results to be returned per request that lists the
tags for the resource.}
}
\description{
Lists the tags associated with an Athena workgroup or data catalog
resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
