% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_database}
\alias{glue_create_database}
\title{Creates a new database in a Data Catalog}
\usage{
glue_create_database(CatalogId, DatabaseInput)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which to create the database. If none is
provided, the AWS account ID is used by default.}

\item{DatabaseInput}{[required] The metadata for the database.}
}
\description{
Creates a new database in a Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$create_database(
  CatalogId = "string",
  DatabaseInput = list(
    Name = "string",
    Description = "string",
    LocationUri = "string",
    Parameters = list(
      "string"
    ),
    CreateTableDefaultPermissions = list(
      list(
        Principal = list(
          DataLakePrincipalIdentifier = "string"
        ),
        Permissions = list(
          "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
        )
      )
    ),
    TargetDatabase = list(
      CatalogId = "string",
      DatabaseName = "string"
    )
  )
)
}
}

\keyword{internal}
