% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_query}
\alias{kendra_query}
\title{Searches an active index}
\usage{
kendra_query(
  IndexId,
  QueryText = NULL,
  AttributeFilter = NULL,
  Facets = NULL,
  RequestedDocumentAttributes = NULL,
  QueryResultTypeFilter = NULL,
  DocumentRelevanceOverrideConfigurations = NULL,
  PageNumber = NULL,
  PageSize = NULL,
  SortingConfiguration = NULL,
  UserContext = NULL,
  VisitorId = NULL,
  SpellCorrectionConfiguration = NULL
)
}
\arguments{
\item{IndexId}{[required] The unique identifier of the index to search. The identifier is returned
in the response from the \code{\link[=kendra_create_index]{create_index}} API.}

\item{QueryText}{The text to search for.}

\item{AttributeFilter}{Enables filtered searches based on document attributes. You can only
provide one attribute filter; however, the \code{AndAllFilters}, \code{NotFilter},
and \code{OrAllFilters} parameters contain a list of other filters.

The \code{AttributeFilter} parameter enables you to create a set of filtering
rules that a document must satisfy to be included in the query results.}

\item{Facets}{An array of documents attributes. Amazon Kendra returns a count for each
attribute key specified. This helps your users narrow their search.}

\item{RequestedDocumentAttributes}{An array of document attributes to include in the response. You can
limit the response to include certain document attributes. By default
all document attributes are included in the response.}

\item{QueryResultTypeFilter}{Sets the type of query. Only results for the specified query type are
returned.}

\item{DocumentRelevanceOverrideConfigurations}{Overrides relevance tuning configurations of fields or attributes set at
the index level.

If you use this API to override the relevance tuning configured at the
index level, but there is no relevance tuning configured at the index
level, then Amazon Kendra does not apply any relevance tuning.

If there is relevance tuning configured at the index level, but you do
not use this API to override any relevance tuning in the index, then
Amazon Kendra uses the relevance tuning that is configured at the index
level.

If there is relevance tuning configured for fields at the index level,
but you use this API to override only some of these fields, then for the
fields you did not override, the importance is set to 1.}

\item{PageNumber}{Query results are returned in pages the size of the \code{PageSize}
parameter. By default, Amazon Kendra returns the first page of results.
Use this parameter to get result pages after the first one.}

\item{PageSize}{Sets the number of results that are returned in each page of results.
The default page size is 10. The maximum number of results returned is
100. If you ask for more than 100 results, only 100 are returned.}

\item{SortingConfiguration}{Provides information that determines how the results of the query are
sorted. You can set the field that Amazon Kendra should sort the results
on, and specify whether the results should be sorted in ascending or
descending order. In the case of ties in sorting the results, the
results are sorted by relevance.

If you don't provide sorting configuration, the results are sorted by
the relevance that Amazon Kendra determines for the result.}

\item{UserContext}{The user context token or user and group information.}

\item{VisitorId}{Provides an identifier for a specific user. The \code{VisitorId} should be a
unique identifier, such as a GUID. Don't use personally identifiable
information, such as the user's email address, as the \code{VisitorId}.}

\item{SpellCorrectionConfiguration}{Enables suggested spell corrections for queries.}
}
\description{
Searches an active index. Use this API to search your documents using query. The \code{\link[=kendra_query]{query}} API enables to do faceted search and to filter results based on document attributes.

See \url{https://paws-r.github.io/docs/kendra/query.html} for full documentation.
}
\keyword{internal}
