% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_template}
\alias{quicksight_create_template}
\title{Creates a template from an existing Amazon QuickSight analysis or
template}
\usage{
quicksight_create_template(
  AwsAccountId,
  TemplateId,
  Name = NULL,
  Permissions = NULL,
  SourceEntity,
  Tags = NULL,
  VersionDescription = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that the group is in. You use
the ID for the Amazon Web Services account that contains your Amazon
QuickSight account.}

\item{TemplateId}{[required] An ID for the template that you want to create. This template is unique
per Amazon Web Services Region; in each Amazon Web Services account.}

\item{Name}{A display name for the template.}

\item{Permissions}{A list of resource permissions to be set on the template.}

\item{SourceEntity}{[required] The entity that you are using as a source when you create the template.
In \code{SourceEntity}, you specify the type of object you're using as
source: \code{SourceTemplate} for a template or \code{SourceAnalysis} for an
analysis. Both of these require an Amazon Resource Name (ARN). For
\code{SourceTemplate}, specify the ARN of the source template. For
\code{SourceAnalysis}, specify the ARN of the source analysis. The
\code{SourceTemplate} ARN can contain any Amazon Web Services account and any
Amazon QuickSight-supported Amazon Web Services Region.

Use the \code{DataSetReferences} entity within \code{SourceTemplate} or
\code{SourceAnalysis} to list the replacement datasets for the placeholders
listed in the original. The schema in each dataset must match its
placeholder.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the resource.}

\item{VersionDescription}{A description of the current template version being created. This API
operation creates the first version of the template. Every time
\code{\link[=quicksight_update_template]{update_template}} is called, a new version
is created. Each version of the template maintains a description of the
version in the \code{VersionDescription} field.}
}
\description{
Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.

See \url{https://paws-r.github.io/docs/quicksight/create_template.html} for full documentation.
}
\keyword{internal}
