# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kendra_service.R
NULL

#' Grants users or groups in your IAM Identity Center identity source
#' access to your Amazon Kendra experience
#'
#' @description
#' Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_associate_entities_to_experience/](https://www.paws-r-sdk.com/docs/kendra_associate_entities_to_experience/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param EntityList &#91;required&#93; Lists users or groups in your IAM Identity Center identity source.
#'
#' @keywords internal
#'
#' @rdname kendra_associate_entities_to_experience
kendra_associate_entities_to_experience <- function(Id, IndexId, EntityList) {
  op <- new_operation(
    name = "AssociateEntitiesToExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$associate_entities_to_experience_input(Id = Id, IndexId = IndexId, EntityList = EntityList)
  output <- .kendra$associate_entities_to_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$associate_entities_to_experience <- kendra_associate_entities_to_experience

#' Defines the specific permissions of users or groups in your IAM Identity
#' Center identity source with access to your Amazon Kendra experience
#'
#' @description
#' Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_associate_personas_to_entities/](https://www.paws-r-sdk.com/docs/kendra_associate_personas_to_entities/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param Personas &#91;required&#93; The personas that define the specific permissions of users or groups in
#' your IAM Identity Center identity source. The available personas or
#' access roles are `Owner` and `Viewer`. For more information on these
#' personas, see [Providing access to your search
#' page](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
#'
#' @keywords internal
#'
#' @rdname kendra_associate_personas_to_entities
kendra_associate_personas_to_entities <- function(Id, IndexId, Personas) {
  op <- new_operation(
    name = "AssociatePersonasToEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$associate_personas_to_entities_input(Id = Id, IndexId = IndexId, Personas = Personas)
  output <- .kendra$associate_personas_to_entities_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$associate_personas_to_entities <- kendra_associate_personas_to_entities

#' Removes one or more documents from an index
#'
#' @description
#' Removes one or more documents from an index. The documents must have been added with the [`batch_put_document`][kendra_batch_put_document] API.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_batch_delete_document/](https://www.paws-r-sdk.com/docs/kendra_batch_delete_document/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index that contains the documents to delete.
#' @param DocumentIdList &#91;required&#93; One or more identifiers for documents to delete from the index.
#' @param DataSourceSyncJobMetricTarget 
#'
#' @keywords internal
#'
#' @rdname kendra_batch_delete_document
kendra_batch_delete_document <- function(IndexId, DocumentIdList, DataSourceSyncJobMetricTarget = NULL) {
  op <- new_operation(
    name = "BatchDeleteDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$batch_delete_document_input(IndexId = IndexId, DocumentIdList = DocumentIdList, DataSourceSyncJobMetricTarget = DataSourceSyncJobMetricTarget)
  output <- .kendra$batch_delete_document_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$batch_delete_document <- kendra_batch_delete_document

#' Removes one or more sets of featured results
#'
#' @description
#' Removes one or more sets of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_batch_delete_featured_results_set/](https://www.paws-r-sdk.com/docs/kendra_batch_delete_featured_results_set/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index used for featuring results.
#' @param FeaturedResultsSetIds &#91;required&#93; The identifiers of the featured results sets that you want to delete.
#'
#' @keywords internal
#'
#' @rdname kendra_batch_delete_featured_results_set
kendra_batch_delete_featured_results_set <- function(IndexId, FeaturedResultsSetIds) {
  op <- new_operation(
    name = "BatchDeleteFeaturedResultsSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$batch_delete_featured_results_set_input(IndexId = IndexId, FeaturedResultsSetIds = FeaturedResultsSetIds)
  output <- .kendra$batch_delete_featured_results_set_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$batch_delete_featured_results_set <- kendra_batch_delete_featured_results_set

#' Returns the indexing status for one or more documents submitted with the
#' BatchPutDocument API
#'
#' @description
#' Returns the indexing status for one or more documents submitted with the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/APIReference/API_BatchPutDocument.html) API.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_batch_get_document_status/](https://www.paws-r-sdk.com/docs/kendra_batch_get_document_status/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index to add documents to. The index ID is
#' returned by the
#' [CreateIndex](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html)
#' API.
#' @param DocumentInfoList &#91;required&#93; A list of `DocumentInfo` objects that identify the documents for which
#' to get the status. You identify the documents by their document ID and
#' optional attributes.
#'
#' @keywords internal
#'
#' @rdname kendra_batch_get_document_status
kendra_batch_get_document_status <- function(IndexId, DocumentInfoList) {
  op <- new_operation(
    name = "BatchGetDocumentStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$batch_get_document_status_input(IndexId = IndexId, DocumentInfoList = DocumentInfoList)
  output <- .kendra$batch_get_document_status_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$batch_get_document_status <- kendra_batch_get_document_status

#' Adds one or more documents to an index
#'
#' @description
#' Adds one or more documents to an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_batch_put_document/](https://www.paws-r-sdk.com/docs/kendra_batch_put_document/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index to add the documents to. You need to create
#' the index first using the [`create_index`][kendra_create_index] API.
#' @param RoleArn The Amazon Resource Name (ARN) of an IAM role with permission to access
#' your S3 bucket. For more information, see [IAM access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Documents &#91;required&#93; One or more documents to add to the index.
#' 
#' Documents have the following file size limits.
#' 
#' -   50 MB total size for any file
#' 
#' -   5 MB extracted text for any file
#' 
#' For more information, see
#' [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
#' @param CustomDocumentEnrichmentConfiguration Configuration information for altering your document metadata and
#' content during the document ingestion process when you use the
#' [`batch_put_document`][kendra_batch_put_document] API.
#' 
#' For more information on how to create, modify and delete document
#' metadata, or make other content alterations when you ingest documents
#' into Amazon Kendra, see [Customizing document metadata during the
#' ingestion
#' process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
#'
#' @keywords internal
#'
#' @rdname kendra_batch_put_document
kendra_batch_put_document <- function(IndexId, RoleArn = NULL, Documents, CustomDocumentEnrichmentConfiguration = NULL) {
  op <- new_operation(
    name = "BatchPutDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$batch_put_document_input(IndexId = IndexId, RoleArn = RoleArn, Documents = Documents, CustomDocumentEnrichmentConfiguration = CustomDocumentEnrichmentConfiguration)
  output <- .kendra$batch_put_document_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$batch_put_document <- kendra_batch_put_document

#' Clears existing query suggestions from an index
#'
#' @description
#' Clears existing query suggestions from an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_clear_query_suggestions/](https://www.paws-r-sdk.com/docs/kendra_clear_query_suggestions/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index you want to clear query suggestions from.
#'
#' @keywords internal
#'
#' @rdname kendra_clear_query_suggestions
kendra_clear_query_suggestions <- function(IndexId) {
  op <- new_operation(
    name = "ClearQuerySuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$clear_query_suggestions_input(IndexId = IndexId)
  output <- .kendra$clear_query_suggestions_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$clear_query_suggestions <- kendra_clear_query_suggestions

#' Creates an access configuration for your documents
#'
#' @description
#' Creates an access configuration for your documents. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_access_control_configuration/](https://www.paws-r-sdk.com/docs/kendra_create_access_control_configuration/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index to create an access control configuration
#' for your documents.
#' @param Name &#91;required&#93; A name for the access control configuration.
#' @param Description A description for the access control configuration.
#' @param AccessControlList Information on principals (users and/or groups) and which documents they
#' should have access to. This is useful for user context filtering, where
#' search results are filtered based on the user or their group access to
#' documents.
#' @param HierarchicalAccessControlList The list of
#' [principal](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Principal.html)
#' lists that define the hierarchy for which documents users should have
#' access to.
#' @param ClientToken A token that you provide to identify the request to create an access
#' control configuration. Multiple calls to the
#' [`create_access_control_configuration`][kendra_create_access_control_configuration]
#' API with the same client token will create only one access control
#' configuration.
#'
#' @keywords internal
#'
#' @rdname kendra_create_access_control_configuration
kendra_create_access_control_configuration <- function(IndexId, Name, Description = NULL, AccessControlList = NULL, HierarchicalAccessControlList = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateAccessControlConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_access_control_configuration_input(IndexId = IndexId, Name = Name, Description = Description, AccessControlList = AccessControlList, HierarchicalAccessControlList = HierarchicalAccessControlList, ClientToken = ClientToken)
  output <- .kendra$create_access_control_configuration_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_access_control_configuration <- kendra_create_access_control_configuration

#' Creates a data source connector that you want to use with an Amazon
#' Kendra index
#'
#' @description
#' Creates a data source connector that you want to use with an Amazon Kendra index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_data_source/](https://www.paws-r-sdk.com/docs/kendra_create_data_source/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the data source connector.
#' @param IndexId &#91;required&#93; The identifier of the index you want to use with the data source
#' connector.
#' @param Type &#91;required&#93; The type of data source repository. For example, `SHAREPOINT`.
#' @param Configuration Configuration information to connect to your data source repository.
#' 
#' You can't specify the `Configuration` parameter when the `Type`
#' parameter is set to `CUSTOM`. If you do, you receive a
#' `ValidationException` exception.
#' 
#' The `Configuration` parameter is required for all other data sources.
#' @param VpcConfiguration Configuration information for an Amazon Virtual Private Cloud to connect
#' to your data source. For more information, see [Configuring a
#' VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
#' @param Description A description for the data source connector.
#' @param Schedule Sets the frequency for Amazon Kendra to check the documents in your data
#' source repository and update the index. If you don't set a schedule
#' Amazon Kendra will not periodically update the index. You can call the
#' [`start_data_source_sync_job`][kendra_start_data_source_sync_job] API to
#' update the index.
#' 
#' Specify a `cron-` format schedule string or an empty string to indicate
#' that the index is updated on demand.
#' 
#' You can't specify the `Schedule` parameter when the `Type` parameter is
#' set to `CUSTOM`. If you do, you receive a `ValidationException`
#' exception.
#' @param RoleArn The Amazon Resource Name (ARN) of an IAM role with permission to access
#' the data source and required resources. For more information, see [IAM
#' access roles for Amazon
#' Kendra.](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' 
#' You can't specify the `RoleArn` parameter when the `Type` parameter is
#' set to `CUSTOM`. If you do, you receive a `ValidationException`
#' exception.
#' 
#' The `RoleArn` parameter is required for all other data sources.
#' @param Tags A list of key-value pairs that identify or categorize the data source
#' connector. You can also use tags to help control access to the data
#' source connector. Tag keys and values can consist of Unicode letters,
#' digits, white space, and any of the following symbols: _ . : / = + - @@.
#' @param ClientToken A token that you provide to identify the request to create a data source
#' connector. Multiple calls to the
#' [`create_data_source`][kendra_create_data_source] API with the same
#' client token will create only one data source connector.
#' @param LanguageCode The code for a language. This allows you to support a language for all
#' documents when creating the data source connector. English is supported
#' by default. For more information on supported languages, including their
#' codes, see [Adding documents in languages other than
#' English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
#' @param CustomDocumentEnrichmentConfiguration Configuration information for altering document metadata and content
#' during the document ingestion process.
#' 
#' For more information on how to create, modify and delete document
#' metadata, or make other content alterations when you ingest documents
#' into Amazon Kendra, see [Customizing document metadata during the
#' ingestion
#' process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
#'
#' @keywords internal
#'
#' @rdname kendra_create_data_source
kendra_create_data_source <- function(Name, IndexId, Type, Configuration = NULL, VpcConfiguration = NULL, Description = NULL, Schedule = NULL, RoleArn = NULL, Tags = NULL, ClientToken = NULL, LanguageCode = NULL, CustomDocumentEnrichmentConfiguration = NULL) {
  op <- new_operation(
    name = "CreateDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_data_source_input(Name = Name, IndexId = IndexId, Type = Type, Configuration = Configuration, VpcConfiguration = VpcConfiguration, Description = Description, Schedule = Schedule, RoleArn = RoleArn, Tags = Tags, ClientToken = ClientToken, LanguageCode = LanguageCode, CustomDocumentEnrichmentConfiguration = CustomDocumentEnrichmentConfiguration)
  output <- .kendra$create_data_source_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_data_source <- kendra_create_data_source

#' Creates an Amazon Kendra experience such as a search application
#'
#' @description
#' Creates an Amazon Kendra experience such as a search application. For more information on creating a search application experience, including using the Python and Java SDKs, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_experience/](https://www.paws-r-sdk.com/docs/kendra_create_experience/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param RoleArn The Amazon Resource Name (ARN) of an IAM role with permission to access
#' [`query`][kendra_query] API,
#' [`get_query_suggestions`][kendra_get_query_suggestions] API, and other
#' required APIs. The role also must include permission to access IAM
#' Identity Center that stores your user and group information. For more
#' information, see [IAM access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Configuration Configuration information for your Amazon Kendra experience. This
#' includes `ContentSourceConfiguration`, which specifies the data source
#' IDs and/or FAQ IDs, and `UserIdentityConfiguration`, which specifies the
#' user or group information to grant access to your Amazon Kendra
#' experience.
#' @param Description A description for your Amazon Kendra experience.
#' @param ClientToken A token that you provide to identify the request to create your Amazon
#' Kendra experience. Multiple calls to the
#' [`create_experience`][kendra_create_experience] API with the same client
#' token creates only one Amazon Kendra experience.
#'
#' @keywords internal
#'
#' @rdname kendra_create_experience
kendra_create_experience <- function(Name, IndexId, RoleArn = NULL, Configuration = NULL, Description = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_experience_input(Name = Name, IndexId = IndexId, RoleArn = RoleArn, Configuration = Configuration, Description = Description, ClientToken = ClientToken)
  output <- .kendra$create_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_experience <- kendra_create_experience

#' Creates a set of frequently ask questions (FAQs) using a specified FAQ
#' file stored in an Amazon S3 bucket
#'
#' @description
#' Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_faq/](https://www.paws-r-sdk.com/docs/kendra_create_faq/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the FAQ.
#' @param Name &#91;required&#93; A name for the FAQ.
#' @param Description A description for the FAQ.
#' @param S3Path &#91;required&#93; The path to the FAQ file in S3.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role with permission to access
#' the S3 bucket that contains the FAQs. For more information, see [IAM
#' access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Tags A list of key-value pairs that identify the FAQ. You can use the tags to
#' identify and organize your resources and to control access to resources.
#' @param FileFormat The format of the FAQ input file. You can choose between a basic CSV
#' format, a CSV format that includes customs attributes in a header, and a
#' JSON format that includes custom attributes.
#' 
#' The default format is CSV.
#' 
#' The format must match the format of the file stored in the S3 bucket
#' identified in the `S3Path` parameter.
#' 
#' For more information, see [Adding questions and
#' answers](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html).
#' @param ClientToken A token that you provide to identify the request to create a FAQ.
#' Multiple calls to the `CreateFaqRequest` API with the same client token
#' will create only one FAQ.
#' @param LanguageCode The code for a language. This allows you to support a language for the
#' FAQ document. English is supported by default. For more information on
#' supported languages, including their codes, see [Adding documents in
#' languages other than
#' English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
#'
#' @keywords internal
#'
#' @rdname kendra_create_faq
kendra_create_faq <- function(IndexId, Name, Description = NULL, S3Path, RoleArn, Tags = NULL, FileFormat = NULL, ClientToken = NULL, LanguageCode = NULL) {
  op <- new_operation(
    name = "CreateFaq",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_faq_input(IndexId = IndexId, Name = Name, Description = Description, S3Path = S3Path, RoleArn = RoleArn, Tags = Tags, FileFormat = FileFormat, ClientToken = ClientToken, LanguageCode = LanguageCode)
  output <- .kendra$create_faq_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_faq <- kendra_create_faq

#' Creates a set of featured results to display at the top of the search
#' results page
#'
#' @description
#' Creates a set of featured results to display at the top of the search results page. Featured results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_featured_results_set/](https://www.paws-r-sdk.com/docs/kendra_create_featured_results_set/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index that you want to use for featuring results.
#' @param FeaturedResultsSetName &#91;required&#93; A name for the set of featured results.
#' @param Description A description for the set of featured results.
#' @param ClientToken A token that you provide to identify the request to create a set of
#' featured results. Multiple calls to the
#' [`create_featured_results_set`][kendra_create_featured_results_set] API
#' with the same client token will create only one featured results set.
#' @param Status The current status of the set of featured results. When the value is
#' `ACTIVE`, featured results are ready for use. You can still configure
#' your settings before setting the status to `ACTIVE`. You can set the
#' status to `ACTIVE` or `INACTIVE` using the
#' [`update_featured_results_set`][kendra_update_featured_results_set] API.
#' The queries you specify for featured results must be unique per featured
#' results set for each index, whether the status is `ACTIVE` or
#' `INACTIVE`.
#' @param QueryTexts A list of queries for featuring results. For more information on the
#' list of queries, see
#' [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html).
#' @param FeaturedDocuments A list of document IDs for the documents you want to feature at the top
#' of the search results page. For more information on the list of
#' documents, see
#' [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html).
#' @param Tags A list of key-value pairs that identify or categorize the featured
#' results set. You can also use tags to help control access to the
#' featured results set. Tag keys and values can consist of Unicode
#' letters, digits, white space, and any of the following symbols:_ . : /
#' = + - @@.
#'
#' @keywords internal
#'
#' @rdname kendra_create_featured_results_set
kendra_create_featured_results_set <- function(IndexId, FeaturedResultsSetName, Description = NULL, ClientToken = NULL, Status = NULL, QueryTexts = NULL, FeaturedDocuments = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFeaturedResultsSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_featured_results_set_input(IndexId = IndexId, FeaturedResultsSetName = FeaturedResultsSetName, Description = Description, ClientToken = ClientToken, Status = Status, QueryTexts = QueryTexts, FeaturedDocuments = FeaturedDocuments, Tags = Tags)
  output <- .kendra$create_featured_results_set_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_featured_results_set <- kendra_create_featured_results_set

#' Creates an Amazon Kendra index
#'
#' @description
#' Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has completed, check the `Status` field returned from a call to [`describe_index`][kendra_describe_index]. The `Status` field is set to `ACTIVE` when the index is ready to use.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_index/](https://www.paws-r-sdk.com/docs/kendra_create_index/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the index.
#' @param Edition The Amazon Kendra edition to use for the index. Choose
#' `DEVELOPER_EDITION` for indexes intended for development, testing, or
#' proof of concept. Use `ENTERPRISE_EDITION` for production. Once you set
#' the edition for an index, it can't be changed.
#' 
#' The `Edition` parameter is optional. If you don't supply a value, the
#' default is `ENTERPRISE_EDITION`.
#' 
#' For more information on quota limits for Enterprise and Developer
#' editions, see
#' [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role with permission to access
#' your Amazon CloudWatch logs and metrics. For more information, see [IAM
#' access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param ServerSideEncryptionConfiguration The identifier of the KMS customer managed key (CMK) that's used to
#' encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support
#' asymmetric CMKs.
#' @param Description A description for the index.
#' @param ClientToken A token that you provide to identify the request to create an index.
#' Multiple calls to the [`create_index`][kendra_create_index] API with the
#' same client token will create only one index.
#' @param Tags A list of key-value pairs that identify or categorize the index. You can
#' also use tags to help control access to the index. Tag keys and values
#' can consist of Unicode letters, digits, white space, and any of the
#' following symbols: _ . : / = + - @@.
#' @param UserTokenConfigurations The user token configuration.
#' @param UserContextPolicy The user context policy.
#' 
#' **ATTRIBUTE_FILTER**
#' 
#' All indexed content is searchable and displayable for all users. If you
#' want to filter search results on user context, you can use the attribute
#' filters of `_user_id` and `_group_ids` or you can provide user and group
#' information in `UserContext`.
#' 
#' **USER_TOKEN**
#' 
#' Enables token-based user access control to filter search results on user
#' context. All documents with no access control and all documents
#' accessible to the user will be searchable and displayable.
#' @param UserGroupResolutionConfiguration Gets users and groups from IAM Identity Center identity source. To
#' configure this, see
#' [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_UserGroupResolutionConfiguration.html).
#'
#' @keywords internal
#'
#' @rdname kendra_create_index
kendra_create_index <- function(Name, Edition = NULL, RoleArn, ServerSideEncryptionConfiguration = NULL, Description = NULL, ClientToken = NULL, Tags = NULL, UserTokenConfigurations = NULL, UserContextPolicy = NULL, UserGroupResolutionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_index_input(Name = Name, Edition = Edition, RoleArn = RoleArn, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration, Description = Description, ClientToken = ClientToken, Tags = Tags, UserTokenConfigurations = UserTokenConfigurations, UserContextPolicy = UserContextPolicy, UserGroupResolutionConfiguration = UserGroupResolutionConfiguration)
  output <- .kendra$create_index_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_index <- kendra_create_index

#' Creates a block list to exlcude certain queries from suggestions
#'
#' @description
#' Creates a block list to exlcude certain queries from suggestions.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_query_suggestions_block_list/](https://www.paws-r-sdk.com/docs/kendra_create_query_suggestions_block_list/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index you want to create a query suggestions block
#' list for.
#' @param Name &#91;required&#93; A name for the block list.
#' 
#' For example, the name 'offensive-words', which includes all offensive
#' words that could appear in user queries and need to be blocked from
#' suggestions.
#' @param Description A description for the block list.
#' 
#' For example, the description "List of all offensive words that can
#' appear in user queries and need to be blocked from suggestions."
#' @param SourceS3Path &#91;required&#93; The S3 path to your block list text file in your S3 bucket.
#' 
#' Each block word or phrase should be on a separate line in a text file.
#' 
#' For information on the current quota limits for block lists, see [Quotas
#' for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
#' @param ClientToken A token that you provide to identify the request to create a query
#' suggestions block list.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role with permission to access
#' your S3 bucket that contains the block list text file. For more
#' information, see [IAM access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Tags A list of key-value pairs that identify or categorize the block list.
#' Tag keys and values can consist of Unicode letters, digits, white space,
#' and any of the following symbols: _ . : / = + - @@.
#'
#' @keywords internal
#'
#' @rdname kendra_create_query_suggestions_block_list
kendra_create_query_suggestions_block_list <- function(IndexId, Name, Description = NULL, SourceS3Path, ClientToken = NULL, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateQuerySuggestionsBlockList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_query_suggestions_block_list_input(IndexId = IndexId, Name = Name, Description = Description, SourceS3Path = SourceS3Path, ClientToken = ClientToken, RoleArn = RoleArn, Tags = Tags)
  output <- .kendra$create_query_suggestions_block_list_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_query_suggestions_block_list <- kendra_create_query_suggestions_block_list

#' Creates a thesaurus for an index
#'
#' @description
#' Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_create_thesaurus/](https://www.paws-r-sdk.com/docs/kendra_create_thesaurus/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the thesaurus.
#' @param Name &#91;required&#93; A name for the thesaurus.
#' @param Description A description for the thesaurus.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role with permission to access
#' your S3 bucket that contains the thesaurus file. For more information,
#' see [IAM access roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Tags A list of key-value pairs that identify or categorize the thesaurus. You
#' can also use tags to help control access to the thesaurus. Tag keys and
#' values can consist of Unicode letters, digits, white space, and any of
#' the following symbols: _ . : / = + - @@.
#' @param SourceS3Path &#91;required&#93; The path to the thesaurus file in S3.
#' @param ClientToken A token that you provide to identify the request to create a thesaurus.
#' Multiple calls to the [`create_thesaurus`][kendra_create_thesaurus] API
#' with the same client token will create only one thesaurus.
#'
#' @keywords internal
#'
#' @rdname kendra_create_thesaurus
kendra_create_thesaurus <- function(IndexId, Name, Description = NULL, RoleArn, Tags = NULL, SourceS3Path, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateThesaurus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$create_thesaurus_input(IndexId = IndexId, Name = Name, Description = Description, RoleArn = RoleArn, Tags = Tags, SourceS3Path = SourceS3Path, ClientToken = ClientToken)
  output <- .kendra$create_thesaurus_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$create_thesaurus <- kendra_create_thesaurus

#' Deletes an access control configuration that you created for your
#' documents in an index
#'
#' @description
#' Deletes an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_access_control_configuration/](https://www.paws-r-sdk.com/docs/kendra_delete_access_control_configuration/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for an access control configuration.
#' @param Id &#91;required&#93; The identifier of the access control configuration you want to delete.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_access_control_configuration
kendra_delete_access_control_configuration <- function(IndexId, Id) {
  op <- new_operation(
    name = "DeleteAccessControlConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_access_control_configuration_input(IndexId = IndexId, Id = Id)
  output <- .kendra$delete_access_control_configuration_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_access_control_configuration <- kendra_delete_access_control_configuration

#' Deletes an Amazon Kendra data source connector
#'
#' @description
#' Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the `Status` field returned by a call to the [`describe_data_source`][kendra_describe_data_source] API is set to `DELETING`. For more information, see [Deleting Data Sources](https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_data_source/](https://www.paws-r-sdk.com/docs/kendra_delete_data_source/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector you want to delete.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_data_source
kendra_delete_data_source <- function(Id, IndexId) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_data_source_input(Id = Id, IndexId = IndexId)
  output <- .kendra$delete_data_source_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_data_source <- kendra_delete_data_source

#' Deletes your Amazon Kendra experience such as a search application
#'
#' @description
#' Deletes your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_experience/](https://www.paws-r-sdk.com/docs/kendra_delete_experience/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience you want to delete.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_experience
kendra_delete_experience <- function(Id, IndexId) {
  op <- new_operation(
    name = "DeleteExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_experience_input(Id = Id, IndexId = IndexId)
  output <- .kendra$delete_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_experience <- kendra_delete_experience

#' Removes an FAQ from an index
#'
#' @description
#' Removes an FAQ from an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_faq/](https://www.paws-r-sdk.com/docs/kendra_delete_faq/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the FAQ you want to remove.
#' @param IndexId &#91;required&#93; The identifier of the index for the FAQ.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_faq
kendra_delete_faq <- function(Id, IndexId) {
  op <- new_operation(
    name = "DeleteFaq",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_faq_input(Id = Id, IndexId = IndexId)
  output <- .kendra$delete_faq_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_faq <- kendra_delete_faq

#' Deletes an existing Amazon Kendra index
#'
#' @description
#' Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the `Status` field returned by a call to the [`describe_index`][kendra_describe_index] API is set to `DELETING`.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_index/](https://www.paws-r-sdk.com/docs/kendra_delete_index/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the index you want to delete.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_index
kendra_delete_index <- function(Id) {
  op <- new_operation(
    name = "DeleteIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_index_input(Id = Id)
  output <- .kendra$delete_index_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_index <- kendra_delete_index

#' Deletes a group so that all users and sub groups that belong to the
#' group can no longer access documents only available to that group
#'
#' @description
#' Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_principal_mapping/](https://www.paws-r-sdk.com/docs/kendra_delete_principal_mapping/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index you want to delete a group from.
#' @param DataSourceId The identifier of the data source you want to delete a group from.
#' 
#' A group can be tied to multiple data sources. You can delete a group
#' from accessing documents in a certain data source. For example, the
#' groups "Research", "Engineering", and "Sales and Marketing" are all tied
#' to the company's documents stored in the data sources Confluence and
#' Salesforce. You want to delete "Research" and "Engineering" groups from
#' Salesforce, so that these groups cannot access customer-related
#' documents stored in Salesforce. Only "Sales and Marketing" should access
#' documents in the Salesforce data source.
#' @param GroupId &#91;required&#93; The identifier of the group you want to delete.
#' @param OrderingId The timestamp identifier you specify to ensure Amazon Kendra does not
#' override the latest `DELETE` action with previous actions. The highest
#' number ID, which is the ordering ID, is the latest action you want to
#' process and apply on top of other actions with lower number IDs. This
#' prevents previous actions with lower number IDs from possibly overriding
#' the latest action.
#' 
#' The ordering ID can be the Unix time of the last update you made to a
#' group members list. You would then provide this list when calling
#' [`put_principal_mapping`][kendra_put_principal_mapping]. This ensures
#' your `DELETE` action for that updated group with the latest members list
#' doesn't get overwritten by earlier `DELETE` actions for the same group
#' which are yet to be processed.
#' 
#' The default ordering ID is the current Unix time in milliseconds that
#' the action was received by Amazon Kendra.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_principal_mapping
kendra_delete_principal_mapping <- function(IndexId, DataSourceId = NULL, GroupId, OrderingId = NULL) {
  op <- new_operation(
    name = "DeletePrincipalMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_principal_mapping_input(IndexId = IndexId, DataSourceId = DataSourceId, GroupId = GroupId, OrderingId = OrderingId)
  output <- .kendra$delete_principal_mapping_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_principal_mapping <- kendra_delete_principal_mapping

#' Deletes a block list used for query suggestions for an index
#'
#' @description
#' Deletes a block list used for query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_query_suggestions_block_list/](https://www.paws-r-sdk.com/docs/kendra_delete_query_suggestions_block_list/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the block list.
#' @param Id &#91;required&#93; The identifier of the block list you want to delete.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_query_suggestions_block_list
kendra_delete_query_suggestions_block_list <- function(IndexId, Id) {
  op <- new_operation(
    name = "DeleteQuerySuggestionsBlockList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_query_suggestions_block_list_input(IndexId = IndexId, Id = Id)
  output <- .kendra$delete_query_suggestions_block_list_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_query_suggestions_block_list <- kendra_delete_query_suggestions_block_list

#' Deletes an existing Amazon Kendra thesaurus
#'
#' @description
#' Deletes an existing Amazon Kendra thesaurus.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_delete_thesaurus/](https://www.paws-r-sdk.com/docs/kendra_delete_thesaurus/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the thesaurus you want to delete.
#' @param IndexId &#91;required&#93; The identifier of the index for the thesaurus.
#'
#' @keywords internal
#'
#' @rdname kendra_delete_thesaurus
kendra_delete_thesaurus <- function(Id, IndexId) {
  op <- new_operation(
    name = "DeleteThesaurus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$delete_thesaurus_input(Id = Id, IndexId = IndexId)
  output <- .kendra$delete_thesaurus_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$delete_thesaurus <- kendra_delete_thesaurus

#' Gets information about an access control configuration that you created
#' for your documents in an index
#'
#' @description
#' Gets information about an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_access_control_configuration/](https://www.paws-r-sdk.com/docs/kendra_describe_access_control_configuration/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for an access control configuration.
#' @param Id &#91;required&#93; The identifier of the access control configuration you want to get
#' information on.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_access_control_configuration
kendra_describe_access_control_configuration <- function(IndexId, Id) {
  op <- new_operation(
    name = "DescribeAccessControlConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_access_control_configuration_input(IndexId = IndexId, Id = Id)
  output <- .kendra$describe_access_control_configuration_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_access_control_configuration <- kendra_describe_access_control_configuration

#' Gets information about an Amazon Kendra data source connector
#'
#' @description
#' Gets information about an Amazon Kendra data source connector.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_data_source/](https://www.paws-r-sdk.com/docs/kendra_describe_data_source/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_data_source
kendra_describe_data_source <- function(Id, IndexId) {
  op <- new_operation(
    name = "DescribeDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_data_source_input(Id = Id, IndexId = IndexId)
  output <- .kendra$describe_data_source_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_data_source <- kendra_describe_data_source

#' Gets information about your Amazon Kendra experience such as a search
#' application
#'
#' @description
#' Gets information about your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_experience/](https://www.paws-r-sdk.com/docs/kendra_describe_experience/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience you want to get
#' information on.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_experience
kendra_describe_experience <- function(Id, IndexId) {
  op <- new_operation(
    name = "DescribeExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_experience_input(Id = Id, IndexId = IndexId)
  output <- .kendra$describe_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_experience <- kendra_describe_experience

#' Gets information about an FAQ list
#'
#' @description
#' Gets information about an FAQ list.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_faq/](https://www.paws-r-sdk.com/docs/kendra_describe_faq/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the FAQ you want to get information on.
#' @param IndexId &#91;required&#93; The identifier of the index for the FAQ.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_faq
kendra_describe_faq <- function(Id, IndexId) {
  op <- new_operation(
    name = "DescribeFaq",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_faq_input(Id = Id, IndexId = IndexId)
  output <- .kendra$describe_faq_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_faq <- kendra_describe_faq

#' Gets information about a set of featured results
#'
#' @description
#' Gets information about a set of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_featured_results_set/](https://www.paws-r-sdk.com/docs/kendra_describe_featured_results_set/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index used for featuring results.
#' @param FeaturedResultsSetId &#91;required&#93; The identifier of the set of featured results that you want to get
#' information on.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_featured_results_set
kendra_describe_featured_results_set <- function(IndexId, FeaturedResultsSetId) {
  op <- new_operation(
    name = "DescribeFeaturedResultsSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_featured_results_set_input(IndexId = IndexId, FeaturedResultsSetId = FeaturedResultsSetId)
  output <- .kendra$describe_featured_results_set_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_featured_results_set <- kendra_describe_featured_results_set

#' Gets information about an existing Amazon Kendra index
#'
#' @description
#' Gets information about an existing Amazon Kendra index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_index/](https://www.paws-r-sdk.com/docs/kendra_describe_index/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the index you want to get information on.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_index
kendra_describe_index <- function(Id) {
  op <- new_operation(
    name = "DescribeIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_index_input(Id = Id)
  output <- .kendra$describe_index_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_index <- kendra_describe_index

#' Describes the processing of PUT and DELETE actions for mapping users to
#' their groups
#'
#' @description
#' Describes the processing of `PUT` and `DELETE` actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_principal_mapping/](https://www.paws-r-sdk.com/docs/kendra_describe_principal_mapping/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index required to check the processing of `PUT`
#' and `DELETE` actions for mapping users to their groups.
#' @param DataSourceId The identifier of the data source to check the processing of `PUT` and
#' `DELETE` actions for mapping users to their groups.
#' @param GroupId &#91;required&#93; The identifier of the group required to check the processing of `PUT`
#' and `DELETE` actions for mapping users to their groups.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_principal_mapping
kendra_describe_principal_mapping <- function(IndexId, DataSourceId = NULL, GroupId) {
  op <- new_operation(
    name = "DescribePrincipalMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_principal_mapping_input(IndexId = IndexId, DataSourceId = DataSourceId, GroupId = GroupId)
  output <- .kendra$describe_principal_mapping_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_principal_mapping <- kendra_describe_principal_mapping

#' Gets information about a block list used for query suggestions for an
#' index
#'
#' @description
#' Gets information about a block list used for query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_query_suggestions_block_list/](https://www.paws-r-sdk.com/docs/kendra_describe_query_suggestions_block_list/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the block list.
#' @param Id &#91;required&#93; The identifier of the block list you want to get information on.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_query_suggestions_block_list
kendra_describe_query_suggestions_block_list <- function(IndexId, Id) {
  op <- new_operation(
    name = "DescribeQuerySuggestionsBlockList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_query_suggestions_block_list_input(IndexId = IndexId, Id = Id)
  output <- .kendra$describe_query_suggestions_block_list_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_query_suggestions_block_list <- kendra_describe_query_suggestions_block_list

#' Gets information on the settings of query suggestions for an index
#'
#' @description
#' Gets information on the settings of query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_query_suggestions_config/](https://www.paws-r-sdk.com/docs/kendra_describe_query_suggestions_config/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index with query suggestions that you want to get
#' information on.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_query_suggestions_config
kendra_describe_query_suggestions_config <- function(IndexId) {
  op <- new_operation(
    name = "DescribeQuerySuggestionsConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_query_suggestions_config_input(IndexId = IndexId)
  output <- .kendra$describe_query_suggestions_config_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_query_suggestions_config <- kendra_describe_query_suggestions_config

#' Gets information about an existing Amazon Kendra thesaurus
#'
#' @description
#' Gets information about an existing Amazon Kendra thesaurus.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_describe_thesaurus/](https://www.paws-r-sdk.com/docs/kendra_describe_thesaurus/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the thesaurus you want to get information on.
#' @param IndexId &#91;required&#93; The identifier of the index for the thesaurus.
#'
#' @keywords internal
#'
#' @rdname kendra_describe_thesaurus
kendra_describe_thesaurus <- function(Id, IndexId) {
  op <- new_operation(
    name = "DescribeThesaurus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$describe_thesaurus_input(Id = Id, IndexId = IndexId)
  output <- .kendra$describe_thesaurus_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$describe_thesaurus <- kendra_describe_thesaurus

#' Prevents users or groups in your IAM Identity Center identity source
#' from accessing your Amazon Kendra experience
#'
#' @description
#' Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_disassociate_entities_from_experience/](https://www.paws-r-sdk.com/docs/kendra_disassociate_entities_from_experience/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param EntityList &#91;required&#93; Lists users or groups in your IAM Identity Center identity source.
#'
#' @keywords internal
#'
#' @rdname kendra_disassociate_entities_from_experience
kendra_disassociate_entities_from_experience <- function(Id, IndexId, EntityList) {
  op <- new_operation(
    name = "DisassociateEntitiesFromExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$disassociate_entities_from_experience_input(Id = Id, IndexId = IndexId, EntityList = EntityList)
  output <- .kendra$disassociate_entities_from_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$disassociate_entities_from_experience <- kendra_disassociate_entities_from_experience

#' Removes the specific permissions of users or groups in your IAM Identity
#' Center identity source with access to your Amazon Kendra experience
#'
#' @description
#' Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_disassociate_personas_from_entities/](https://www.paws-r-sdk.com/docs/kendra_disassociate_personas_from_entities/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param EntityIds &#91;required&#93; The identifiers of users or groups in your IAM Identity Center identity
#' source. For example, user IDs could be user emails.
#'
#' @keywords internal
#'
#' @rdname kendra_disassociate_personas_from_entities
kendra_disassociate_personas_from_entities <- function(Id, IndexId, EntityIds) {
  op <- new_operation(
    name = "DisassociatePersonasFromEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$disassociate_personas_from_entities_input(Id = Id, IndexId = IndexId, EntityIds = EntityIds)
  output <- .kendra$disassociate_personas_from_entities_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$disassociate_personas_from_entities <- kendra_disassociate_personas_from_entities

#' Fetches the queries that are suggested to your users
#'
#' @description
#' Fetches the queries that are suggested to your users.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_get_query_suggestions/](https://www.paws-r-sdk.com/docs/kendra_get_query_suggestions/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index you want to get query suggestions from.
#' @param QueryText &#91;required&#93; The text of a user's query to generate query suggestions.
#' 
#' A query is suggested if the query prefix matches what a user starts to
#' type as their query.
#' 
#' Amazon Kendra does not show any suggestions if a user types fewer than
#' two characters or more than 60 characters. A query must also have at
#' least one search result and contain at least one word of more than four
#' characters.
#' @param MaxSuggestionsCount The maximum number of query suggestions you want to show to your users.
#' @param SuggestionTypes The suggestions type to base query suggestions on. The suggestion types
#' are query history or document fields/attributes. You can set one type or
#' the other.
#' 
#' If you set query history as your suggestions type, Amazon Kendra
#' suggests queries relevant to your users based on popular queries in the
#' query history.
#' 
#' If you set document fields/attributes as your suggestions type, Amazon
#' Kendra suggests queries relevant to your users based on the contents of
#' document fields.
#' @param AttributeSuggestionsConfig Configuration information for the document fields/attributes that you
#' want to base query suggestions on.
#'
#' @keywords internal
#'
#' @rdname kendra_get_query_suggestions
kendra_get_query_suggestions <- function(IndexId, QueryText, MaxSuggestionsCount = NULL, SuggestionTypes = NULL, AttributeSuggestionsConfig = NULL) {
  op <- new_operation(
    name = "GetQuerySuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$get_query_suggestions_input(IndexId = IndexId, QueryText = QueryText, MaxSuggestionsCount = MaxSuggestionsCount, SuggestionTypes = SuggestionTypes, AttributeSuggestionsConfig = AttributeSuggestionsConfig)
  output <- .kendra$get_query_suggestions_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$get_query_suggestions <- kendra_get_query_suggestions

#' Retrieves search metrics data
#'
#' @description
#' Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_get_snapshots/](https://www.paws-r-sdk.com/docs/kendra_get_snapshots/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index to get search metrics data.
#' @param Interval &#91;required&#93; The time interval or time window to get search metrics data. The time
#' interval uses the time zone of your index. You can view data in the
#' following time windows:
#' 
#' -   `THIS_WEEK`: The current week, starting on the Sunday and ending on
#'     the day before the current date.
#' 
#' -   `ONE_WEEK_AGO`: The previous week, starting on the Sunday and ending
#'     on the following Saturday.
#' 
#' -   `TWO_WEEKS_AGO`: The week before the previous week, starting on the
#'     Sunday and ending on the following Saturday.
#' 
#' -   `THIS_MONTH`: The current month, starting on the first day of the
#'     month and ending on the day before the current date.
#' 
#' -   `ONE_MONTH_AGO`: The previous month, starting on the first day of
#'     the month and ending on the last day of the month.
#' 
#' -   `TWO_MONTHS_AGO`: The month before the previous month, starting on
#'     the first day of the month and ending on last day of the month.
#' @param MetricType &#91;required&#93; The metric you want to retrieve. You can specify only one metric per
#' call.
#' 
#' For more information about the metrics you can view, see [Gaining
#' insights with search
#' analytics](https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html).
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of search metrics
#' data.
#' @param MaxResults The maximum number of returned data for the metric.
#'
#' @keywords internal
#'
#' @rdname kendra_get_snapshots
kendra_get_snapshots <- function(IndexId, Interval, MetricType, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$get_snapshots_input(IndexId = IndexId, Interval = Interval, MetricType = MetricType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$get_snapshots_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$get_snapshots <- kendra_get_snapshots

#' Lists one or more access control configurations for an index
#'
#' @description
#' Lists one or more access control configurations for an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_access_control_configurations/](https://www.paws-r-sdk.com/docs/kendra_list_access_control_configurations/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the access control configuration.
#' @param NextToken If the previous response was incomplete (because there's more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of access control
#' configurations.
#' @param MaxResults The maximum number of access control configurations to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_access_control_configurations
kendra_list_access_control_configurations <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessControlConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_access_control_configurations_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_access_control_configurations_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_access_control_configurations <- kendra_list_access_control_configurations

#' Gets statistics about synchronizing a data source connector
#'
#' @description
#' Gets statistics about synchronizing a data source connector.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_data_source_sync_jobs/](https://www.paws-r-sdk.com/docs/kendra_list_data_source_sync_jobs/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of jobs.
#' @param MaxResults The maximum number of synchronization jobs to return in the response. If
#' there are fewer results in the list, this response contains only the
#' actual results.
#' @param StartTimeFilter When specified, the synchronization jobs returned in the list are
#' limited to jobs between the specified dates.
#' @param StatusFilter Only returns synchronization jobs with the `Status` field equal to the
#' specified status.
#'
#' @keywords internal
#'
#' @rdname kendra_list_data_source_sync_jobs
kendra_list_data_source_sync_jobs <- function(Id, IndexId, NextToken = NULL, MaxResults = NULL, StartTimeFilter = NULL, StatusFilter = NULL) {
  op <- new_operation(
    name = "ListDataSourceSyncJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_data_source_sync_jobs_input(Id = Id, IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults, StartTimeFilter = StartTimeFilter, StatusFilter = StatusFilter)
  output <- .kendra$list_data_source_sync_jobs_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_data_source_sync_jobs <- kendra_list_data_source_sync_jobs

#' Lists the data source connectors that you have created
#'
#' @description
#' Lists the data source connectors that you have created.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_data_sources/](https://www.paws-r-sdk.com/docs/kendra_list_data_sources/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index used with one or more data source
#' connectors.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of data source
#' connectors.
#' @param MaxResults The maximum number of data source connectors to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_data_sources
kendra_list_data_sources <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataSources",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_data_sources_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_data_sources_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_data_sources <- kendra_list_data_sources

#' Lists specific permissions of users and groups with access to your
#' Amazon Kendra experience
#'
#' @description
#' Lists specific permissions of users and groups with access to your Amazon Kendra experience.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_entity_personas/](https://www.paws-r-sdk.com/docs/kendra_list_entity_personas/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of users or
#' groups.
#' @param MaxResults The maximum number of returned users or groups.
#'
#' @keywords internal
#'
#' @rdname kendra_list_entity_personas
kendra_list_entity_personas <- function(Id, IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntityPersonas",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_entity_personas_input(Id = Id, IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_entity_personas_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_entity_personas <- kendra_list_entity_personas

#' Lists users or groups in your IAM Identity Center identity source that
#' are granted access to your Amazon Kendra experience
#'
#' @description
#' Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_experience_entities/](https://www.paws-r-sdk.com/docs/kendra_list_experience_entities/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of users or
#' groups.
#'
#' @keywords internal
#'
#' @rdname kendra_list_experience_entities
kendra_list_experience_entities <- function(Id, IndexId, NextToken = NULL) {
  op <- new_operation(
    name = "ListExperienceEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken")
  )
  input <- .kendra$list_experience_entities_input(Id = Id, IndexId = IndexId, NextToken = NextToken)
  output <- .kendra$list_experience_entities_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_experience_entities <- kendra_list_experience_entities

#' Lists one or more Amazon Kendra experiences
#'
#' @description
#' Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_experiences/](https://www.paws-r-sdk.com/docs/kendra_list_experiences/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of Amazon Kendra
#' experiences.
#' @param MaxResults The maximum number of returned Amazon Kendra experiences.
#'
#' @keywords internal
#'
#' @rdname kendra_list_experiences
kendra_list_experiences <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListExperiences",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_experiences_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_experiences_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_experiences <- kendra_list_experiences

#' Gets a list of FAQ lists associated with an index
#'
#' @description
#' Gets a list of FAQ lists associated with an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_faqs/](https://www.paws-r-sdk.com/docs/kendra_list_faqs/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The index that contains the FAQ lists.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of FAQs.
#' @param MaxResults The maximum number of FAQs to return in the response. If there are fewer
#' results in the list, this response contains only the actual results.
#'
#' @keywords internal
#'
#' @rdname kendra_list_faqs
kendra_list_faqs <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFaqs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_faqs_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_faqs_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_faqs <- kendra_list_faqs

#' Lists all your sets of featured results for a given index
#'
#' @description
#' Lists all your sets of featured results for a given index. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_featured_results_sets/](https://www.paws-r-sdk.com/docs/kendra_list_featured_results_sets/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index used for featuring results.
#' @param NextToken If the response is truncated, Amazon Kendra returns a pagination token
#' in the response. You can use this pagination token to retrieve the next
#' set of featured results sets.
#' @param MaxResults The maximum number of featured results sets to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_featured_results_sets
kendra_list_featured_results_sets <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFeaturedResultsSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$list_featured_results_sets_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_featured_results_sets_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_featured_results_sets <- kendra_list_featured_results_sets

#' Provides a list of groups that are mapped to users before a given
#' ordering or timestamp identifier
#'
#' @description
#' Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_groups_older_than_ordering_id/](https://www.paws-r-sdk.com/docs/kendra_list_groups_older_than_ordering_id/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for getting a list of groups mapped to users
#' before a given ordering or timestamp identifier.
#' @param DataSourceId The identifier of the data source for getting a list of groups mapped to
#' users before a given ordering timestamp identifier.
#' @param OrderingId &#91;required&#93; The timestamp identifier used for the latest `PUT` or `DELETE` action
#' for mapping users to their groups.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of groups that
#' are mapped to users before a given ordering or timestamp identifier.
#' @param MaxResults The maximum number of returned groups that are mapped to users before a
#' given ordering or timestamp identifier.
#'
#' @keywords internal
#'
#' @rdname kendra_list_groups_older_than_ordering_id
kendra_list_groups_older_than_ordering_id <- function(IndexId, DataSourceId = NULL, OrderingId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGroupsOlderThanOrderingId",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_groups_older_than_ordering_id_input(IndexId = IndexId, DataSourceId = DataSourceId, OrderingId = OrderingId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_groups_older_than_ordering_id_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_groups_older_than_ordering_id <- kendra_list_groups_older_than_ordering_id

#' Lists the Amazon Kendra indexes that you created
#'
#' @description
#' Lists the Amazon Kendra indexes that you created.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_indices/](https://www.paws-r-sdk.com/docs/kendra_list_indices/) for full documentation.
#'
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of indexes.
#' @param MaxResults The maximum number of indices to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_indices
kendra_list_indices <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListIndices",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_indices_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_indices_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_indices <- kendra_list_indices

#' Lists the block lists used for query suggestions for an index
#'
#' @description
#' Lists the block lists used for query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_query_suggestions_block_lists/](https://www.paws-r-sdk.com/docs/kendra_list_query_suggestions_block_lists/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for a list of all block lists that exist for
#' that index.
#' 
#' For information on the current quota limits for block lists, see [Quotas
#' for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of block lists
#' (`BlockListSummaryItems`).
#' @param MaxResults The maximum number of block lists to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_query_suggestions_block_lists
kendra_list_query_suggestions_block_lists <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQuerySuggestionsBlockLists",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_query_suggestions_block_lists_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_query_suggestions_block_lists_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_query_suggestions_block_lists <- kendra_list_query_suggestions_block_lists

#' Gets a list of tags associated with a specified resource
#'
#' @description
#' Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/kendra_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the index, FAQ, or data source to get
#' a list of tags for.
#'
#' @keywords internal
#'
#' @rdname kendra_list_tags_for_resource
kendra_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .kendra$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_tags_for_resource <- kendra_list_tags_for_resource

#' Lists the thesauri for an index
#'
#' @description
#' Lists the thesauri for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_list_thesauri/](https://www.paws-r-sdk.com/docs/kendra_list_thesauri/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index with one or more thesauri.
#' @param NextToken If the previous response was incomplete (because there is more data to
#' retrieve), Amazon Kendra returns a pagination token in the response. You
#' can use this pagination token to retrieve the next set of thesauri
#' (`ThesaurusSummaryItems`).
#' @param MaxResults The maximum number of thesauri to return.
#'
#' @keywords internal
#'
#' @rdname kendra_list_thesauri
kendra_list_thesauri <- function(IndexId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListThesauri",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .kendra$list_thesauri_input(IndexId = IndexId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .kendra$list_thesauri_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$list_thesauri <- kendra_list_thesauri

#' Maps users to their groups so that you only need to provide the user ID
#' when you issue the query
#'
#' @description
#' Maps users to their groups so that you only need to provide the user ID when you issue the query.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_put_principal_mapping/](https://www.paws-r-sdk.com/docs/kendra_put_principal_mapping/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index you want to map users to their groups.
#' @param DataSourceId The identifier of the data source you want to map users to their groups.
#' 
#' This is useful if a group is tied to multiple data sources, but you only
#' want the group to access documents of a certain data source. For
#' example, the groups "Research", "Engineering", and "Sales and Marketing"
#' are all tied to the company's documents stored in the data sources
#' Confluence and Salesforce. However, "Sales and Marketing" team only
#' needs access to customer-related documents stored in Salesforce.
#' @param GroupId &#91;required&#93; The identifier of the group you want to map its users to.
#' @param GroupMembers &#91;required&#93; The list that contains your users or sub groups that belong the same
#' group.
#' 
#' For example, the group "Company" includes the user "CEO" and the sub
#' groups "Research", "Engineering", and "Sales and Marketing".
#' 
#' If you have more than 1000 users and/or sub groups for a single group,
#' you need to provide the path to the S3 file that lists your users and
#' sub groups for a group. Your sub groups can contain more than 1000
#' users, but the list of sub groups that belong to a group (and/or users)
#' must be no more than 1000.
#' @param OrderingId The timestamp identifier you specify to ensure Amazon Kendra does not
#' override the latest `PUT` action with previous actions. The highest
#' number ID, which is the ordering ID, is the latest action you want to
#' process and apply on top of other actions with lower number IDs. This
#' prevents previous actions with lower number IDs from possibly overriding
#' the latest action.
#' 
#' The ordering ID can be the Unix time of the last update you made to a
#' group members list. You would then provide this list when calling
#' [`put_principal_mapping`][kendra_put_principal_mapping]. This ensures
#' your `PUT` action for that updated group with the latest members list
#' doesn't get overwritten by earlier `PUT` actions for the same group
#' which are yet to be processed.
#' 
#' The default ordering ID is the current Unix time in milliseconds that
#' the action was received by Amazon Kendra.
#' @param RoleArn The Amazon Resource Name (ARN) of a role that has access to the S3 file
#' that contains your list of users or sub groups that belong to a group.
#' 
#' For more information, see [IAM roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds).
#'
#' @keywords internal
#'
#' @rdname kendra_put_principal_mapping
kendra_put_principal_mapping <- function(IndexId, DataSourceId = NULL, GroupId, GroupMembers, OrderingId = NULL, RoleArn = NULL) {
  op <- new_operation(
    name = "PutPrincipalMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$put_principal_mapping_input(IndexId = IndexId, DataSourceId = DataSourceId, GroupId = GroupId, GroupMembers = GroupMembers, OrderingId = OrderingId, RoleArn = RoleArn)
  output <- .kendra$put_principal_mapping_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$put_principal_mapping <- kendra_put_principal_mapping

#' Searches an index given an input query
#'
#' @description
#' Searches an index given an input query.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_query/](https://www.paws-r-sdk.com/docs/kendra_query/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the search.
#' @param QueryText The input query text for the search. Amazon Kendra truncates queries at
#' 30 token words, which excludes punctuation and stop words. Truncation
#' still applies if you use Boolean or more advanced, complex queries.
#' @param AttributeFilter Filters search results by document fields/attributes. You can only
#' provide one attribute filter; however, the `AndAllFilters`, `NotFilter`,
#' and `OrAllFilters` parameters contain a list of other filters.
#' 
#' The `AttributeFilter` parameter means you can create a set of filtering
#' rules that a document must satisfy to be included in the query results.
#' @param Facets An array of documents fields/attributes for faceted search. Amazon
#' Kendra returns a count for each field key specified. This helps your
#' users narrow their search.
#' @param RequestedDocumentAttributes An array of document fields/attributes to include in the response. You
#' can limit the response to include certain document fields. By default,
#' all document attributes are included in the response.
#' @param QueryResultTypeFilter Sets the type of query result or response. Only results for the
#' specified type are returned.
#' @param DocumentRelevanceOverrideConfigurations Overrides relevance tuning configurations of fields/attributes set at
#' the index level.
#' 
#' If you use this API to override the relevance tuning configured at the
#' index level, but there is no relevance tuning configured at the index
#' level, then Amazon Kendra does not apply any relevance tuning.
#' 
#' If there is relevance tuning configured for fields at the index level,
#' and you use this API to override only some of these fields, then for the
#' fields you did not override, the importance is set to 1.
#' @param PageNumber Query results are returned in pages the size of the `PageSize`
#' parameter. By default, Amazon Kendra returns the first page of results.
#' Use this parameter to get result pages after the first one.
#' @param PageSize Sets the number of results that are returned in each page of results.
#' The default page size is 10. The maximum number of results returned is
#' 100. If you ask for more than 100 results, only 100 are returned.
#' @param SortingConfiguration Provides information that determines how the results of the query are
#' sorted. You can set the field that Amazon Kendra should sort the results
#' on, and specify whether the results should be sorted in ascending or
#' descending order. In the case of ties in sorting the results, the
#' results are sorted by relevance.
#' 
#' If you don't provide sorting configuration, the results are sorted by
#' the relevance that Amazon Kendra determines for the result.
#' @param SortingConfigurations Provides configuration information to determine how the results of a
#' query are sorted.
#' 
#' You can set upto 3 fields that Amazon Kendra should sort the results on,
#' and specify whether the results should be sorted in ascending or
#' descending order. The sort field quota can be increased.
#' 
#' If you don't provide a sorting configuration, the results are sorted by
#' the relevance that Amazon Kendra determines for the result. In the case
#' of ties in sorting the results, the results are sorted by relevance.
#' @param UserContext The user context token or user and group information.
#' @param VisitorId Provides an identifier for a specific user. The `VisitorId` should be a
#' unique identifier, such as a GUID. Don't use personally identifiable
#' information, such as the user's email address, as the `VisitorId`.
#' @param SpellCorrectionConfiguration Enables suggested spell corrections for queries.
#' @param CollapseConfiguration Provides configuration to determine how to group results by document
#' attribute value, and how to display them (collapsed or expanded) under a
#' designated primary document for each group.
#'
#' @keywords internal
#'
#' @rdname kendra_query
kendra_query <- function(IndexId, QueryText = NULL, AttributeFilter = NULL, Facets = NULL, RequestedDocumentAttributes = NULL, QueryResultTypeFilter = NULL, DocumentRelevanceOverrideConfigurations = NULL, PageNumber = NULL, PageSize = NULL, SortingConfiguration = NULL, SortingConfigurations = NULL, UserContext = NULL, VisitorId = NULL, SpellCorrectionConfiguration = NULL, CollapseConfiguration = NULL) {
  op <- new_operation(
    name = "Query",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$query_input(IndexId = IndexId, QueryText = QueryText, AttributeFilter = AttributeFilter, Facets = Facets, RequestedDocumentAttributes = RequestedDocumentAttributes, QueryResultTypeFilter = QueryResultTypeFilter, DocumentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurations, PageNumber = PageNumber, PageSize = PageSize, SortingConfiguration = SortingConfiguration, SortingConfigurations = SortingConfigurations, UserContext = UserContext, VisitorId = VisitorId, SpellCorrectionConfiguration = SpellCorrectionConfiguration, CollapseConfiguration = CollapseConfiguration)
  output <- .kendra$query_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$query <- kendra_query

#' Retrieves relevant passages or text excerpts given an input query
#'
#' @description
#' Retrieves relevant passages or text excerpts given an input query.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_retrieve/](https://www.paws-r-sdk.com/docs/kendra_retrieve/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index to retrieve relevant passages for the
#' search.
#' @param QueryText &#91;required&#93; The input query text to retrieve relevant passages for the search.
#' Amazon Kendra truncates queries at 30 token words, which excludes
#' punctuation and stop words. Truncation still applies if you use Boolean
#' or more advanced, complex queries.
#' @param AttributeFilter Filters search results by document fields/attributes. You can only
#' provide one attribute filter; however, the `AndAllFilters`, `NotFilter`,
#' and `OrAllFilters` parameters contain a list of other filters.
#' 
#' The `AttributeFilter` parameter means you can create a set of filtering
#' rules that a document must satisfy to be included in the query results.
#' @param RequestedDocumentAttributes A list of document fields/attributes to include in the response. You can
#' limit the response to include certain document fields. By default, all
#' document fields are included in the response.
#' @param DocumentRelevanceOverrideConfigurations Overrides relevance tuning configurations of fields/attributes set at
#' the index level.
#' 
#' If you use this API to override the relevance tuning configured at the
#' index level, but there is no relevance tuning configured at the index
#' level, then Amazon Kendra does not apply any relevance tuning.
#' 
#' If there is relevance tuning configured for fields at the index level,
#' and you use this API to override only some of these fields, then for the
#' fields you did not override, the importance is set to 1.
#' @param PageNumber Retrieved relevant passages are returned in pages the size of the
#' `PageSize` parameter. By default, Amazon Kendra returns the first page
#' of results. Use this parameter to get result pages after the first one.
#' @param PageSize Sets the number of retrieved relevant passages that are returned in each
#' page of results. The default page size is 10. The maximum number of
#' results returned is 100. If you ask for more than 100 results, only 100
#' are returned.
#' @param UserContext The user context token or user and group information.
#'
#' @keywords internal
#'
#' @rdname kendra_retrieve
kendra_retrieve <- function(IndexId, QueryText, AttributeFilter = NULL, RequestedDocumentAttributes = NULL, DocumentRelevanceOverrideConfigurations = NULL, PageNumber = NULL, PageSize = NULL, UserContext = NULL) {
  op <- new_operation(
    name = "Retrieve",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$retrieve_input(IndexId = IndexId, QueryText = QueryText, AttributeFilter = AttributeFilter, RequestedDocumentAttributes = RequestedDocumentAttributes, DocumentRelevanceOverrideConfigurations = DocumentRelevanceOverrideConfigurations, PageNumber = PageNumber, PageSize = PageSize, UserContext = UserContext)
  output <- .kendra$retrieve_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$retrieve <- kendra_retrieve

#' Starts a synchronization job for a data source connector
#'
#' @description
#' Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon Kendra returns a `ResourceInUseException` exception.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_start_data_source_sync_job/](https://www.paws-r-sdk.com/docs/kendra_start_data_source_sync_job/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector to synchronize.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#'
#' @keywords internal
#'
#' @rdname kendra_start_data_source_sync_job
kendra_start_data_source_sync_job <- function(Id, IndexId) {
  op <- new_operation(
    name = "StartDataSourceSyncJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$start_data_source_sync_job_input(Id = Id, IndexId = IndexId)
  output <- .kendra$start_data_source_sync_job_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$start_data_source_sync_job <- kendra_start_data_source_sync_job

#' Stops a synchronization job that is currently running
#'
#' @description
#' Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_stop_data_source_sync_job/](https://www.paws-r-sdk.com/docs/kendra_stop_data_source_sync_job/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector for which to stop the
#' synchronization jobs.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#'
#' @keywords internal
#'
#' @rdname kendra_stop_data_source_sync_job
kendra_stop_data_source_sync_job <- function(Id, IndexId) {
  op <- new_operation(
    name = "StopDataSourceSyncJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$stop_data_source_sync_job_input(Id = Id, IndexId = IndexId)
  output <- .kendra$stop_data_source_sync_job_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$stop_data_source_sync_job <- kendra_stop_data_source_sync_job

#' Enables you to provide feedback to Amazon Kendra to improve the
#' performance of your index
#'
#' @description
#' Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_submit_feedback/](https://www.paws-r-sdk.com/docs/kendra_submit_feedback/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index that was queried.
#' @param QueryId &#91;required&#93; The identifier of the specific query for which you are submitting
#' feedback. The query ID is returned in the response to the
#' [`query`][kendra_query] API.
#' @param ClickFeedbackItems Tells Amazon Kendra that a particular search result link was chosen by
#' the user.
#' @param RelevanceFeedbackItems Provides Amazon Kendra with relevant or not relevant feedback for
#' whether a particular item was relevant to the search.
#'
#' @keywords internal
#'
#' @rdname kendra_submit_feedback
kendra_submit_feedback <- function(IndexId, QueryId, ClickFeedbackItems = NULL, RelevanceFeedbackItems = NULL) {
  op <- new_operation(
    name = "SubmitFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$submit_feedback_input(IndexId = IndexId, QueryId = QueryId, ClickFeedbackItems = ClickFeedbackItems, RelevanceFeedbackItems = RelevanceFeedbackItems)
  output <- .kendra$submit_feedback_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$submit_feedback <- kendra_submit_feedback

#' Adds the specified tag to the specified index, FAQ, or data source
#' resource
#'
#' @description
#' Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_tag_resource/](https://www.paws-r-sdk.com/docs/kendra_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the index, FAQ, or data source to tag.
#' @param Tags &#91;required&#93; A list of tag keys to add to the index, FAQ, or data source. If a tag
#' already exists, the existing value is replaced with the new value.
#'
#' @keywords internal
#'
#' @rdname kendra_tag_resource
kendra_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .kendra$tag_resource_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$tag_resource <- kendra_tag_resource

#' Removes a tag from an index, FAQ, or a data source
#'
#' @description
#' Removes a tag from an index, FAQ, or a data source.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_untag_resource/](https://www.paws-r-sdk.com/docs/kendra_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the index, FAQ, or data source to
#' remove the tag from.
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from the index, FAQ, or data source. If a
#' tag key does not exist on the resource, it is ignored.
#'
#' @keywords internal
#'
#' @rdname kendra_untag_resource
kendra_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .kendra$untag_resource_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$untag_resource <- kendra_untag_resource

#' Updates an access control configuration for your documents in an index
#'
#' @description
#' Updates an access control configuration for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_access_control_configuration/](https://www.paws-r-sdk.com/docs/kendra_update_access_control_configuration/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for an access control configuration.
#' @param Id &#91;required&#93; The identifier of the access control configuration you want to update.
#' @param Name A new name for the access control configuration.
#' @param Description A new description for the access control configuration.
#' @param AccessControlList Information you want to update on principals (users and/or groups) and
#' which documents they should have access to. This is useful for user
#' context filtering, where search results are filtered based on the user
#' or their group access to documents.
#' @param HierarchicalAccessControlList The updated list of
#' [principal](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Principal.html)
#' lists that define the hierarchy for which documents users should have
#' access to.
#'
#' @keywords internal
#'
#' @rdname kendra_update_access_control_configuration
kendra_update_access_control_configuration <- function(IndexId, Id, Name = NULL, Description = NULL, AccessControlList = NULL, HierarchicalAccessControlList = NULL) {
  op <- new_operation(
    name = "UpdateAccessControlConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_access_control_configuration_input(IndexId = IndexId, Id = Id, Name = Name, Description = Description, AccessControlList = AccessControlList, HierarchicalAccessControlList = HierarchicalAccessControlList)
  output <- .kendra$update_access_control_configuration_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_access_control_configuration <- kendra_update_access_control_configuration

#' Updates an existing Amazon Kendra data source connector
#'
#' @description
#' Updates an existing Amazon Kendra data source connector.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_data_source/](https://www.paws-r-sdk.com/docs/kendra_update_data_source/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the data source connector you want to update.
#' @param Name A new name for the data source connector.
#' @param IndexId &#91;required&#93; The identifier of the index used with the data source connector.
#' @param Configuration Configuration information you want to update for the data source
#' connector.
#' @param VpcConfiguration Configuration information for an Amazon Virtual Private Cloud to connect
#' to your data source. For more information, see [Configuring a
#' VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
#' @param Description A new description for the data source connector.
#' @param Schedule The sync schedule you want to update for the data source connector.
#' @param RoleArn The Amazon Resource Name (ARN) of a role with permission to access the
#' data source and required resources. For more information, see [IAM roles
#' for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param LanguageCode The code for a language you want to update for the data source
#' connector. This allows you to support a language for all documents when
#' updating the data source. English is supported by default. For more
#' information on supported languages, including their codes, see [Adding
#' documents in languages other than
#' English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
#' @param CustomDocumentEnrichmentConfiguration Configuration information you want to update for altering document
#' metadata and content during the document ingestion process.
#' 
#' For more information on how to create, modify and delete document
#' metadata, or make other content alterations when you ingest documents
#' into Amazon Kendra, see [Customizing document metadata during the
#' ingestion
#' process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
#'
#' @keywords internal
#'
#' @rdname kendra_update_data_source
kendra_update_data_source <- function(Id, Name = NULL, IndexId, Configuration = NULL, VpcConfiguration = NULL, Description = NULL, Schedule = NULL, RoleArn = NULL, LanguageCode = NULL, CustomDocumentEnrichmentConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_data_source_input(Id = Id, Name = Name, IndexId = IndexId, Configuration = Configuration, VpcConfiguration = VpcConfiguration, Description = Description, Schedule = Schedule, RoleArn = RoleArn, LanguageCode = LanguageCode, CustomDocumentEnrichmentConfiguration = CustomDocumentEnrichmentConfiguration)
  output <- .kendra$update_data_source_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_data_source <- kendra_update_data_source

#' Updates your Amazon Kendra experience such as a search application
#'
#' @description
#' Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_experience/](https://www.paws-r-sdk.com/docs/kendra_update_experience/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of your Amazon Kendra experience you want to update.
#' @param Name A new name for your Amazon Kendra experience.
#' @param IndexId &#91;required&#93; The identifier of the index for your Amazon Kendra experience.
#' @param RoleArn The Amazon Resource Name (ARN) of a role with permission to access
#' [`query`][kendra_query] API, `QuerySuggestions` API,
#' [`submit_feedback`][kendra_submit_feedback] API, and IAM Identity Center
#' that stores your user and group information. For more information, see
#' [IAM roles for Amazon
#' Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
#' @param Configuration Configuration information you want to update for your Amazon Kendra
#' experience.
#' @param Description A new description for your Amazon Kendra experience.
#'
#' @keywords internal
#'
#' @rdname kendra_update_experience
kendra_update_experience <- function(Id, Name = NULL, IndexId, RoleArn = NULL, Configuration = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateExperience",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_experience_input(Id = Id, Name = Name, IndexId = IndexId, RoleArn = RoleArn, Configuration = Configuration, Description = Description)
  output <- .kendra$update_experience_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_experience <- kendra_update_experience

#' Updates a set of featured results
#'
#' @description
#' Updates a set of featured results. Features results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match of a query, then one or more specific documents are featured in the search results.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_featured_results_set/](https://www.paws-r-sdk.com/docs/kendra_update_featured_results_set/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index used for featuring results.
#' @param FeaturedResultsSetId &#91;required&#93; The identifier of the set of featured results that you want to update.
#' @param FeaturedResultsSetName A new name for the set of featured results.
#' @param Description A new description for the set of featured results.
#' @param Status You can set the status to `ACTIVE` or `INACTIVE`. When the value is
#' `ACTIVE`, featured results are ready for use. You can still configure
#' your settings before setting the status to `ACTIVE`. The queries you
#' specify for featured results must be unique per featured results set for
#' each index, whether the status is `ACTIVE` or `INACTIVE`.
#' @param QueryTexts A list of queries for featuring results. For more information on the
#' list of queries, see
#' [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html).
#' @param FeaturedDocuments A list of document IDs for the documents you want to feature at the top
#' of the search results page. For more information on the list of featured
#' documents, see
#' [FeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html).
#'
#' @keywords internal
#'
#' @rdname kendra_update_featured_results_set
kendra_update_featured_results_set <- function(IndexId, FeaturedResultsSetId, FeaturedResultsSetName = NULL, Description = NULL, Status = NULL, QueryTexts = NULL, FeaturedDocuments = NULL) {
  op <- new_operation(
    name = "UpdateFeaturedResultsSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_featured_results_set_input(IndexId = IndexId, FeaturedResultsSetId = FeaturedResultsSetId, FeaturedResultsSetName = FeaturedResultsSetName, Description = Description, Status = Status, QueryTexts = QueryTexts, FeaturedDocuments = FeaturedDocuments)
  output <- .kendra$update_featured_results_set_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_featured_results_set <- kendra_update_featured_results_set

#' Updates an existing Amazon Kendra index
#'
#' @description
#' Updates an existing Amazon Kendra index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_index/](https://www.paws-r-sdk.com/docs/kendra_update_index/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the index you want to update.
#' @param Name The name of the index you want to update.
#' @param RoleArn An Identity and Access Management (IAM) role that gives Amazon Kendra
#' permission to access Amazon CloudWatch logs and metrics.
#' @param Description A new description for the index.
#' @param DocumentMetadataConfigurationUpdates The document metadata configuration you want to update for the index.
#' Document metadata are fields or attributes associated with your
#' documents. For example, the company department name associated with each
#' document.
#' @param CapacityUnits Sets the number of additional document storage and query capacity units
#' that should be used by the index. You can change the capacity of the
#' index up to 5 times per day, or make 5 API calls.
#' 
#' If you are using extra storage units, you can't reduce the storage
#' capacity below what is required to meet the storage needs for your
#' index.
#' @param UserTokenConfigurations The user token configuration.
#' @param UserContextPolicy The user context policy.
#' @param UserGroupResolutionConfiguration Enables fetching access levels of groups and users from an IAM Identity
#' Center identity source. To configure this, see
#' [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_UserGroupResolutionConfiguration.html).
#'
#' @keywords internal
#'
#' @rdname kendra_update_index
kendra_update_index <- function(Id, Name = NULL, RoleArn = NULL, Description = NULL, DocumentMetadataConfigurationUpdates = NULL, CapacityUnits = NULL, UserTokenConfigurations = NULL, UserContextPolicy = NULL, UserGroupResolutionConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_index_input(Id = Id, Name = Name, RoleArn = RoleArn, Description = Description, DocumentMetadataConfigurationUpdates = DocumentMetadataConfigurationUpdates, CapacityUnits = CapacityUnits, UserTokenConfigurations = UserTokenConfigurations, UserContextPolicy = UserContextPolicy, UserGroupResolutionConfiguration = UserGroupResolutionConfiguration)
  output <- .kendra$update_index_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_index <- kendra_update_index

#' Updates a block list used for query suggestions for an index
#'
#' @description
#' Updates a block list used for query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_block_list/](https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_block_list/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index for the block list.
#' @param Id &#91;required&#93; The identifier of the block list you want to update.
#' @param Name A new name for the block list.
#' @param Description A new description for the block list.
#' @param SourceS3Path The S3 path where your block list text file sits in S3.
#' 
#' If you update your block list and provide the same path to the block
#' list text file in S3, then Amazon Kendra reloads the file to refresh the
#' block list. Amazon Kendra does not automatically refresh your block
#' list. You need to call the
#' [`update_query_suggestions_block_list`][kendra_update_query_suggestions_block_list]
#' API to refresh you block list.
#' 
#' If you update your block list, then Amazon Kendra asynchronously
#' refreshes all query suggestions with the latest content in the S3 file.
#' This means changes might not take effect immediately.
#' @param RoleArn The IAM (Identity and Access Management) role used to access the block
#' list text file in S3.
#'
#' @keywords internal
#'
#' @rdname kendra_update_query_suggestions_block_list
kendra_update_query_suggestions_block_list <- function(IndexId, Id, Name = NULL, Description = NULL, SourceS3Path = NULL, RoleArn = NULL) {
  op <- new_operation(
    name = "UpdateQuerySuggestionsBlockList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_query_suggestions_block_list_input(IndexId = IndexId, Id = Id, Name = Name, Description = Description, SourceS3Path = SourceS3Path, RoleArn = RoleArn)
  output <- .kendra$update_query_suggestions_block_list_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_query_suggestions_block_list <- kendra_update_query_suggestions_block_list

#' Updates the settings of query suggestions for an index
#'
#' @description
#' Updates the settings of query suggestions for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_config/](https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_config/) for full documentation.
#'
#' @param IndexId &#91;required&#93; The identifier of the index with query suggestions you want to update.
#' @param Mode Set the mode to `ENABLED` or `LEARN_ONLY`.
#' 
#' By default, Amazon Kendra enables query suggestions. `LEARN_ONLY` mode
#' allows you to turn off query suggestions. You can to update this at any
#' time.
#' 
#' In `LEARN_ONLY` mode, Amazon Kendra continues to learn from new queries
#' to keep suggestions up to date for when you are ready to switch to
#' ENABLED mode again.
#' @param QueryLogLookBackWindowInDays How recent your queries are in your query log time window.
#' 
#' The time window is the number of days from current day to past days.
#' 
#' By default, Amazon Kendra sets this to 180.
#' @param IncludeQueriesWithoutUserInformation `TRUE` to include queries without user information (i.e. all queries,
#' irrespective of the user), otherwise `FALSE` to only include queries
#' with user information.
#' 
#' If you pass user information to Amazon Kendra along with the queries,
#' you can set this flag to `FALSE` and instruct Amazon Kendra to only
#' consider queries with user information.
#' 
#' If you set to `FALSE`, Amazon Kendra only considers queries searched at
#' least `MinimumQueryCount` times across `MinimumNumberOfQueryingUsers`
#' unique users for suggestions.
#' 
#' If you set to `TRUE`, Amazon Kendra ignores all user information and
#' learns from all queries.
#' @param MinimumNumberOfQueryingUsers The minimum number of unique users who must search a query in order for
#' the query to be eligible to suggest to your users.
#' 
#' Increasing this number might decrease the number of suggestions.
#' However, this ensures a query is searched by many users and is truly
#' popular to suggest to users.
#' 
#' How you tune this setting depends on your specific needs.
#' @param MinimumQueryCount The the minimum number of times a query must be searched in order to be
#' eligible to suggest to your users.
#' 
#' Decreasing this number increases the number of suggestions. However,
#' this affects the quality of suggestions as it sets a low bar for a query
#' to be considered popular to suggest to users.
#' 
#' How you tune this setting depends on your specific needs.
#' @param AttributeSuggestionsConfig Configuration information for the document fields/attributes that you
#' want to base query suggestions on.
#'
#' @keywords internal
#'
#' @rdname kendra_update_query_suggestions_config
kendra_update_query_suggestions_config <- function(IndexId, Mode = NULL, QueryLogLookBackWindowInDays = NULL, IncludeQueriesWithoutUserInformation = NULL, MinimumNumberOfQueryingUsers = NULL, MinimumQueryCount = NULL, AttributeSuggestionsConfig = NULL) {
  op <- new_operation(
    name = "UpdateQuerySuggestionsConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_query_suggestions_config_input(IndexId = IndexId, Mode = Mode, QueryLogLookBackWindowInDays = QueryLogLookBackWindowInDays, IncludeQueriesWithoutUserInformation = IncludeQueriesWithoutUserInformation, MinimumNumberOfQueryingUsers = MinimumNumberOfQueryingUsers, MinimumQueryCount = MinimumQueryCount, AttributeSuggestionsConfig = AttributeSuggestionsConfig)
  output <- .kendra$update_query_suggestions_config_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_query_suggestions_config <- kendra_update_query_suggestions_config

#' Updates a thesaurus for an index
#'
#' @description
#' Updates a thesaurus for an index.
#'
#' See [https://www.paws-r-sdk.com/docs/kendra_update_thesaurus/](https://www.paws-r-sdk.com/docs/kendra_update_thesaurus/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the thesaurus you want to update.
#' @param Name A new name for the thesaurus.
#' @param IndexId &#91;required&#93; The identifier of the index for the thesaurus.
#' @param Description A new description for the thesaurus.
#' @param RoleArn An IAM role that gives Amazon Kendra permissions to access thesaurus
#' file specified in `SourceS3Path`.
#' @param SourceS3Path 
#'
#' @keywords internal
#'
#' @rdname kendra_update_thesaurus
kendra_update_thesaurus <- function(Id, Name = NULL, IndexId, Description = NULL, RoleArn = NULL, SourceS3Path = NULL) {
  op <- new_operation(
    name = "UpdateThesaurus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kendra$update_thesaurus_input(Id = Id, Name = Name, IndexId = IndexId, Description = Description, RoleArn = RoleArn, SourceS3Path = SourceS3Path)
  output <- .kendra$update_thesaurus_output()
  config <- get_config()
  svc <- .kendra$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kendra$operations$update_thesaurus <- kendra_update_thesaurus
