% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchserviceserverless_operations.R
\name{opensearchserviceserverless_create_security_config}
\alias{opensearchserviceserverless_create_security_config}
\title{Specifies a security configuration for OpenSearch Serverless}
\usage{
opensearchserviceserverless_create_security_config(
  clientToken = NULL,
  description = NULL,
  iamIdentityCenterOptions = NULL,
  name,
  samlOptions = NULL,
  type
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier to ensure idempotency of the request.}

\item{description}{A description of the security configuration.}

\item{iamIdentityCenterOptions}{Describes IAM Identity Center options in the form of a key-value map.
This field is required if you specify iamidentitycenter for the type
parameter.}

\item{name}{[required] The name of the security configuration.}

\item{samlOptions}{Describes SAML options in in the form of a key-value map. This field is
required if you specify \code{saml} for the \code{type} parameter.}

\item{type}{[required] The type of security configuration.}
}
\description{
Specifies a security configuration for OpenSearch Serverless. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html}{SAML authentication for Amazon OpenSearch Serverless}.

See \url{https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_security_config/} for full documentation.
}
\keyword{internal}
