% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_asset_bundle_import_jobs}
\alias{quicksight_list_asset_bundle_import_jobs}
\title{Lists all asset bundle import jobs that have taken place in the last 14
days}
\usage{
quicksight_list_asset_bundle_import_jobs(
  AwsAccountId,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account that the import jobs were
executed in.}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{MaxResults}{The maximum number of results to be returned per request.}
}
\description{
Lists all asset bundle import jobs that have taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, \code{\link[=quicksight_list_asset_bundle_import_jobs]{list_asset_bundle_import_jobs}} only returns the most recent job that uses the repeated job ID.

See \url{https://www.paws-r-sdk.com/docs/quicksight_list_asset_bundle_import_jobs/} for full documentation.
}
\keyword{internal}
