% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_create_platform_application}
\alias{sns_create_platform_application}
\title{Creates a platform application object for one of the supported push
notification services, such as APNS and GCM (Firebase Cloud Messaging),
to which devices and mobile apps may register}
\usage{
sns_create_platform_application(Name, Platform, Attributes)
}
\arguments{
\item{Name}{[required] Application names must be made up of only uppercase and lowercase ASCII
letters, numbers, underscores, hyphens, and periods, and must be between
1 and 256 characters long.}

\item{Platform}{[required] The following platforms are supported: ADM (Amazon Device Messaging),
APNS (Apple Push Notification Service), APNS\\_SANDBOX, and GCM (Firebase
Cloud Messaging).}

\item{Attributes}{[required] For a list of attributes, see
\href{https://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html}{SetPlatformApplicationAttributes}}
}
\description{
Creates a platform application object for one of the supported push
notification services, such as APNS and GCM (Firebase Cloud Messaging),
to which devices and mobile apps may register. You must specify
\code{PlatformPrincipal} and \code{PlatformCredential} attributes when using the
\code{CreatePlatformApplication} action.

\code{PlatformPrincipal} and \code{PlatformCredential} are received from the
notification service.
\itemize{
\item For \code{ADM}, \code{PlatformPrincipal} is \verb{client id} and
\code{PlatformCredential} is \verb{client secret}.
\item For \code{Baidu}, \code{PlatformPrincipal} is \verb{API key} and
\code{PlatformCredential} is \verb{secret key}.
\item For \code{APNS} and \code{APNS_SANDBOX}, \code{PlatformPrincipal} is
\verb{SSL certificate} and \code{PlatformCredential} is \verb{private key}.
\item For \code{GCM} (Firebase Cloud Messaging), there is no
\code{PlatformPrincipal} and the \code{PlatformCredential} is \verb{API key}.
\item For \code{MPNS}, \code{PlatformPrincipal} is \verb{TLS certificate} and
\code{PlatformCredential} is \verb{private key}.
\item For \code{WNS}, \code{PlatformPrincipal} is \verb{Package Security Identifier} and
\code{PlatformCredential} is \verb{secret key}.
}

You can use the returned \code{PlatformApplicationArn} as an attribute for
the \code{CreatePlatformEndpoint} action.
}
\section{Request syntax}{
\preformatted{svc$create_platform_application(
  Name = "string",
  Platform = "string",
  Attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
