% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_list_activity_types}
\alias{swf_list_activity_types}
\title{Returns information about all activities registered in the specified
domain that match the specified name and registration status}
\usage{
swf_list_activity_types(domain, name, registrationStatus, nextPageToken,
  maximumPageSize, reverseOrder)
}
\arguments{
\item{domain}{[required] The name of the domain in which the activity types have been registered.}

\item{name}{If specified, only lists the activity types that have this name.}

\item{registrationStatus}{[required] Specifies the registration status of the activity types to list.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
60 seconds. Using an expired pagination token will return a \code{400} error:
"\verb{Specified token has exceeded its maximum lifetime}".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.}

\item{reverseOrder}{When set to \code{true}, returns the results in reverse order. By default,
the results are returned in ascending alphabetical order by \code{name} of
the activity types.}
}
\description{
Returns information about all activities registered in the specified
domain that match the specified name and registration status. The result
includes information like creation date, current status of the activity,
etc. The results may be split into multiple pages. To retrieve
subsequent pages, make the call again using the \code{nextPageToken} returned
by the initial call.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item You cannot use an IAM policy to constrain this action's parameters.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_activity_types(
  domain = "string",
  name = "string",
  registrationStatus = "REGISTERED"|"DEPRECATED",
  nextPageToken = "string",
  maximumPageSize = 123,
  reverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
