% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_dead_letter_source_queues}
\alias{sqs_list_dead_letter_source_queues}
\title{Returns a list of your queues that have the RedrivePolicy queue
attribute configured with a dead-letter queue}
\usage{
sqs_list_dead_letter_source_queues(QueueUrl, NextToken, MaxResults)
}
\arguments{
\item{QueueUrl}{[required] The URL of a dead-letter queue.

Queue URLs and names are case-sensitive.}

\item{NextToken}{Pagination token to request the next set of results.}

\item{MaxResults}{Maximum number of results to include in the response. Value range is 1
to 1000. You must set \code{MaxResults} to receive a value for \code{NextToken} in
the response.}
}
\value{
A list with the following syntax:\preformatted{list(
  queueUrls = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of your queues that have the \code{RedrivePolicy} queue
attribute configured with a dead-letter queue.

The
\code{\link[=sqs_list_dead_letter_source_queues]{list_dead_letter_source_queues}}
methods supports pagination. Set parameter \code{MaxResults} in the request
to specify the maximum number of results to be returned in the response.
If you do not set \code{MaxResults}, the response includes a maximum of 1,000
results. If you set \code{MaxResults} and there are additional results to
display, the response includes a value for \code{NextToken}. Use \code{NextToken}
as a parameter in your next request to
\code{\link[=sqs_list_dead_letter_source_queues]{list_dead_letter_source_queues}}
to receive the next page of results.

For more information about using dead-letter queues, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html}{Using Amazon SQS Dead-Letter Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_dead_letter_source_queues(
  QueueUrl = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
