% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_associate_tracker_consumer}
\alias{locationservice_associate_tracker_consumer}
\title{Creates an association between a geofence collection and a tracker
resource}
\usage{
locationservice_associate_tracker_consumer(ConsumerArn, TrackerName)
}
\arguments{
\item{ConsumerArn}{[required] The Amazon Resource Name (ARN) for the geofence collection to be
associated to tracker resource. Used when you need to specify a resource
across all AWS.
\itemize{
\item Format example:
\code{arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer}
}}

\item{TrackerName}{[required] The name of the tracker resource to be associated with a geofence
collection.}
}
\description{
Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.

See \url{https://paws-r.github.io/docs/locationservice/associate_tracker_consumer.html} for full documentation.
}
\keyword{internal}
