% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_update_state_machine}
\alias{sfn_update_state_machine}
\title{Updates an existing state machine by modifying its definition, roleArn,
or loggingConfiguration}
\usage{
sfn_update_state_machine(
  stateMachineArn,
  definition = NULL,
  roleArn = NULL,
  loggingConfiguration = NULL,
  tracingConfiguration = NULL
)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine.}

\item{definition}{The Amazon States Language definition of the state machine. See \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html}{Amazon States Language}.}

\item{roleArn}{The Amazon Resource Name (ARN) of the IAM role of the state machine.}

\item{loggingConfiguration}{The \code{LoggingConfiguration} data type is used to set CloudWatch Logs
options.}

\item{tracingConfiguration}{Selects whether AWS X-Ray tracing is enabled.}
}
\description{
Updates an existing state machine by modifying its \code{definition}, \code{roleArn}, or \code{loggingConfiguration}. Running executions will continue to use the previous \code{definition} and \code{roleArn}. You must include at least one of \code{definition} or \code{roleArn} or you will receive a \code{MissingRequiredParameter} error.

See \url{https://paws-r.github.io/docs/sfn/update_state_machine.html} for full documentation.
}
\keyword{internal}
