% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_create_queue}
\alias{sqs_create_queue}
\title{Creates a new standard or FIFO queue}
\usage{
sqs_create_queue(QueueName, Attributes = NULL, tags = NULL)
}
\arguments{
\item{QueueName}{[required] The name of the new queue. The following limits apply to this name:
\itemize{
\item A queue name can have up to 80 characters.
\item Valid values: alphanumeric characters, hyphens (\code{-}), and
underscores (\verb{_}).
\item A FIFO queue name must end with the \code{.fifo} suffix.
}

Queue URLs and names are case-sensitive.}

\item{Attributes}{A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{\link[=sqs_create_queue]{create_queue}} action
uses:
\itemize{
\item \code{DelaySeconds} – The length of time, in seconds, for which the
delivery of all messages in the queue is delayed. Valid values: An
integer from 0 to 900 seconds (15 minutes). Default: 0.
\item \code{MaximumMessageSize} – The limit of how many bytes a message can
contain before Amazon SQS rejects it. Valid values: An integer from
1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). Default: 262,144
(256 KiB).
\item \code{MessageRetentionPeriod} – The length of time, in seconds, for which
Amazon SQS retains a message. Valid values: An integer from 60
seconds (1 minute) to 1,209,600 seconds (14 days). Default: 345,600
(4 days).
\item \code{Policy} – The queue's policy. A valid Amazon Web Services policy.
For more information about policy structure, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}{Overview of Amazon Web Services IAM Policies}
in the \emph{Amazon IAM User Guide}.
\item \code{ReceiveMessageWaitTimeSeconds} – The length of time, in seconds,
for which a \code{\link[=sqs_receive_message]{receive_message}} action waits
for a message to arrive. Valid values: An integer from 0 to 20
(seconds). Default: 0.
\item \code{RedrivePolicy} – The string that includes the parameters for the
dead-letter queue functionality of the source queue as a JSON
object. For more information about the redrive policy and
dead-letter queues, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html}{Using Amazon SQS Dead-Letter Queues}
in the \emph{Amazon SQS Developer Guide}.
\itemize{
\item \code{deadLetterTargetArn} – The Amazon Resource Name (ARN) of the
dead-letter queue to which Amazon SQS moves messages after the
value of \code{maxReceiveCount} is exceeded.
\item \code{maxReceiveCount} – The number of times a message is delivered
to the source queue before being moved to the dead-letter queue.
When the \code{ReceiveCount} for a message exceeds the
\code{maxReceiveCount} for a queue, Amazon SQS moves the message to
the dead-letter-queue.
}

The dead-letter queue of a FIFO queue must also be a FIFO queue.
Similarly, the dead-letter queue of a standard queue must also be a
standard queue.
\item \code{VisibilityTimeout} – The visibility timeout for the queue, in
seconds. Valid values: An integer from 0 to 43,200 (12 hours).
Default: 30. For more information about the visibility timeout, see
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html}{Visibility Timeout}
in the \emph{Amazon SQS Developer Guide}.
}

The following attributes apply only to
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html}{server-side-encryption}:
\itemize{
\item \code{KmsMasterKeyId} – The ID of an Amazon Web Services managed customer
master key (CMK) for Amazon SQS or a custom CMK. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms}{Key Terms}.
While the alias of the Amazon Web Services managed CMK for Amazon
SQS is always \code{alias/aws/sqs}, the alias of a custom CMK can, for
example, be \code{alias/MyAlias }. For more examples, see
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters}{KeyId}
in the \emph{Key Management Service API Reference}.
\item \code{KmsDataKeyReusePeriodSeconds} – The length of time, in seconds, for
which Amazon SQS can reuse a \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys}{data key}
to encrypt or decrypt messages before calling KMS again. An integer
representing seconds, between 60 seconds (1 minute) and 86,400
seconds (24 hours). Default: 300 (5 minutes). A shorter time period
provides better security but results in more calls to KMS which
might incur charges after Free Tier. For more information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work}{How Does the Data Key Reuse Period Work?}.
\item \code{SqsManagedSseEnabled} – Enables server-side queue encryption using
SQS owned encryption keys. Only one server-side encryption option is
supported per queue (e.g.
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html}{SSE-KMS}
or
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html}{SSE-SQS}).
}

The following attributes apply only to \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html}{FIFO (first-in-first-out) queues}:
\itemize{
\item \code{FifoQueue} – Designates a queue as FIFO. Valid values are \code{true}
and \code{false}. If you don't specify the \code{FifoQueue} attribute, Amazon
SQS creates a standard queue. You can provide this attribute only
during queue creation. You can't change it for an existing queue.
When you set this attribute, you must also provide the
\code{MessageGroupId} for your messages explicitly.

For more information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html}{FIFO queue logic}
in the \emph{Amazon SQS Developer Guide}.
\item \code{ContentBasedDeduplication} – Enables content-based deduplication.
Valid values are \code{true} and \code{false}. For more information, see
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html}{Exactly-once processing}
in the \emph{Amazon SQS Developer Guide}. Note the following:
\itemize{
\item Every message must have a unique \code{MessageDeduplicationId}.
\itemize{
\item You may provide a \code{MessageDeduplicationId} explicitly.
\item If you aren't able to provide a \code{MessageDeduplicationId} and
you enable \code{ContentBasedDeduplication} for your queue,
Amazon SQS uses a SHA-256 hash to generate the
\code{MessageDeduplicationId} using the body of the message (but
not the attributes of the message).
\item If you don't provide a \code{MessageDeduplicationId} and the
queue doesn't have \code{ContentBasedDeduplication} set, the
action fails with an error.
\item If the queue has \code{ContentBasedDeduplication} set, your
\code{MessageDeduplicationId} overrides the generated one.
}
\item When \code{ContentBasedDeduplication} is in effect, messages with
identical content sent within the deduplication interval are
treated as duplicates and only one copy of the message is
delivered.
\item If you send one message with \code{ContentBasedDeduplication} enabled
and then another message with a \code{MessageDeduplicationId} that is
the same as the one generated for the first
\code{MessageDeduplicationId}, the two messages are treated as
duplicates and only one copy of the message is delivered.
}
}

The following attributes apply only to \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html}{high throughput for FIFO queues}:
\itemize{
\item \code{DeduplicationScope} – Specifies whether message deduplication
occurs at the message group or queue level. Valid values are
\code{messageGroup} and \code{queue}.
\item \code{FifoThroughputLimit} – Specifies whether the FIFO queue throughput
quota applies to the entire queue or per message group. Valid values
are \code{perQueue} and \code{perMessageGroupId}. The \code{perMessageGroupId}
value is allowed only when the value for \code{DeduplicationScope} is
\code{messageGroup}.
}

To enable high throughput for FIFO queues, do the following:
\itemize{
\item Set \code{DeduplicationScope} to \code{messageGroup}.
\item Set \code{FifoThroughputLimit} to \code{perMessageGroupId}.
}

If you set these attributes to anything other than the values shown for
enabling high throughput, normal throughput is in effect and
deduplication occurs as specified.

For information on throughput quotas, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html}{Quotas related to messages}
in the \emph{Amazon SQS Developer Guide}.}

\item{tags}{Add cost allocation tags to the specified Amazon SQS queue. For an
overview, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html}{Tagging Your Amazon SQS Queues}
in the \emph{Amazon SQS Developer Guide}.

When you use queue tags, keep the following guidelines in mind:
\itemize{
\item Adding more than 50 tags to a queue isn't recommended.
\item Tags don't have any semantic meaning. Amazon SQS interprets tags as
character strings.
\item Tags are case-sensitive.
\item A new tag with a key identical to that of an existing tag overwrites
the existing tag.
}

For a full list of tag restrictions, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-quotas.html#limits-queues}{Quotas related to queues}
in the \emph{Amazon SQS Developer Guide}.

To be able to tag a queue on creation, you must have the
\code{sqs:CreateQueue} and \code{sqs:TagQueue} permissions.

Cross-account permissions don't apply to this action. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-basic-examples-of-sqs-policies.html#grant-cross-account-permissions-to-role-and-user-name}{Grant cross-account permissions to a role and a user name}
in the \emph{Amazon SQS Developer Guide}.}
}
\description{
Creates a new standard or FIFO queue. You can pass one or more attributes in the request. Keep the following in mind:

See \url{https://paws-r.github.io/docs/sqs/create_queue.html} for full documentation.
}
\keyword{internal}
