% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_cancel_job}
\alias{batch_cancel_job}
\title{Cancels a job in an AWS Batch job queue}
\usage{
batch_cancel_job(jobId, reason)
}
\arguments{
\item{jobId}{[required] The AWS Batch job ID of the job to cancel.}

\item{reason}{[required] A message to attach to the job that explains the reason for canceling
it. This message is returned by future DescribeJobs operations on the
job. This message is also recorded in the AWS Batch activity logs.}
}
\description{
Cancels a job in an AWS Batch job queue. Jobs that are in the
\code{SUBMITTED}, \code{PENDING}, or \code{RUNNABLE} state are cancelled. Jobs that
have progressed to \code{STARTING} or \code{RUNNING} are not cancelled (but the
API operation still succeeds, even if no job is cancelled); these jobs
must be terminated with the TerminateJob operation.
}
\section{Request syntax}{
\preformatted{svc$cancel_job(
  jobId = "string",
  reason = "string"
)
}
}

\examples{
# This example cancels a job with the specified job ID.
\donttest{svc$cancel_job(
  jobId = "1d828f65-7a4d-42e8-996d-3b900ed59dc4",
  reason = "Cancelling job."
)}

}
\keyword{internal}
