% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_disk_from_snapshot}
\alias{lightsail_create_disk_from_snapshot}
\title{Creates a block storage disk from a manual or automatic snapshot of a
disk}
\usage{
lightsail_create_disk_from_snapshot(diskName, diskSnapshotName,
  availabilityZone, sizeInGb, tags, addOns, sourceDiskName, restoreDate,
  useLatestRestorableAutoSnapshot)
}
\arguments{
\item{diskName}{[required] The unique Lightsail disk name (e.g., \code{my-disk}).}

\item{diskSnapshotName}{The name of the disk snapshot (e.g., \code{my-snapshot}) from which to create
the new storage disk.

Constraint:
\itemize{
\item This parameter cannot be defined together with the
\verb{source disk name} parameter. The \verb{disk snapshot name} and
\verb{source disk name} parameters are mutually exclusive.
}}

\item{availabilityZone}{[required] The Availability Zone where you want to create the disk (e.g.,
\verb{us-east-2a}). Choose the same Availability Zone as the Lightsail
instance where you want to create the disk.

Use the GetRegions operation to list the Availability Zones where
Lightsail is currently available.}

\item{sizeInGb}{[required] The size of the disk in GB (e.g., \code{32}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{TagResource} action to tag a resource after it's created.}

\item{addOns}{An array of objects that represent the add-ons to enable for the new
disk.}

\item{sourceDiskName}{The name of the source disk from which the source automatic snapshot was
created.

Constraints:
\itemize{
\item This parameter cannot be defined together with the
\verb{disk snapshot name} parameter. The \verb{source disk name} and
\verb{disk snapshot name} parameters are mutually exclusive.
\item Define this parameter only when creating a new disk from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}

\item{restoreDate}{The date of the automatic snapshot to use for the new disk. Use the
\verb{get auto snapshots} operation to identify the dates of the available
automatic snapshots.

Constraints:
\itemize{
\item Must be specified in \code{YYYY-MM-DD} format.
\item This parameter cannot be defined together with the
\verb{use latest restorable auto snapshot} parameter. The \verb{restore date}
and \verb{use latest restorable auto snapshot} parameters are mutually
exclusive.
\item Define this parameter only when creating a new disk from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}

\item{useLatestRestorableAutoSnapshot}{A Boolean value to indicate whether to use the latest available
automatic snapshot.

Constraints:
\itemize{
\item This parameter cannot be defined together with the \verb{restore date}
parameter. The \verb{use latest restorable auto snapshot} and
\verb{restore date} parameters are mutually exclusive.
\item Define this parameter only when creating a new disk from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}
}
\description{
Creates a block storage disk from a manual or automatic snapshot of a
disk. The resulting disk can be attached to an Amazon Lightsail instance
in the same Availability Zone (e.g., \verb{us-east-2a}).

The \verb{create disk from snapshot} operation supports tag-based access
control via request tags and resource tags applied to the resource
identified by \verb{disk snapshot name}. For more information, see the
Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_disk_from_snapshot(
  diskName = "string",
  diskSnapshotName = "string",
  availabilityZone = "string",
  sizeInGb = 123,
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  addOns = list(
    list(
      addOnType = "AutoSnapshot",
      autoSnapshotAddOnRequest = list(
        snapshotTimeOfDay = "string"
      )
    )
  ),
  sourceDiskName = "string",
  restoreDate = "string",
  useLatestRestorableAutoSnapshot = TRUE|FALSE
)
}
}

\keyword{internal}
