# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ecr_service.R
NULL

#' Checks the availability of one or more image layers in a repository
#'
#' @description
#' Checks the availability of one or more image layers in a repository.
#' 
#' When an image is pushed to a repository, each image layer is checked to
#' verify if it has been uploaded before. If it has been uploaded, then the
#' image layer is skipped.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_batch_check_layer_availability(registryId, repositoryName,
#'   layerDigests)
#'
#' @param registryId The AWS account ID associated with the registry that contains the image
#' layers to check. If you do not specify a registry, the default registry
#' is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the image layers to
#' check.
#' @param layerDigests &#91;required&#93; The digests of the image layers to check.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   layers = list(
#'     list(
#'       layerDigest = "string",
#'       layerAvailability = "AVAILABLE"|"UNAVAILABLE",
#'       layerSize = 123,
#'       mediaType = "string"
#'     )
#'   ),
#'   failures = list(
#'     list(
#'       layerDigest = "string",
#'       failureCode = "InvalidLayerDigest"|"MissingLayerDigest",
#'       failureReason = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_check_layer_availability(
#'   registryId = "string",
#'   repositoryName = "string",
#'   layerDigests = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_batch_check_layer_availability
ecr_batch_check_layer_availability <- function(registryId = NULL, repositoryName, layerDigests) {
  op <- new_operation(
    name = "BatchCheckLayerAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_check_layer_availability_input(registryId = registryId, repositoryName = repositoryName, layerDigests = layerDigests)
  output <- .ecr$batch_check_layer_availability_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_check_layer_availability <- ecr_batch_check_layer_availability

#' Deletes a list of specified images within a repository
#'
#' @description
#' Deletes a list of specified images within a repository. Images are
#' specified with either an `imageTag` or `imageDigest`.
#' 
#' You can remove a tag from an image by specifying the image's tag in your
#' request. When you remove the last tag from an image, the image is
#' deleted from your repository.
#' 
#' You can completely delete an image (and all of its tags) by specifying
#' the image's digest in your request.
#'
#' @usage
#' ecr_batch_delete_image(registryId, repositoryName, imageIds)
#'
#' @param registryId The AWS account ID associated with the registry that contains the image
#' to delete. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the image to delete.
#' @param imageIds &#91;required&#93; A list of image ID references that correspond to images to delete. The
#' format of the `imageIds` reference is `imageTag=tag` or
#' `imageDigest=digest`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   ),
#'   failures = list(
#'     list(
#'       imageId = list(
#'         imageDigest = "string",
#'         imageTag = "string"
#'       ),
#'       failureCode = "InvalidImageDigest"|"InvalidImageTag"|"ImageTagDoesNotMatchDigest"|"ImageNotFound"|"MissingDigestAndTag"|"ImageReferencedByManifestList"|"KmsError",
#'       failureReason = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_image(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes images with the tags precise and trusty in a
#' # repository called ubuntu in the default registry for an account.
#' svc$batch_delete_image(
#'   imageIds = list(
#'     list(
#'       imageTag = "precise"
#'     )
#'   ),
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_batch_delete_image
ecr_batch_delete_image <- function(registryId = NULL, repositoryName, imageIds) {
  op <- new_operation(
    name = "BatchDeleteImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_delete_image_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds)
  output <- .ecr$batch_delete_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_delete_image <- ecr_batch_delete_image

#' Gets detailed information for an image
#'
#' @description
#' Gets detailed information for an image. Images are specified with either
#' an `imageTag` or `imageDigest`.
#' 
#' When an image is pulled, the BatchGetImage API is called once to
#' retrieve the image manifest.
#'
#' @usage
#' ecr_batch_get_image(registryId, repositoryName, imageIds,
#'   acceptedMediaTypes)
#'
#' @param registryId The AWS account ID associated with the registry that contains the images
#' to describe. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the images to describe.
#' @param imageIds &#91;required&#93; A list of image ID references that correspond to images to describe. The
#' format of the `imageIds` reference is `imageTag=tag` or
#' `imageDigest=digest`.
#' @param acceptedMediaTypes The accepted media types for the request.
#' 
#' Valid values: `application/vnd.docker.distribution.manifest.v1+json` |
#' `application/vnd.docker.distribution.manifest.v2+json` |
#' `application/vnd.oci.image.manifest.v1+json`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   images = list(
#'     list(
#'       registryId = "string",
#'       repositoryName = "string",
#'       imageId = list(
#'         imageDigest = "string",
#'         imageTag = "string"
#'       ),
#'       imageManifest = "string",
#'       imageManifestMediaType = "string"
#'     )
#'   ),
#'   failures = list(
#'     list(
#'       imageId = list(
#'         imageDigest = "string",
#'         imageTag = "string"
#'       ),
#'       failureCode = "InvalidImageDigest"|"InvalidImageTag"|"ImageTagDoesNotMatchDigest"|"ImageNotFound"|"MissingDigestAndTag"|"ImageReferencedByManifestList"|"KmsError",
#'       failureReason = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_image(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   ),
#'   acceptedMediaTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example obtains information for an image with a specified image
#' # digest ID from the repository named ubuntu in the current account.
#' svc$batch_get_image(
#'   imageIds = list(
#'     list(
#'       imageTag = "precise"
#'     )
#'   ),
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_batch_get_image
ecr_batch_get_image <- function(registryId = NULL, repositoryName, imageIds, acceptedMediaTypes = NULL) {
  op <- new_operation(
    name = "BatchGetImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_get_image_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, acceptedMediaTypes = acceptedMediaTypes)
  output <- .ecr$batch_get_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_get_image <- ecr_batch_get_image

#' Informs Amazon ECR that the image layer upload has completed for a
#' specified registry, repository name, and upload ID
#'
#' @description
#' Informs Amazon ECR that the image layer upload has completed for a
#' specified registry, repository name, and upload ID. You can optionally
#' provide a `sha256` digest of the image layer for data validation
#' purposes.
#' 
#' When an image is pushed, the CompleteLayerUpload API is called once per
#' each new image layer to verify that the upload has completed.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_complete_layer_upload(registryId, repositoryName, uploadId,
#'   layerDigests)
#'
#' @param registryId The AWS account ID associated with the registry to which to upload
#' layers. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to associate with the image layer.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecr_initiate_layer_upload] operation to
#' associate with the image layer.
#' @param layerDigests &#91;required&#93; The `sha256` digest of the image layer.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   uploadId = "string",
#'   layerDigest = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$complete_layer_upload(
#'   registryId = "string",
#'   repositoryName = "string",
#'   uploadId = "string",
#'   layerDigests = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_complete_layer_upload
ecr_complete_layer_upload <- function(registryId = NULL, repositoryName, uploadId, layerDigests) {
  op <- new_operation(
    name = "CompleteLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$complete_layer_upload_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, layerDigests = layerDigests)
  output <- .ecr$complete_layer_upload_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$complete_layer_upload <- ecr_complete_layer_upload

#' Creates a repository
#'
#' @description
#' Creates a repository. For more information, see [Amazon ECR
#' Repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_create_repository(repositoryName, tags, imageTagMutability,
#'   imageScanningConfiguration, encryptionConfiguration)
#'
#' @param repositoryName &#91;required&#93; The name to use for the repository. The repository name may be specified
#' on its own (such as `nginx-web-app`) or it can be prepended with a
#' namespace to group the repository into a category (such as
#' `project-a/nginx-web-app`).
#' @param tags The metadata that you apply to the repository to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define. Tag keys can have a maximum character length of 128
#' characters, and tag values can have a maximum length of 256 characters.
#' @param imageTagMutability The tag mutability setting for the repository. If this parameter is
#' omitted, the default setting of `MUTABLE` will be used which will allow
#' image tags to be overwritten. If `IMMUTABLE` is specified, all image
#' tags within the repository will be immutable which will prevent them
#' from being overwritten.
#' @param imageScanningConfiguration The image scanning configuration for the repository. This determines
#' whether images are scanned for known vulnerabilities after being pushed
#' to the repository.
#' @param encryptionConfiguration The encryption configuration for the repository. This determines how the
#' contents of your repository are encrypted at rest.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   repository = list(
#'     repositoryArn = "string",
#'     registryId = "string",
#'     repositoryName = "string",
#'     repositoryUri = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     imageTagMutability = "MUTABLE"|"IMMUTABLE",
#'     imageScanningConfiguration = list(
#'       scanOnPush = TRUE|FALSE
#'     ),
#'     encryptionConfiguration = list(
#'       encryptionType = "AES256"|"KMS",
#'       kmsKey = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_repository(
#'   repositoryName = "string",
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   imageTagMutability = "MUTABLE"|"IMMUTABLE",
#'   imageScanningConfiguration = list(
#'     scanOnPush = TRUE|FALSE
#'   ),
#'   encryptionConfiguration = list(
#'     encryptionType = "AES256"|"KMS",
#'     kmsKey = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a repository called nginx-web-app inside the
#' # project-a namespace in the default registry for an account.
#' svc$create_repository(
#'   repositoryName = "project-a/nginx-web-app"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_create_repository
ecr_create_repository <- function(repositoryName, tags = NULL, imageTagMutability = NULL, imageScanningConfiguration = NULL, encryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$create_repository_input(repositoryName = repositoryName, tags = tags, imageTagMutability = imageTagMutability, imageScanningConfiguration = imageScanningConfiguration, encryptionConfiguration = encryptionConfiguration)
  output <- .ecr$create_repository_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$create_repository <- ecr_create_repository

#' Deletes the lifecycle policy associated with the specified repository
#'
#' @description
#' Deletes the lifecycle policy associated with the specified repository.
#'
#' @usage
#' ecr_delete_lifecycle_policy(registryId, repositoryName)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string",
#'   lastEvaluatedAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_lifecycle_policy(
#'   registryId = "string",
#'   repositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_delete_lifecycle_policy
ecr_delete_lifecycle_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "DeleteLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$delete_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_lifecycle_policy <- ecr_delete_lifecycle_policy

#' Deletes the registry permissions policy
#'
#' @description
#' Deletes the registry permissions policy.
#'
#' @usage
#' ecr_delete_registry_policy()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_registry_policy()
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_delete_registry_policy
ecr_delete_registry_policy <- function() {
  op <- new_operation(
    name = "DeleteRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_registry_policy_input()
  output <- .ecr$delete_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_registry_policy <- ecr_delete_registry_policy

#' Deletes a repository
#'
#' @description
#' Deletes a repository. If the repository contains images, you must either
#' delete all images in the repository or use the `force` option to delete
#' the repository.
#'
#' @usage
#' ecr_delete_repository(registryId, repositoryName, force)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository to delete. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to delete.
#' @param force If a repository contains images, forces the deletion.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   repository = list(
#'     repositoryArn = "string",
#'     registryId = "string",
#'     repositoryName = "string",
#'     repositoryUri = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     imageTagMutability = "MUTABLE"|"IMMUTABLE",
#'     imageScanningConfiguration = list(
#'       scanOnPush = TRUE|FALSE
#'     ),
#'     encryptionConfiguration = list(
#'       encryptionType = "AES256"|"KMS",
#'       kmsKey = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_repository(
#'   registryId = "string",
#'   repositoryName = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example force deletes a repository named ubuntu in the default
#' # registry for an account. The force parameter is required if the
#' # repository contains images.
#' svc$delete_repository(
#'   force = TRUE,
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_delete_repository
ecr_delete_repository <- function(registryId = NULL, repositoryName, force = NULL) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_repository_input(registryId = registryId, repositoryName = repositoryName, force = force)
  output <- .ecr$delete_repository_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_repository <- ecr_delete_repository

#' Deletes the repository policy associated with the specified repository
#'
#' @description
#' Deletes the repository policy associated with the specified repository.
#'
#' @usage
#' ecr_delete_repository_policy(registryId, repositoryName)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository policy to delete. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the repository policy
#' to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_repository_policy(
#'   registryId = "string",
#'   repositoryName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the policy associated with the repository named
#' # ubuntu in the current account.
#' svc$delete_repository_policy(
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_delete_repository_policy
ecr_delete_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "DeleteRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$delete_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_repository_policy <- ecr_delete_repository_policy

#' Returns the scan findings for the specified image
#'
#' @description
#' Returns the scan findings for the specified image.
#'
#' @usage
#' ecr_describe_image_scan_findings(registryId, repositoryName, imageId,
#'   nextToken, maxResults)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to describe the image scan findings for. If you do
#' not specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository for the image for which to describe the scan findings.
#' @param imageId &#91;required&#93; 
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value. This value is null when
#' there are no more results to return.
#' @param maxResults The maximum number of image scan results returned by
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings] in
#' paginated output. When this parameter is used,
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' returns up to 100 results and a `nextToken` value, if applicable.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageId = list(
#'     imageDigest = "string",
#'     imageTag = "string"
#'   ),
#'   imageScanStatus = list(
#'     status = "IN_PROGRESS"|"COMPLETE"|"FAILED",
#'     description = "string"
#'   ),
#'   imageScanFindings = list(
#'     imageScanCompletedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     vulnerabilitySourceUpdatedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     findings = list(
#'       list(
#'         name = "string",
#'         description = "string",
#'         uri = "string",
#'         severity = "INFORMATIONAL"|"LOW"|"MEDIUM"|"HIGH"|"CRITICAL"|"UNDEFINED",
#'         attributes = list(
#'           list(
#'             key = "string",
#'             value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     findingSeverityCounts = list(
#'       123
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_image_scan_findings(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageId = list(
#'     imageDigest = "string",
#'     imageTag = "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_describe_image_scan_findings
ecr_describe_image_scan_findings <- function(registryId = NULL, repositoryName, imageId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeImageScanFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_image_scan_findings_input(registryId = registryId, repositoryName = repositoryName, imageId = imageId, nextToken = nextToken, maxResults = maxResults)
  output <- .ecr$describe_image_scan_findings_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_image_scan_findings <- ecr_describe_image_scan_findings

#' Returns metadata about the images in a repository
#'
#' @description
#' Returns metadata about the images in a repository.
#' 
#' Beginning with Docker version 1.9, the Docker client compresses image
#' layers before pushing them to a V2 Docker registry. The output of the
#' `docker images` command shows the uncompressed image size, so it may
#' return a larger image size than the image sizes returned by
#' [`describe_images`][ecr_describe_images].
#'
#' @usage
#' ecr_describe_images(registryId, repositoryName, imageIds, nextToken,
#'   maxResults, filter)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to describe images. If you do not specify a
#' registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the images to describe.
#' @param imageIds The list of image IDs for the requested repository.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_images`][ecr_describe_images] request where `maxResults` was
#' used and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value. This value is `null` when there are no more results
#' to return. This option cannot be used when you specify images with
#' `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_images`][ecr_describe_images] in paginated output. When this
#' parameter is used, [`describe_images`][ecr_describe_images] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_images`][ecr_describe_images] request with
#' the returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then
#' [`describe_images`][ecr_describe_images] returns up to 100 results and a
#' `nextToken` value, if applicable. This option cannot be used when you
#' specify images with `imageIds`.
#' @param filter The filter key and value with which to filter your
#' [`describe_images`][ecr_describe_images] results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   imageDetails = list(
#'     list(
#'       registryId = "string",
#'       repositoryName = "string",
#'       imageDigest = "string",
#'       imageTags = list(
#'         "string"
#'       ),
#'       imageSizeInBytes = 123,
#'       imagePushedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       imageScanStatus = list(
#'         status = "IN_PROGRESS"|"COMPLETE"|"FAILED",
#'         description = "string"
#'       ),
#'       imageScanFindingsSummary = list(
#'         imageScanCompletedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         vulnerabilitySourceUpdatedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         findingSeverityCounts = list(
#'           123
#'         )
#'       ),
#'       imageManifestMediaType = "string",
#'       artifactMediaType = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_images(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123,
#'   filter = list(
#'     tagStatus = "TAGGED"|"UNTAGGED"|"ANY"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_describe_images
ecr_describe_images <- function(registryId = NULL, repositoryName, imageIds = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_images_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$describe_images_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_images <- ecr_describe_images

#' Describes the settings for a registry
#'
#' @description
#' Describes the settings for a registry. The replication configuration for
#' a repository can be created or updated with the
#' [`put_replication_configuration`][ecr_put_replication_configuration] API
#' action.
#'
#' @usage
#' ecr_describe_registry()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   replicationConfiguration = list(
#'     rules = list(
#'       list(
#'         destinations = list(
#'           list(
#'             region = "string",
#'             registryId = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_registry()
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_describe_registry
ecr_describe_registry <- function() {
  op <- new_operation(
    name = "DescribeRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_registry_input()
  output <- .ecr$describe_registry_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_registry <- ecr_describe_registry

#' Describes image repositories in a registry
#'
#' @description
#' Describes image repositories in a registry.
#'
#' @usage
#' ecr_describe_repositories(registryId, repositoryNames, nextToken,
#'   maxResults)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repositories to be described. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryNames A list of repositories to describe. If this parameter is omitted, then
#' all repositories in a registry are described.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_repositories`][ecr_describe_repositories] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return. This option cannot be used when you specify
#' repositories with `repositoryNames`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_repositories`][ecr_describe_repositories] in paginated
#' output. When this parameter is used,
#' [`describe_repositories`][ecr_describe_repositories] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_repositories`][ecr_describe_repositories]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_repositories`][ecr_describe_repositories] returns up to 100
#' results and a `nextToken` value, if applicable. This option cannot be
#' used when you specify repositories with `repositoryNames`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   repositories = list(
#'     list(
#'       repositoryArn = "string",
#'       registryId = "string",
#'       repositoryName = "string",
#'       repositoryUri = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       imageTagMutability = "MUTABLE"|"IMMUTABLE",
#'       imageScanningConfiguration = list(
#'         scanOnPush = TRUE|FALSE
#'       ),
#'       encryptionConfiguration = list(
#'         encryptionType = "AES256"|"KMS",
#'         kmsKey = "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_repositories(
#'   registryId = "string",
#'   repositoryNames = list(
#'     "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example obtains a list and description of all repositories
#' # in the default registry to which the current user has access.
#' svc$describe_repositories()
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_describe_repositories
ecr_describe_repositories <- function(registryId = NULL, repositoryNames = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_repositories_input(registryId = registryId, repositoryNames = repositoryNames, nextToken = nextToken, maxResults = maxResults)
  output <- .ecr$describe_repositories_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_repositories <- ecr_describe_repositories

#' Retrieves an authorization token
#'
#' @description
#' Retrieves an authorization token. An authorization token represents your
#' IAM authentication credentials and can be used to access any Amazon ECR
#' registry that your IAM principal has access to. The authorization token
#' is valid for 12 hours.
#' 
#' The `authorizationToken` returned is a base64 encoded string that can be
#' decoded and used in a `docker login` command to authenticate to a
#' registry. The AWS CLI offers an `get-login-password` command that
#' simplifies the login process. For more information, see [Registry
#' Authentication](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_get_authorization_token(registryIds)
#'
#' @param registryIds A list of AWS account IDs that are associated with the registries for
#' which to get AuthorizationData objects. If you do not specify a
#' registry, the default registry is assumed.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   authorizationData = list(
#'     list(
#'       authorizationToken = "string",
#'       expiresAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       proxyEndpoint = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_authorization_token(
#'   registryIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets an authorization token for your default registry.
#' svc$get_authorization_token()
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_get_authorization_token
ecr_get_authorization_token <- function(registryIds = NULL) {
  op <- new_operation(
    name = "GetAuthorizationToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_authorization_token_input(registryIds = registryIds)
  output <- .ecr$get_authorization_token_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_authorization_token <- ecr_get_authorization_token

#' Retrieves the pre-signed Amazon S3 download URL corresponding to an
#' image layer
#'
#' @description
#' Retrieves the pre-signed Amazon S3 download URL corresponding to an
#' image layer. You can only get URLs for image layers that are referenced
#' in an image.
#' 
#' When an image is pulled, the GetDownloadUrlForLayer API is called once
#' per image layer that is not already cached.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_get_download_url_for_layer(registryId, repositoryName, layerDigest)
#'
#' @param registryId The AWS account ID associated with the registry that contains the image
#' layer to download. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the image layer to
#' download.
#' @param layerDigest &#91;required&#93; The digest of the image layer to download.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   downloadUrl = "string",
#'   layerDigest = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_download_url_for_layer(
#'   registryId = "string",
#'   repositoryName = "string",
#'   layerDigest = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_get_download_url_for_layer
ecr_get_download_url_for_layer <- function(registryId = NULL, repositoryName, layerDigest) {
  op <- new_operation(
    name = "GetDownloadUrlForLayer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_download_url_for_layer_input(registryId = registryId, repositoryName = repositoryName, layerDigest = layerDigest)
  output <- .ecr$get_download_url_for_layer_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_download_url_for_layer <- ecr_get_download_url_for_layer

#' Retrieves the lifecycle policy for the specified repository
#'
#' @description
#' Retrieves the lifecycle policy for the specified repository.
#'
#' @usage
#' ecr_get_lifecycle_policy(registryId, repositoryName)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string",
#'   lastEvaluatedAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_lifecycle_policy(
#'   registryId = "string",
#'   repositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_get_lifecycle_policy
ecr_get_lifecycle_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$get_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_lifecycle_policy <- ecr_get_lifecycle_policy

#' Retrieves the results of the lifecycle policy preview request for the
#' specified repository
#'
#' @description
#' Retrieves the results of the lifecycle policy preview request for the
#' specified repository.
#'
#' @usage
#' ecr_get_lifecycle_policy_preview(registryId, repositoryName, imageIds,
#'   nextToken, maxResults, filter)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#' @param imageIds The list of imageIDs to be included.
#' @param nextToken The `nextToken` value returned from a previous paginated 
#' `GetLifecyclePolicyPreviewRequest` request where `maxResults` was used
#' and the  results exceeded the value of that parameter. Pagination
#' continues from the end of the  previous results that returned the
#' `nextToken` value. This value is  `null` when there are no more results
#' to return. This option cannot be used when you specify images with
#' `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' `GetLifecyclePolicyPreviewRequest` in  paginated output. When this
#' parameter is used, `GetLifecyclePolicyPreviewRequest` only returns 
#' `maxResults` results in a single page along with a `nextToken`  response
#' element. The remaining results of the initial request can be seen by
#' sending  another `GetLifecyclePolicyPreviewRequest` request with the
#' returned `nextToken`  value. This value can be between 1 and 1000. If
#' this  parameter is not used, then `GetLifecyclePolicyPreviewRequest`
#' returns up to  100 results and a `nextToken` value, if  applicable. This
#' option cannot be used when you specify images with `imageIds`.
#' @param filter An optional parameter that filters results based on image tag status and
#' all tags, if tagged.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string",
#'   status = "IN_PROGRESS"|"COMPLETE"|"EXPIRED"|"FAILED",
#'   nextToken = "string",
#'   previewResults = list(
#'     list(
#'       imageTags = list(
#'         "string"
#'       ),
#'       imageDigest = "string",
#'       imagePushedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       action = list(
#'         type = "EXPIRE"
#'       ),
#'       appliedRulePriority = 123
#'     )
#'   ),
#'   summary = list(
#'     expiringImageTotalCount = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_lifecycle_policy_preview(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123,
#'   filter = list(
#'     tagStatus = "TAGGED"|"UNTAGGED"|"ANY"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_get_lifecycle_policy_preview
ecr_get_lifecycle_policy_preview <- function(registryId = NULL, repositoryName, imageIds = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "GetLifecyclePolicyPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_lifecycle_policy_preview_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$get_lifecycle_policy_preview_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_lifecycle_policy_preview <- ecr_get_lifecycle_policy_preview

#' Retrieves the permissions policy for a registry
#'
#' @description
#' Retrieves the permissions policy for a registry.
#'
#' @usage
#' ecr_get_registry_policy()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_registry_policy()
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_get_registry_policy
ecr_get_registry_policy <- function() {
  op <- new_operation(
    name = "GetRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_registry_policy_input()
  output <- .ecr$get_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_registry_policy <- ecr_get_registry_policy

#' Retrieves the repository policy for the specified repository
#'
#' @description
#' Retrieves the repository policy for the specified repository.
#'
#' @usage
#' ecr_get_repository_policy(registryId, repositoryName)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository with the policy to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_repository_policy(
#'   registryId = "string",
#'   repositoryName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example obtains the repository policy for the repository named
#' # ubuntu.
#' svc$get_repository_policy(
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_get_repository_policy
ecr_get_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$get_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_repository_policy <- ecr_get_repository_policy

#' Notifies Amazon ECR that you intend to upload an image layer
#'
#' @description
#' Notifies Amazon ECR that you intend to upload an image layer.
#' 
#' When an image is pushed, the InitiateLayerUpload API is called once per
#' image layer that has not already been uploaded. Whether or not an image
#' layer has been uploaded is determined by the BatchCheckLayerAvailability
#' API action.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_initiate_layer_upload(registryId, repositoryName)
#'
#' @param registryId The AWS account ID associated with the registry to which you intend to
#' upload layers. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you intend to upload layers.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   uploadId = "string",
#'   partSize = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$initiate_layer_upload(
#'   registryId = "string",
#'   repositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_initiate_layer_upload
ecr_initiate_layer_upload <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "InitiateLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$initiate_layer_upload_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$initiate_layer_upload_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$initiate_layer_upload <- ecr_initiate_layer_upload

#' Lists all the image IDs for the specified repository
#'
#' @description
#' Lists all the image IDs for the specified repository.
#' 
#' You can filter images based on whether or not they are tagged by using
#' the `tagStatus` filter and specifying either `TAGGED`, `UNTAGGED` or
#' `ANY`. For example, you can filter your results to return only
#' `UNTAGGED` images and then pipe that result to a
#' [`batch_delete_image`][ecr_batch_delete_image] operation to delete them.
#' Or, you can filter your results to return only `TAGGED` images to list
#' all of the tags in your repository.
#'
#' @usage
#' ecr_list_images(registryId, repositoryName, nextToken, maxResults,
#'   filter)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to list images. If you do not specify a registry,
#' the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository with image IDs to be listed.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_images`][ecr_list_images] request where `maxResults` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value. This value is `null` when there are no more results to return.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of image results returned by
#' [`list_images`][ecr_list_images] in paginated output. When this
#' parameter is used, [`list_images`][ecr_list_images] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`list_images`][ecr_list_images] request with the
#' returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then [`list_images`][ecr_list_images]
#' returns up to 100 results and a `nextToken` value, if applicable.
#' @param filter The filter key and value with which to filter your
#' [`list_images`][ecr_list_images] results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   imageIds = list(
#'     list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_images(
#'   registryId = "string",
#'   repositoryName = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   filter = list(
#'     tagStatus = "TAGGED"|"UNTAGGED"|"ANY"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example lists all of the images in the repository named ubuntu in
#' # the default registry in the current account.
#' svc$list_images(
#'   repositoryName = "ubuntu"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname ecr_list_images
ecr_list_images <- function(registryId = NULL, repositoryName, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$list_images_input(registryId = registryId, repositoryName = repositoryName, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$list_images_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$list_images <- ecr_list_images

#' List the tags for an Amazon ECR resource
#'
#' @description
#' List the tags for an Amazon ECR resource.
#'
#' @usage
#' ecr_list_tags_for_resource(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the only supported resource is an Amazon ECR
#' repository.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_list_tags_for_resource
ecr_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ecr$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$list_tags_for_resource <- ecr_list_tags_for_resource

#' Creates or updates the image manifest and tags associated with an image
#'
#' @description
#' Creates or updates the image manifest and tags associated with an image.
#' 
#' When an image is pushed and all new image layers have been uploaded, the
#' PutImage API is called once to create or update the image manifest and
#' the tags associated with the image.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_put_image(registryId, repositoryName, imageManifest,
#'   imageManifestMediaType, imageTag, imageDigest)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to put the image. If you do not specify a registry,
#' the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to put the image.
#' @param imageManifest &#91;required&#93; The image manifest corresponding to the image to be uploaded.
#' @param imageManifestMediaType The media type of the image manifest. If you push an image manifest that
#' does not contain the `mediaType` field, you must specify the
#' `imageManifestMediaType` in the request.
#' @param imageTag The tag to associate with the image. This parameter is required for
#' images that use the Docker Image Manifest V2 Schema 2 or Open Container
#' Initiative (OCI) formats.
#' @param imageDigest The image digest of the image manifest corresponding to the image.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   image = list(
#'     registryId = "string",
#'     repositoryName = "string",
#'     imageId = list(
#'       imageDigest = "string",
#'       imageTag = "string"
#'     ),
#'     imageManifest = "string",
#'     imageManifestMediaType = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_image(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageManifest = "string",
#'   imageManifestMediaType = "string",
#'   imageTag = "string",
#'   imageDigest = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_image
ecr_put_image <- function(registryId = NULL, repositoryName, imageManifest, imageManifestMediaType = NULL, imageTag = NULL, imageDigest = NULL) {
  op <- new_operation(
    name = "PutImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_input(registryId = registryId, repositoryName = repositoryName, imageManifest = imageManifest, imageManifestMediaType = imageManifestMediaType, imageTag = imageTag, imageDigest = imageDigest)
  output <- .ecr$put_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image <- ecr_put_image

#' Updates the image scanning configuration for the specified repository
#'
#' @description
#' Updates the image scanning configuration for the specified repository.
#'
#' @usage
#' ecr_put_image_scanning_configuration(registryId, repositoryName,
#'   imageScanningConfiguration)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to update the image scanning configuration setting.
#' If you do not specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to update the image scanning
#' configuration setting.
#' @param imageScanningConfiguration &#91;required&#93; The image scanning configuration for the repository. This setting
#' determines whether images are scanned for known vulnerabilities after
#' being pushed to the repository.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageScanningConfiguration = list(
#'     scanOnPush = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_image_scanning_configuration(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageScanningConfiguration = list(
#'     scanOnPush = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_image_scanning_configuration
ecr_put_image_scanning_configuration <- function(registryId = NULL, repositoryName, imageScanningConfiguration) {
  op <- new_operation(
    name = "PutImageScanningConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_scanning_configuration_input(registryId = registryId, repositoryName = repositoryName, imageScanningConfiguration = imageScanningConfiguration)
  output <- .ecr$put_image_scanning_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image_scanning_configuration <- ecr_put_image_scanning_configuration

#' Updates the image tag mutability settings for the specified repository
#'
#' @description
#' Updates the image tag mutability settings for the specified repository.
#' For more information, see [Image Tag
#' Mutability](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_put_image_tag_mutability(registryId, repositoryName,
#'   imageTagMutability)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to update the image tag mutability settings. If you
#' do not specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to update the image tag mutability
#' settings.
#' @param imageTagMutability &#91;required&#93; The tag mutability setting for the repository. If `MUTABLE` is
#' specified, image tags can be overwritten. If `IMMUTABLE` is specified,
#' all image tags within the repository will be immutable which will
#' prevent them from being overwritten.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageTagMutability = "MUTABLE"|"IMMUTABLE"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_image_tag_mutability(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageTagMutability = "MUTABLE"|"IMMUTABLE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_image_tag_mutability
ecr_put_image_tag_mutability <- function(registryId = NULL, repositoryName, imageTagMutability) {
  op <- new_operation(
    name = "PutImageTagMutability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_tag_mutability_input(registryId = registryId, repositoryName = repositoryName, imageTagMutability = imageTagMutability)
  output <- .ecr$put_image_tag_mutability_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image_tag_mutability <- ecr_put_image_tag_mutability

#' Creates or updates the lifecycle policy for the specified repository
#'
#' @description
#' Creates or updates the lifecycle policy for the specified repository.
#' For more information, see [Lifecycle Policy
#' Template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html).
#'
#' @usage
#' ecr_put_lifecycle_policy(registryId, repositoryName,
#'   lifecyclePolicyText)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do  not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to receive the policy.
#' @param lifecyclePolicyText &#91;required&#93; The JSON repository policy text to apply to the repository.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_lifecycle_policy(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_lifecycle_policy
ecr_put_lifecycle_policy <- function(registryId = NULL, repositoryName, lifecyclePolicyText) {
  op <- new_operation(
    name = "PutLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName, lifecyclePolicyText = lifecyclePolicyText)
  output <- .ecr$put_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_lifecycle_policy <- ecr_put_lifecycle_policy

#' Creates or updates the permissions policy for your registry
#'
#' @description
#' Creates or updates the permissions policy for your registry.
#' 
#' A registry policy is used to specify permissions for another AWS account
#' and is used when configuring cross-account replication. For more
#' information, see [Registry
#' permissions](https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_put_registry_policy(policyText)
#'
#' @param policyText &#91;required&#93; The JSON policy text to apply to your registry. The policy text follows
#' the same format as IAM policy text. For more information, see [Registry
#' permissions](https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_registry_policy(
#'   policyText = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_registry_policy
ecr_put_registry_policy <- function(policyText) {
  op <- new_operation(
    name = "PutRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_registry_policy_input(policyText = policyText)
  output <- .ecr$put_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_registry_policy <- ecr_put_registry_policy

#' Creates or updates the replication configuration for a registry
#'
#' @description
#' Creates or updates the replication configuration for a registry. The
#' existing replication configuration for a repository can be retrieved
#' with the [`describe_registry`][ecr_describe_registry] API action. The
#' first time the PutReplicationConfiguration API is called, a
#' service-linked IAM role is created in your account for the replication
#' process. For more information, see [Using Service-Linked Roles for
#' Amazon
#' ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#' 
#' When configuring cross-account replication, the destination account must
#' grant the source account permission to replicate. This permission is
#' controlled using a registry permissions policy. For more information,
#' see [`put_registry_policy`][ecr_put_registry_policy].
#'
#' @usage
#' ecr_put_replication_configuration(replicationConfiguration)
#'
#' @param replicationConfiguration &#91;required&#93; An object representing the replication configuration for a registry.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   replicationConfiguration = list(
#'     rules = list(
#'       list(
#'         destinations = list(
#'           list(
#'             region = "string",
#'             registryId = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_replication_configuration(
#'   replicationConfiguration = list(
#'     rules = list(
#'       list(
#'         destinations = list(
#'           list(
#'             region = "string",
#'             registryId = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_put_replication_configuration
ecr_put_replication_configuration <- function(replicationConfiguration) {
  op <- new_operation(
    name = "PutReplicationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_replication_configuration_input(replicationConfiguration = replicationConfiguration)
  output <- .ecr$put_replication_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_replication_configuration <- ecr_put_replication_configuration

#' Applies a repository policy to the specified repository to control
#' access permissions
#'
#' @description
#' Applies a repository policy to the specified repository to control
#' access permissions. For more information, see [Amazon ECR Repository
#' Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_set_repository_policy(registryId, repositoryName, policyText, force)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to receive the policy.
#' @param policyText &#91;required&#93; The JSON repository policy text to apply to the repository. For more
#' information, see [Amazon ECR Repository
#' Policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#' @param force If the policy you are attempting to set on a repository policy would
#' prevent you from setting another policy in the future, you must force
#' the [`set_repository_policy`][ecr_set_repository_policy] operation. This
#' is intended to prevent accidental repository lock outs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   policyText = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$set_repository_policy(
#'   registryId = "string",
#'   repositoryName = "string",
#'   policyText = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_set_repository_policy
ecr_set_repository_policy <- function(registryId = NULL, repositoryName, policyText, force = NULL) {
  op <- new_operation(
    name = "SetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$set_repository_policy_input(registryId = registryId, repositoryName = repositoryName, policyText = policyText, force = force)
  output <- .ecr$set_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$set_repository_policy <- ecr_set_repository_policy

#' Starts an image vulnerability scan
#'
#' @description
#' Starts an image vulnerability scan. An image scan can only be started
#' once per day on an individual image. This limit includes if an image was
#' scanned on initial push. For more information, see [Image
#' Scanning](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @usage
#' ecr_start_image_scan(registryId, repositoryName, imageId)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository in which to start an image scan request. If you do not
#' specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that contains the images to scan.
#' @param imageId &#91;required&#93; 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageId = list(
#'     imageDigest = "string",
#'     imageTag = "string"
#'   ),
#'   imageScanStatus = list(
#'     status = "IN_PROGRESS"|"COMPLETE"|"FAILED",
#'     description = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_image_scan(
#'   registryId = "string",
#'   repositoryName = "string",
#'   imageId = list(
#'     imageDigest = "string",
#'     imageTag = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_start_image_scan
ecr_start_image_scan <- function(registryId = NULL, repositoryName, imageId) {
  op <- new_operation(
    name = "StartImageScan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$start_image_scan_input(registryId = registryId, repositoryName = repositoryName, imageId = imageId)
  output <- .ecr$start_image_scan_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$start_image_scan <- ecr_start_image_scan

#' Starts a preview of a lifecycle policy for the specified repository
#'
#' @description
#' Starts a preview of a lifecycle policy for the specified repository.
#' This allows you to see the results before associating the lifecycle
#' policy with the repository.
#'
#' @usage
#' ecr_start_lifecycle_policy_preview(registryId, repositoryName,
#'   lifecyclePolicyText)
#'
#' @param registryId The AWS account ID associated with the registry that contains the
#' repository. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to be evaluated.
#' @param lifecyclePolicyText The policy to be evaluated against. If you do not specify a policy, the
#' current policy for the repository is used.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string",
#'   status = "IN_PROGRESS"|"COMPLETE"|"EXPIRED"|"FAILED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_lifecycle_policy_preview(
#'   registryId = "string",
#'   repositoryName = "string",
#'   lifecyclePolicyText = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_start_lifecycle_policy_preview
ecr_start_lifecycle_policy_preview <- function(registryId = NULL, repositoryName, lifecyclePolicyText = NULL) {
  op <- new_operation(
    name = "StartLifecyclePolicyPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$start_lifecycle_policy_preview_input(registryId = registryId, repositoryName = repositoryName, lifecyclePolicyText = lifecyclePolicyText)
  output <- .ecr$start_lifecycle_policy_preview_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$start_lifecycle_policy_preview <- ecr_start_lifecycle_policy_preview

#' Adds specified tags to a resource with the specified ARN
#'
#' @description
#' Adds specified tags to a resource with the specified ARN. Existing tags
#' on a resource are not changed if they are not specified in the request
#' parameters.
#'
#' @usage
#' ecr_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the the resource to which to add tags.
#' Currently, the only supported resource is an Amazon ECR repository.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' Tag keys can have a maximum character length of 128 characters, and tag
#' values can have a maximum length of 256 characters.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_tag_resource
ecr_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ecr$tag_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$tag_resource <- ecr_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' @usage
#' ecr_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove
#' tags. Currently, the only supported resource is an Amazon ECR
#' repository.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_untag_resource
ecr_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ecr$untag_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$untag_resource <- ecr_untag_resource

#' Uploads an image layer part to Amazon ECR
#'
#' @description
#' Uploads an image layer part to Amazon ECR.
#' 
#' When an image is pushed, each new image layer is uploaded in parts. The
#' maximum size of each image layer part can be 20971520 bytes (or about
#' 20MB). The UploadLayerPart API is called once per each new image layer
#' part.
#' 
#' This operation is used by the Amazon ECR proxy and is not generally used
#' by customers for pulling and pushing images. In most cases, you should
#' use the `docker` CLI to pull, tag, and push images.
#'
#' @usage
#' ecr_upload_layer_part(registryId, repositoryName, uploadId,
#'   partFirstByte, partLastByte, layerPartBlob)
#'
#' @param registryId The AWS account ID associated with the registry to which you are
#' uploading layer parts. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you are uploading layer parts.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecr_initiate_layer_upload] operation to
#' associate with the layer part upload.
#' @param partFirstByte &#91;required&#93; The position of the first byte of the layer part witin the overall image
#' layer.
#' @param partLastByte &#91;required&#93; The position of the last byte of the layer part within the overall image
#' layer.
#' @param layerPartBlob &#91;required&#93; The base64-encoded layer part payload.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryId = "string",
#'   repositoryName = "string",
#'   uploadId = "string",
#'   lastByteReceived = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$upload_layer_part(
#'   registryId = "string",
#'   repositoryName = "string",
#'   uploadId = "string",
#'   partFirstByte = 123,
#'   partLastByte = 123,
#'   layerPartBlob = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ecr_upload_layer_part
ecr_upload_layer_part <- function(registryId = NULL, repositoryName, uploadId, partFirstByte, partLastByte, layerPartBlob) {
  op <- new_operation(
    name = "UploadLayerPart",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$upload_layer_part_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, partFirstByte = partFirstByte, partLastByte = partLastByte, layerPartBlob = layerPartBlob)
  output <- .ecr$upload_layer_part_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$upload_layer_part <- ecr_upload_layer_part
