% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_security_group}
\alias{ec2_create_security_group}
\title{Creates a security group}
\usage{
ec2_create_security_group(Description, GroupName, VpcId,
  TagSpecifications, DryRun)
}
\arguments{
\item{Description}{[required] A description for the security group. This is informational only.

Constraints: Up to 255 characters in length

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()\#,@[]+=&;\{\}!$*}

\item{GroupName}{[required] The name of the security group.

Constraints: Up to 255 characters in length. Cannot start with \verb{sg-}.

Constraints for EC2-Classic: ASCII characters

Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
._-:/()\#,@[]+=&;\{\}!$*}

\item{VpcId}{[EC2-VPC] The ID of the VPC. Required for EC2-VPC.}

\item{TagSpecifications}{The tags to assign to the security group.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  GroupId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Creates a security group.

A security group acts as a virtual firewall for your instance to control
inbound and outbound traffic. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-security-groups.html}{Amazon EC2 Security Groups}
in the \emph{Amazon Elastic Compute Cloud User Guide} and \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html}{Security Groups for Your VPC}
in the \emph{Amazon Virtual Private Cloud User Guide}.

When you create a security group, you specify a friendly name of your
choice. You can have a security group for use in EC2-Classic with the
same name as a security group for use in a VPC. However, you can't have
two security groups for use in EC2-Classic with the same name or two
security groups for use in a VPC with the same name.

You have a default security group for use in EC2-Classic and a default
security group for use in your VPC. If you don't specify a security
group when you launch an instance, the instance is launched into the
appropriate default security group. A default security group includes a
default rule that grants instances unrestricted network access to each
other.

You can add or remove rules from your security groups using
\code{\link[=ec2_authorize_security_group_ingress]{authorize_security_group_ingress}},
\code{\link[=ec2_authorize_security_group_egress]{authorize_security_group_egress}},
\code{\link[=ec2_revoke_security_group_ingress]{revoke_security_group_ingress}},
and \code{\link[=ec2_revoke_security_group_egress]{revoke_security_group_egress}}.

For more information about VPC security group limits, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html}{Amazon VPC Limits}.
}
\section{Request syntax}{
\preformatted{svc$create_security_group(
  Description = "string",
  GroupName = "string",
  VpcId = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example creates a security group for the specified VPC.
svc$create_security_group(
  Description = "My security group",
  GroupName = "my-security-group",
  VpcId = "vpc-1a2b3c4d"
)
}

}
\keyword{internal}
