% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_reserved_instances_listings}
\alias{ec2_describe_reserved_instances_listings}
\title{Describes your account's Reserved Instance listings in the Reserved
Instance Marketplace}
\usage{
ec2_describe_reserved_instances_listings(Filters, ReservedInstancesId,
  ReservedInstancesListingId)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{reserved-instances-id} - The ID of the Reserved Instances.
\item \code{reserved-instances-listing-id} - The ID of the Reserved Instances
listing.
\item \code{status} - The status of the Reserved Instance listing (\code{pending} |
\code{active} | \code{cancelled} | \code{closed}).
\item \code{status-message} - The reason for the status.
}}

\item{ReservedInstancesId}{One or more Reserved Instance IDs.}

\item{ReservedInstancesListingId}{One or more Reserved Instance listing IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  ReservedInstancesListings = list(
    list(
      ClientToken = "string",
      CreateDate = as.POSIXct(
        "2015-01-01"
      ),
      InstanceCounts = list(
        list(
          InstanceCount = 123,
          State = "available"|"sold"|"cancelled"|"pending"
        )
      ),
      PriceSchedules = list(
        list(
          Active = TRUE|FALSE,
          CurrencyCode = "USD",
          Price = 123.0,
          Term = 123
        )
      ),
      ReservedInstancesId = "string",
      ReservedInstancesListingId = "string",
      Status = "active"|"pending"|"cancelled"|"closed",
      StatusMessage = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      UpdateDate = as.POSIXct(
        "2015-01-01"
      )
    )
  )
)
}
}
\description{
Describes your account's Reserved Instance listings in the Reserved
Instance Marketplace.

The Reserved Instance Marketplace matches sellers who want to resell
Reserved Instance capacity that they no longer need with buyers who want
to purchase additional capacity. Reserved Instances bought and sold
through the Reserved Instance Marketplace work like any other Reserved
Instances.

As a seller, you choose to list some or all of your Reserved Instances,
and you specify the upfront price to receive for them. Your Reserved
Instances are then listed in the Reserved Instance Marketplace and are
available for purchase.

As a buyer, you specify the configuration of the Reserved Instance to
purchase, and the Marketplace matches what you're searching for with
what's available. The Marketplace first sells the lowest priced Reserved
Instances to you, and continues to sell available Reserved Instance
listings to you until your demand is met. You are charged based on the
total price of all of the listings that you purchase.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html}{Reserved Instance Marketplace}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_instances_listings(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  ReservedInstancesId = "string",
  ReservedInstancesListingId = "string"
)
}
}

\keyword{internal}
