% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_function}
\alias{lambda_get_function}
\title{Returns information about the function or function version, with a link
to download the deployment package that's valid for 10 minutes}
\usage{
lambda_get_function(FunctionName, Qualifier)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version or alias to get details about a published version of
the function.}
}
\value{
A list with the following syntax:\preformatted{list(
  Configuration = list(
    FunctionName = "string",
    FunctionArn = "string",
    Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2",
    Role = "string",
    Handler = "string",
    CodeSize = 123,
    Description = "string",
    Timeout = 123,
    MemorySize = 123,
    LastModified = "string",
    CodeSha256 = "string",
    Version = "string",
    VpcConfig = list(
      SubnetIds = list(
        "string"
      ),
      SecurityGroupIds = list(
        "string"
      ),
      VpcId = "string"
    ),
    DeadLetterConfig = list(
      TargetArn = "string"
    ),
    Environment = list(
      Variables = list(
        "string"
      ),
      Error = list(
        ErrorCode = "string",
        Message = "string"
      )
    ),
    KMSKeyArn = "string",
    TracingConfig = list(
      Mode = "Active"|"PassThrough"
    ),
    MasterArn = "string",
    RevisionId = "string",
    Layers = list(
      list(
        Arn = "string",
        CodeSize = 123,
        SigningProfileVersionArn = "string",
        SigningJobArn = "string"
      )
    ),
    State = "Pending"|"Active"|"Inactive"|"Failed",
    StateReason = "string",
    StateReasonCode = "Idle"|"Creating"|"Restoring"|"EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
    LastUpdateStatus = "Successful"|"Failed"|"InProgress",
    LastUpdateStatusReason = "string",
    LastUpdateStatusReasonCode = "EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
    FileSystemConfigs = list(
      list(
        Arn = "string",
        LocalMountPath = "string"
      )
    ),
    PackageType = "Zip"|"Image",
    ImageConfigResponse = list(
      ImageConfig = list(
        EntryPoint = list(
          "string"
        ),
        Command = list(
          "string"
        ),
        WorkingDirectory = "string"
      ),
      Error = list(
        ErrorCode = "string",
        Message = "string"
      )
    ),
    SigningProfileVersionArn = "string",
    SigningJobArn = "string"
  ),
  Code = list(
    RepositoryType = "string",
    Location = "string",
    ImageUri = "string",
    ResolvedImageUri = "string"
  ),
  Tags = list(
    "string"
  ),
  Concurrency = list(
    ReservedConcurrentExecutions = 123
  )
)
}
}
\description{
Returns information about the function or function version, with a link
to download the deployment package that's valid for 10 minutes. If you
specify a function version, only details that are specific to that
version are returned.
}
\section{Request syntax}{
\preformatted{svc$get_function(
  FunctionName = "string",
  Qualifier = "string"
)
}
}

\examples{
\dontrun{
# The following example returns code and configuration details for version
# 1 of a function named my-function.
svc$get_function(
  FunctionName = "my-function",
  Qualifier = "1"
)
}

}
\keyword{internal}
