% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_update_application}
\alias{serverlessapplicationrepository_update_application}
\title{Updates the specified application}
\usage{
serverlessapplicationrepository_update_application(ApplicationId,
  Author, Description, HomePageUrl, Labels, ReadmeBody, ReadmeUrl)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{Author}{The name of the author publishing the app.

Minimum length=1. Maximum length=127.

Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";}

\item{Description}{The description of the application.

Minimum length=1. Maximum length=256}

\item{HomePageUrl}{A URL with more information about the application, for example the
location of your GitHub repository for the application.}

\item{Labels}{Labels to improve discovery of apps in search results.

Minimum length=1. Maximum length=127. Maximum number of labels: 10

Pattern: "^[a-zA-Z0-9+\\\\-_:\\\\/@]+$";}

\item{ReadmeBody}{A text readme file in Markdown language that contains a more detailed
description of the application and how it works.

Maximum size 5 MB}

\item{ReadmeUrl}{A link to the readme file in Markdown language that contains a more
detailed description of the application and how it works.

Maximum size 5 MB}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationId = "string",
  Author = "string",
  CreationTime = "string",
  Description = "string",
  HomePageUrl = "string",
  IsVerifiedAuthor = TRUE|FALSE,
  Labels = list(
    "string"
  ),
  LicenseUrl = "string",
  Name = "string",
  ReadmeUrl = "string",
  SpdxLicenseId = "string",
  VerifiedAuthorUrl = "string",
  Version = list(
    ApplicationId = "string",
    CreationTime = "string",
    ParameterDefinitions = list(
      list(
        AllowedPattern = "string",
        AllowedValues = list(
          "string"
        ),
        ConstraintDescription = "string",
        DefaultValue = "string",
        Description = "string",
        MaxLength = 123,
        MaxValue = 123,
        MinLength = 123,
        MinValue = 123,
        Name = "string",
        NoEcho = TRUE|FALSE,
        ReferencedByResources = list(
          "string"
        ),
        Type = "string"
      )
    ),
    RequiredCapabilities = list(
      "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"|"CAPABILITY_RESOURCE_POLICY"
    ),
    ResourcesSupported = TRUE|FALSE,
    SemanticVersion = "string",
    SourceCodeArchiveUrl = "string",
    SourceCodeUrl = "string",
    TemplateUrl = "string"
  )
)
}
}
\description{
Updates the specified application.
}
\section{Request syntax}{
\preformatted{svc$update_application(
  ApplicationId = "string",
  Author = "string",
  Description = "string",
  HomePageUrl = "string",
  Labels = list(
    "string"
  ),
  ReadmeBody = "string",
  ReadmeUrl = "string"
)
}
}

\keyword{internal}
