# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include eks_service.R
NULL

#' Creates an Amazon EKS control plane
#'
#' Creates an Amazon EKS control plane.
#' 
#' The Amazon EKS control plane consists of control plane instances that
#' run the Kubernetes software, such as `etcd` and the API server. The
#' control plane runs in an account managed by AWS, and the Kubernetes API
#' is exposed via the Amazon EKS API server endpoint. Each Amazon EKS
#' cluster control plane is single-tenant and unique and runs on its own
#' set of Amazon EC2 instances.
#' 
#' The cluster control plane is provisioned across multiple Availability
#' Zones and fronted by an Elastic Load Balancing Network Load Balancer.
#' Amazon EKS also provisions elastic network interfaces in your VPC
#' subnets to provide connectivity from the control plane instances to the
#' worker nodes (for example, to support `kubectl exec`, `logs`, and
#' `proxy` data flows).
#' 
#' Amazon EKS worker nodes run in your AWS account and connect to your
#' cluster\'s control plane via the Kubernetes API server endpoint and a
#' certificate file that is created for your cluster.
#' 
#' You can use the `endpointPublicAccess` and `endpointPrivateAccess`
#' parameters to enable or disable public and private access to your
#' cluster\'s Kubernetes API server endpoint. By default, public access is
#' enabled, and private access is disabled. For more information, see
#' [Amazon EKS Cluster Endpoint Access
#' Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
#' in the **Amazon EKS User Guide** .
#' 
#' You can use the `logging` parameter to enable or disable exporting the
#' Kubernetes control plane logs for your cluster to CloudWatch Logs. By
#' default, cluster control plane logs aren\'t exported to CloudWatch Logs.
#' For more information, see [Amazon EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
#' 
#' Cluster creation typically takes between 10 and 15 minutes. After you
#' create an Amazon EKS cluster, you must configure your Kubernetes tooling
#' to communicate with the API server and launch worker nodes into your
#' cluster. For more information, see [Managing Cluster
#' Authentication](https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html)
#' and [Launching Amazon EKS Worker
#' Nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html)
#' in the *Amazon EKS User Guide*.
#'
#' @usage
#' eks_create_cluster(name, version, roleArn, resourcesVpcConfig, logging,
#'   clientRequestToken)
#'
#' @param name &#91;required&#93; The unique name to give to your cluster.
#' @param version The desired Kubernetes version for your cluster. If you don\'t specify a
#' value here, the latest version available in Amazon EKS is used.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that provides permissions
#' for Amazon EKS to make calls to other AWS API operations on your behalf.
#' For more information, see [Amazon EKS Service IAM
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
#' in the **Amazon EKS User Guide** .
#' @param resourcesVpcConfig &#91;required&#93; The VPC configuration used by the cluster control plane. Amazon EKS VPC
#' resources have specific requirements to work properly with Kubernetes.
#' For more information, see [Cluster VPC
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
#' and [Cluster Security Group
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
#' in the *Amazon EKS User Guide*. You must specify at least two subnets.
#' You can specify up to five security groups, but we recommend that you
#' use a dedicated security group for your cluster control plane.
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren\'t exported to CloudWatch Logs. For more information, see [Amazon
#' EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   name = "string",
#'   version = "string",
#'   roleArn = "string",
#'   resourcesVpcConfig = list(
#'     subnetIds = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     ),
#'     endpointPublicAccess = TRUE|FALSE,
#'     endpointPrivateAccess = TRUE|FALSE
#'   ),
#'   logging = list(
#'     clusterLogging = list(
#'       list(
#'         types = list(
#'           "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
#'         ),
#'         enabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates an Amazon EKS cluster called prod.
#' \donttest{svc$create_cluster(
#'   version = "1.10",
#'   name = "prod",
#'   clientRequestToken = "1d2129a1-3d38-460a-9756-e5b91fddb951",
#'   resourcesVpcConfig = list(
#'     securityGroupIds = list(
#'       "sg-6979fe18"
#'     ),
#'     subnetIds = list(
#'       "subnet-6782e71e",
#'       "subnet-e7e761ac"
#'     )
#'   ),
#'   roleArn = "arn:aws:iam::012345678910:role/eks-service-role-AWSServiceRoleForAmazonEKS-J7ON..."
#' )}
#'
#' @keywords internal
#'
#' @rdname eks_create_cluster
eks_create_cluster <- function(name, version = NULL, roleArn, resourcesVpcConfig, logging = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$create_cluster_input(name = name, version = version, roleArn = roleArn, resourcesVpcConfig = resourcesVpcConfig, logging = logging, clientRequestToken = clientRequestToken)
  output <- .eks$create_cluster_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_cluster <- eks_create_cluster

#' Deletes the Amazon EKS cluster control plane
#'
#' Deletes the Amazon EKS cluster control plane.
#' 
#' If you have active services in your cluster that are associated with a
#' load balancer, you must delete those services before deleting the
#' cluster so that the load balancers are deleted properly. Otherwise, you
#' can have orphaned resources in your VPC that prevent you from being able
#' to delete the VPC. For more information, see [Deleting a
#' Cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html)
#' in the *Amazon EKS User Guide*.
#'
#' @usage
#' eks_delete_cluster(name)
#'
#' @param name &#91;required&#93; The name of the cluster to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   name = "string"
#' )
#' ```
#'
#' @examples
#' # This example command deletes a cluster named `devel` in your default
#' # region.
#' \donttest{svc$delete_cluster(
#'   name = "devel"
#' )}
#'
#' @keywords internal
#'
#' @rdname eks_delete_cluster
eks_delete_cluster <- function(name) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$delete_cluster_input(name = name)
  output <- .eks$delete_cluster_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_cluster <- eks_delete_cluster

#' Returns descriptive information about an Amazon EKS cluster
#'
#' Returns descriptive information about an Amazon EKS cluster.
#' 
#' The API server endpoint and certificate authority data returned by this
#' operation are required for `kubelet` and `kubectl` to communicate with
#' your Kubernetes API server. For more information, see [Create a
#' kubeconfig for Amazon
#' EKS](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
#' 
#' The API server endpoint and certificate authority data aren\'t available
#' until the cluster reaches the `ACTIVE` state.
#'
#' @usage
#' eks_describe_cluster(name)
#'
#' @param name &#91;required&#93; The name of the cluster to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster(
#'   name = "string"
#' )
#' ```
#'
#' @examples
#' # This example command provides a description of the specified cluster in
#' # your default region.
#' \donttest{svc$describe_cluster(
#'   name = "devel"
#' )}
#'
#' @keywords internal
#'
#' @rdname eks_describe_cluster
eks_describe_cluster <- function(name) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$describe_cluster_input(name = name)
  output <- .eks$describe_cluster_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_cluster <- eks_describe_cluster

#' Returns descriptive information about an update against your Amazon EKS
#' cluster
#'
#' Returns descriptive information about an update against your Amazon EKS
#' cluster.
#' 
#' When the status of the update is `Succeeded`, the update is complete. If
#' an update fails, the status is `Failed`, and an error detail explains
#' the reason for the failure.
#'
#' @usage
#' eks_describe_update(name, updateId)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param updateId &#91;required&#93; The ID of the update to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_update(
#'   name = "string",
#'   updateId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_update
eks_describe_update <- function(name, updateId) {
  op <- new_operation(
    name = "DescribeUpdate",
    http_method = "GET",
    http_path = "/clusters/{name}/updates/{updateId}",
    paginator = list()
  )
  input <- .eks$describe_update_input(name = name, updateId = updateId)
  output <- .eks$describe_update_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_update <- eks_describe_update

#' Lists the Amazon EKS clusters in your AWS account in the specified
#' Region
#'
#' Lists the Amazon EKS clusters in your AWS account in the specified
#' Region.
#'
#' @usage
#' eks_list_clusters(maxResults, nextToken)
#'
#' @param maxResults The maximum number of cluster results returned by `ListClusters` in
#' paginated output. When you use this parameter, `ListClusters` returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another `ListClusters` request with the returned
#' `nextToken` value. This value can be between 1 and 100. If you don\'t
#' use this parameter, `ListClusters` returns up to 100 results and a
#' `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated `ListClusters`
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @section Request syntax:
#' ```
#' svc$list_clusters(
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example command lists all of your available clusters in your
#' # default region.
#' \donttest{svc$list_clusters()}
#'
#' @keywords internal
#'
#' @rdname eks_list_clusters
eks_list_clusters <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$list_clusters_input(maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_clusters_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_clusters <- eks_list_clusters

#' Lists the updates associated with an Amazon EKS cluster in your AWS
#' account, in the specified Region
#'
#' Lists the updates associated with an Amazon EKS cluster in your AWS
#' account, in the specified Region.
#'
#' @usage
#' eks_list_updates(name, nextToken, maxResults)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to list updates for.
#' @param nextToken The `nextToken` value returned from a previous paginated `ListUpdates`
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' @param maxResults The maximum number of update results returned by `ListUpdates` in
#' paginated output. When you use this parameter, `ListUpdates` returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another `ListUpdates` request with the returned
#' `nextToken` value. This value can be between 1 and 100. If you don\'t
#' use this parameter, `ListUpdates` returns up to 100 results and a
#' `nextToken` value if applicable.
#'
#' @section Request syntax:
#' ```
#' svc$list_updates(
#'   name = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_list_updates
eks_list_updates <- function(name, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListUpdates",
    http_method = "GET",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$list_updates_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .eks$list_updates_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_updates <- eks_list_updates

#' Updates an Amazon EKS cluster configuration
#'
#' Updates an Amazon EKS cluster configuration. Your cluster continues to
#' function during the update. The response output includes an update ID
#' that you can use to track the status of your cluster update with the
#' DescribeUpdate API operation.
#' 
#' You can use this API operation to enable or disable exporting the
#' Kubernetes control plane logs for your cluster to CloudWatch Logs. By
#' default, cluster control plane logs aren\'t exported to CloudWatch Logs.
#' For more information, see [Amazon EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
#' 
#' You can also use this API operation to enable or disable public and
#' private access to your cluster\'s Kubernetes API server endpoint. By
#' default, public access is enabled, and private access is disabled. For
#' more information, see [Amazon EKS Cluster Endpoint Access
#' Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
#' in the **Amazon EKS User Guide** .
#' 
#' At this time, you can not update the subnets or security group IDs for
#' an existing cluster.
#' 
#' Cluster updates are asynchronous, and they should finish within a few
#' minutes. During an update, the cluster status moves to `UPDATING` (this
#' status transition is eventually consistent). When the update is complete
#' (either `Failed` or `Successful`), the cluster status moves to `Active`.
#'
#' @usage
#' eks_update_cluster_config(name, resourcesVpcConfig, logging,
#'   clientRequestToken)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param resourcesVpcConfig 
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren\'t exported to CloudWatch Logs. For more information, see [Amazon
#' EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_config(
#'   name = "string",
#'   resourcesVpcConfig = list(
#'     subnetIds = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     ),
#'     endpointPublicAccess = TRUE|FALSE,
#'     endpointPrivateAccess = TRUE|FALSE
#'   ),
#'   logging = list(
#'     clusterLogging = list(
#'       list(
#'         types = list(
#'           "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
#'         ),
#'         enabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_config
eks_update_cluster_config <- function(name, resourcesVpcConfig = NULL, logging = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/update-config",
    paginator = list()
  )
  input <- .eks$update_cluster_config_input(name = name, resourcesVpcConfig = resourcesVpcConfig, logging = logging, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_config_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_config <- eks_update_cluster_config

#' Updates an Amazon EKS cluster to the specified Kubernetes version
#'
#' Updates an Amazon EKS cluster to the specified Kubernetes version. Your
#' cluster continues to function during the update. The response output
#' includes an update ID that you can use to track the status of your
#' cluster update with the DescribeUpdate API operation.
#' 
#' Cluster updates are asynchronous, and they should finish within a few
#' minutes. During an update, the cluster status moves to `UPDATING` (this
#' status transition is eventually consistent). When the update is complete
#' (either `Failed` or `Successful`), the cluster status moves to `Active`.
#'
#' @usage
#' eks_update_cluster_version(name, version, clientRequestToken)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param version &#91;required&#93; The desired Kubernetes version following a successful update.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_version(
#'   name = "string",
#'   version = "string",
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_version
eks_update_cluster_version <- function(name, version, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$update_cluster_version_input(name = name, version = version, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_version_output()
  svc <- .eks$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_version <- eks_update_cluster_version
