% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_delete_compute_environment}
\alias{batch_delete_compute_environment}
\title{Deletes an AWS Batch compute environment}
\usage{
batch_delete_compute_environment(computeEnvironment)
}
\arguments{
\item{computeEnvironment}{[required] The name or Amazon Resource Name (ARN) of the compute environment to
delete.}
}
\description{
Deletes an AWS Batch compute environment.
}
\details{
Before you can delete a compute environment, you must set its state to
\code{DISABLED} with the UpdateComputeEnvironment API operation and
disassociate it from any job queues with the UpdateJobQueue API
operation.
}
\section{Request syntax}{
\preformatted{svc$delete_compute_environment(
  computeEnvironment = "string"
)
}
}

\examples{
# This example deletes the P2OnDemand compute environment.
\donttest{svc$delete_compute_environment(
  computeEnvironment = "P2OnDemand"
)}

}
\keyword{internal}
