% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_egress_only_internet_gateways}
\alias{ec2_describe_egress_only_internet_gateways}
\title{Describes one or more of your egress-only internet gateways}
\usage{
ec2_describe_egress_only_internet_gateways(DryRun,
  EgressOnlyInternetGatewayIds, MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EgressOnlyInternetGatewayIds}{One or more egress-only internet gateway IDs.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more of your egress-only internet gateways.
}
\section{Request syntax}{
\preformatted{svc$describe_egress_only_internet_gateways(
  DryRun = TRUE|FALSE,
  EgressOnlyInternetGatewayIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
