% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_import_snapshot}
\alias{ec2_import_snapshot}
\title{Imports a disk into an EBS snapshot}
\usage{
ec2_import_snapshot(ClientData, ClientToken, Description, DiskContainer,
  DryRun, Encrypted, KmsKeyId, RoleName)
}
\arguments{
\item{ClientData}{The client-specific data.}

\item{ClientToken}{Token to enable idempotency for VM import requests.}

\item{Description}{The description string for the import snapshot task.}

\item{DiskContainer}{Information about the disk container.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Encrypted}{Specifies whether the destination snapshot of the imported image should
be encrypted. The default CMK for EBS is used unless you specify a
non-default AWS Key Management Service (AWS KMS) CMK using \code{KmsKeyId}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{KmsKeyId}{An identifier for the symmetric AWS Key Management Service (AWS KMS)
customer master key (CMK) to use when creating the encrypted snapshot.
This parameter is only required if you want to use a non-default CMK; if
this parameter is not specified, the default CMK for EBS is used. If a
\code{KmsKeyId} is specified, the \code{Encrypted} flag must also be set.

The CMK identifier may be provided in any of the following formats:
\itemize{
\item Key ID
\item Key alias. The alias ARN contains the \code{arn:aws:kms} namespace,
followed by the Region of the CMK, the AWS account ID of the CMK
owner, the \code{alias} namespace, and then the CMK alias. For example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:alias/\emph{ExampleAlias}.
\item ARN using key ID. The ID ARN contains the \code{arn:aws:kms} namespace,
followed by the Region of the CMK, the AWS account ID of the CMK
owner, the \code{key} namespace, and then the CMK ID. For example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:key/\emph{abcd1234-a123-456a-a12b-a123b4cd56ef}.
\item ARN using key alias. The alias ARN contains the \code{arn:aws:kms}
namespace, followed by the Region of the CMK, the AWS account ID of
the CMK owner, the \code{alias} namespace, and then the CMK alias. For
example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:alias/\emph{ExampleAlias}.
}

AWS parses \code{KmsKeyId} asynchronously, meaning that the action you call
may appear to complete even though you provided an invalid identifier.
This action will eventually report failure.

The specified CMK must exist in the Region that the snapshot is being
copied to.

Amazon EBS does not support asymmetric CMKs.}

\item{RoleName}{The name of the role to use when not using the default role,
\'vmimport\'.}
}
\description{
Imports a disk into an EBS snapshot.
}
\section{Request syntax}{
\preformatted{svc$import_snapshot(
  ClientData = list(
    Comment = "string",
    UploadEnd = as.POSIXct(
      "2015-01-01"
    ),
    UploadSize = 123.0,
    UploadStart = as.POSIXct(
      "2015-01-01"
    )
  ),
  ClientToken = "string",
  Description = "string",
  DiskContainer = list(
    Description = "string",
    Format = "string",
    Url = "string",
    UserBucket = list(
      S3Bucket = "string",
      S3Key = "string"
    )
  ),
  DryRun = TRUE|FALSE,
  Encrypted = TRUE|FALSE,
  KmsKeyId = "string",
  RoleName = "string"
)
}
}

\keyword{internal}
