% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint}
\alias{ec2_create_vpc_endpoint}
\title{Creates a VPC endpoint for a specified service}
\usage{
ec2_create_vpc_endpoint(
  DryRun = NULL,
  VpcEndpointType = NULL,
  VpcId,
  ServiceName,
  PolicyDocument = NULL,
  RouteTableIds = NULL,
  SubnetIds = NULL,
  SecurityGroupIds = NULL,
  IpAddressType = NULL,
  DnsOptions = NULL,
  ClientToken = NULL,
  PrivateDnsEnabled = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointType}{The type of endpoint.

Default: Gateway}

\item{VpcId}{[required] The ID of the VPC in which the endpoint will be used.}

\item{ServiceName}{[required] The service name. To get a list of available services, use the
\code{\link[=ec2_describe_vpc_endpoint_services]{describe_vpc_endpoint_services}}
request, or get the name from the service provider.}

\item{PolicyDocument}{(Interface and gateway endpoints) A policy to attach to the endpoint
that controls access to the service. The policy must be in valid JSON
format. If this parameter is not specified, we attach a default policy
that allows full access to the service.}

\item{RouteTableIds}{(Gateway endpoint) One or more route table IDs.}

\item{SubnetIds}{(Interface and Gateway Load Balancer endpoints) The ID of one or more
subnets in which to create an endpoint network interface. For a Gateway
Load Balancer endpoint, you can specify one subnet only.}

\item{SecurityGroupIds}{(Interface endpoint) The ID of one or more security groups to associate
with the endpoint network interface.}

\item{IpAddressType}{The IP address type for the endpoint.}

\item{DnsOptions}{The DNS options for the endpoint.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicates whether to associate a private hosted
zone with the specified VPC. The private hosted zone contains a record
set for the default public DNS name for the service for the Region (for
example, \verb{kinesis.us-east-1.amazonaws.com}), which resolves to the
private IP addresses of the endpoint network interfaces in the VPC. This
enables you to make requests to the default public DNS name for the
service instead of the public DNS names that are automatically generated
by the VPC endpoint service.

To use a private hosted zone, you must set the following VPC attributes
to \code{true}: \code{enableDnsHostnames} and \code{enableDnsSupport}. Use
\code{\link[=ec2_modify_vpc_attribute]{modify_vpc_attribute}} to set the VPC
attributes.

Default: \code{true}}

\item{TagSpecifications}{The tags to associate with the endpoint.}
}
\description{
Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between your VPC and the service. The service may be provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the \href{https://docs.aws.amazon.com/vpc/latest/privatelink/}{Amazon Web Services PrivateLink Guide}.

See \url{https://paws-r.github.io/docs/ec2/create_vpc_endpoint.html} for full documentation.
}
\keyword{internal}
