% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_fleets}
\alias{ec2_delete_fleets}
\title{Deletes the specified EC2 Fleet}
\usage{
ec2_delete_fleets(DryRun = NULL, FleetIds, TerminateInstances)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FleetIds}{[required] The IDs of the EC2 Fleets.}

\item{TerminateInstances}{[required] Indicates whether to terminate the instances when the EC2 Fleet is
deleted. The default is to terminate the instances.

To let the instances continue to run after the EC2 Fleet is deleted,
specify \code{NoTerminateInstances}. Supported only for fleets of type
\code{maintain} and \code{request}.

For \code{instant} fleets, you cannot specify \code{NoTerminateInstances}. A
deleted \code{instant} fleet with running instances is not supported.}
}
\description{
Deletes the specified EC2 Fleet.

See \url{https://paws-r.github.io/docs/ec2/delete_fleets.html} for full documentation.
}
\keyword{internal}
