% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_price_history}
\alias{ec2_describe_spot_price_history}
\title{Describes the Spot price history}
\usage{
ec2_describe_spot_price_history(
  Filters = NULL,
  AvailabilityZone = NULL,
  DryRun = NULL,
  EndTime = NULL,
  InstanceTypes = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ProductDescriptions = NULL,
  StartTime = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone for which prices should
be returned.
\item \code{instance-type} - The type of instance (for example, \code{m3.medium}).
\item \code{product-description} - The product description for the Spot price
(\code{Linux/UNIX} | \verb{Red Hat Enterprise Linux} | \verb{SUSE Linux} |
\code{Windows} | \verb{Linux/UNIX (Amazon VPC)} |
\verb{Red Hat Enterprise Linux (Amazon VPC)} | \verb{SUSE Linux (Amazon VPC)}
| \verb{Windows (Amazon VPC)}).
\item \code{spot-price} - The Spot price. The value must match exactly (or use
wildcards; greater than or less than comparison is not supported).
\item \code{timestamp} - The time stamp of the Spot price history, in UTC
format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). You can use
wildcards (* and ?). Greater than or less than comparison is not
supported.
}}

\item{AvailabilityZone}{Filters the results by the specified Availability Zone.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EndTime}{The date and time, up to the current date, from which to stop retrieving
the price history data, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).}

\item{InstanceTypes}{Filters the results by the specified instance types.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{ProductDescriptions}{Filters the results by the specified basic product descriptions.}

\item{StartTime}{The date and time, up to the past 90 days, from which to start
retrieving the price history data, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).}
}
\description{
Describes the Spot price history. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html}{Spot Instance pricing history} in the \emph{Amazon EC2 User Guide for Linux Instances}.

See \url{https://paws-r.github.io/docs/ec2/describe_spot_price_history.html} for full documentation.
}
\keyword{internal}
