% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecrpublic_operations.R
\name{ecrpublic_create_repository}
\alias{ecrpublic_create_repository}
\title{Creates a repository in a public registry}
\usage{
ecrpublic_create_repository(repositoryName, catalogData = NULL, tags = NULL)
}
\arguments{
\item{repositoryName}{[required] The name to use for the repository. This appears publicly in the Amazon
ECR Public Gallery. The repository name may be specified on its own
(such as \code{nginx-web-app}) or it can be prepended with a namespace to
group the repository into a category (such as
\code{project-a/nginx-web-app}).}

\item{catalogData}{The details about the repository that are publicly visible in the Amazon
ECR Public Gallery.}

\item{tags}{The metadata that you apply to the repository to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define. Tag keys can have a maximum character length of 128
characters, and tag values can have a maximum length of 256 characters.}
}
\description{
Creates a repository in a public registry. For more information, see \href{https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html}{Amazon ECR repositories} in the \emph{Amazon Elastic Container Registry User Guide}.

See \url{https://paws-r.github.io/docs/ecrpublic/create_repository.html} for full documentation.
}
\keyword{internal}
