% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_nodegroup_version}
\alias{eks_update_nodegroup_version}
\title{Updates the Kubernetes version or AMI version of an Amazon EKS managed
node group}
\usage{
eks_update_nodegroup_version(
  clusterName,
  nodegroupName,
  version = NULL,
  releaseVersion = NULL,
  launchTemplate = NULL,
  force = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the Amazon EKS cluster that is associated with the managed
node group to update.}

\item{nodegroupName}{[required] The name of the managed node group to update.}

\item{version}{The Kubernetes version to update to. If no version is specified, then
the Kubernetes version of the node group does not change. You can
specify the Kubernetes version of the cluster to update the node group
to the latest AMI version of the cluster's Kubernetes version. If you
specify \code{launchTemplate}, and your launch template uses a custom AMI,
then don't specify \code{version}, or the node group update will fail. For
more information about using launch templates with Amazon EKS, see
\href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{releaseVersion}{The AMI version of the Amazon EKS optimized AMI to use for the update.
By default, the latest available AMI version for the node group's
Kubernetes version is used. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html}{Amazon EKS optimized Amazon Linux 2 AMI versions}
in the \emph{Amazon EKS User Guide}. If you specify \code{launchTemplate}, and
your launch template uses a custom AMI, then don't specify
\code{releaseVersion}, or the node group update will fail. For more
information about using launch templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{launchTemplate}{An object representing a node group's launch template specification. You
can only update a node group using a launch template if the node group
was originally deployed with a launch template.}

\item{force}{Force the update if the existing node group's pods are unable to be
drained due to a pod disruption budget issue. If an update fails because
pods could not be drained, you can force the update after it fails to
terminate the old node whether or not any pods are running on the node.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.

See \url{https://paws-r.github.io/docs/eks/update_nodegroup_version.html} for full documentation.
}
\keyword{internal}
