% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_relational_database_events}
\alias{lightsail_get_relational_database_events}
\title{Returns a list of events for a specific database in Amazon Lightsail}
\usage{
lightsail_get_relational_database_events(
  relationalDatabaseName,
  durationInMinutes = NULL,
  pageToken = NULL
)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of the database from which to get events.}

\item{durationInMinutes}{The number of minutes in the past from which to retrieve events. For
example, to get all events from the past 2 hours, enter 120.

Default: \code{60}

The minimum is 1 and the maximum is 14 days (20160 minutes).}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_relational_database_events]{get_relational_database_events}}
request. If your results are paginated, the response will return a next
page token that you can specify as the page token in a subsequent
request.}
}
\description{
Returns a list of events for a specific database in Amazon Lightsail.

See \url{https://paws-r.github.io/docs/lightsail/get_relational_database_events.html} for full documentation.
}
\keyword{internal}
