% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_repository}
\alias{proton_create_repository}
\title{Create and register a link to a repository that can be used with
self-managed provisioning (infrastructure or pipelines) or for template
sync configurations}
\usage{
proton_create_repository(
  connectionArn,
  encryptionKey = NULL,
  name,
  provider,
  tags = NULL
)
}
\arguments{
\item{connectionArn}{[required] The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar
connection. For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html}{Setting up for Proton}
in the \emph{Proton Administrator Guide}.}

\item{encryptionKey}{The ARN of your customer Amazon Web Services Key Management Service
(Amazon Web Services KMS) key.}

\item{name}{[required] The repository name (for example, \code{myrepos/myrepo}).}

\item{provider}{[required] The repository provider.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton repository. A tag is a key-value pair.

For more information, see \emph{Proton resources and tagging} in the \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton Administrator Guide}
or \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton User Guide}.}
}
\description{
Create and register a link to a repository that can be used with self-managed provisioning (infrastructure or pipelines) or for template sync configurations. When you create a repository link, Proton creates a \href{https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html}{service-linked role} for you.

See \url{https://paws-r.github.io/docs/proton/create_repository.html} for full documentation.
}
\keyword{internal}
