% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_update_environment_account_connection}
\alias{proton_update_environment_account_connection}
\title{In an environment account, update an environment account connection to
use a new IAM role}
\usage{
proton_update_environment_account_connection(
  componentRoleArn = NULL,
  id,
  roleArn = NULL
)
}
\arguments{
\item{componentRoleArn}{The Amazon Resource Name (ARN) of the IAM service role that Proton uses
when provisioning directly defined components in the associated
environment account. It determines the scope of infrastructure that a
component can provision in the account.

The environment account connection must have a \code{componentRoleArn} to
allow directly defined components to be associated with any environments
running in the account.

For more information about components, see \href{https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html}{Proton components}
in the \emph{Proton Administrator Guide}.}

\item{id}{[required] The ID of the environment account connection to update.}

\item{roleArn}{The Amazon Resource Name (ARN) of the IAM service role that's associated
with the environment account connection to update.}
}
\description{
In an environment account, update an environment account connection to use a new IAM role.

See \url{https://paws-r.github.io/docs/proton/update_environment_account_connection.html} for full documentation.
}
\keyword{internal}
