% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_ipam}
\alias{ec2_create_ipam}
\title{Create an IPAM}
\usage{
ec2_create_ipam(
  DryRun = NULL,
  Description = NULL,
  OperatingRegions = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Description}{A description for the IPAM.}

\item{OperatingRegions}{The operating Regions for the IPAM. Operating Regions are Amazon Web
Services Regions where the IPAM is allowed to manage IP address CIDRs.
IPAM only discovers and monitors resources in the Amazon Web Services
Regions you select as operating Regions.

For more information about operating Regions, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html}{Create an IPAM} in
the \emph{Amazon VPC IPAM User Guide}.}

\item{TagSpecifications}{The key/value combination of a tag assigned to the resource. Use the tag
key in the filter name and the tag value as the filter value. For
example, to find all resources that have a tag with the key \code{Owner} and
the value \code{TeamA}, specify \code{tag:Owner} for the filter name and \code{TeamA}
for the filter value.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}
}
\description{
Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_ipam/} for full documentation.
}
\keyword{internal}
