% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_create_fargate_profile}
\alias{eks_create_fargate_profile}
\title{Creates an Fargate profile for your Amazon EKS cluster}
\usage{
eks_create_fargate_profile(
  fargateProfileName,
  clusterName,
  podExecutionRoleArn,
  subnets = NULL,
  selectors = NULL,
  clientRequestToken = NULL,
  tags = NULL
)
}
\arguments{
\item{fargateProfileName}{[required] The name of the Fargate profile.}

\item{clusterName}{[required] The name of the Amazon EKS cluster to apply the Fargate profile to.}

\item{podExecutionRoleArn}{[required] The Amazon Resource Name (ARN) of the pod execution role to use for pods
that match the selectors in the Fargate profile. The pod execution role
allows Fargate infrastructure to register with your cluster as a node,
and it provides read access to Amazon ECR image repositories. For more
information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html}{Pod Execution Role}
in the \emph{Amazon EKS User Guide}.}

\item{subnets}{The IDs of subnets to launch your pods into. At this time, pods running
on Fargate are not assigned public IP addresses, so only private subnets
(with no direct route to an Internet Gateway) are accepted for this
parameter.}

\item{selectors}{The selectors to match for pods to use this Fargate profile. Each
selector must have an associated namespace. Optionally, you can also
specify labels for a namespace. You may specify up to five selectors in
a Fargate profile.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{tags}{The metadata to apply to the Fargate profile to assist with
categorization and organization. Each tag consists of a key and an
optional value. You define both. Fargate profile tags do not propagate
to any other resources associated with the Fargate profile, such as the
pods that are scheduled with it.}
}
\description{
Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.

See \url{https://www.paws-r-sdk.com/docs/eks_create_fargate_profile/} for full documentation.
}
\keyword{internal}
