% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_event_source_mapping}
\alias{lambda_create_event_source_mapping}
\title{Creates a mapping between an event source and an Lambda function}
\usage{
lambda_create_event_source_mapping(
  EventSourceArn = NULL,
  FunctionName,
  Enabled = NULL,
  BatchSize = NULL,
  FilterCriteria = NULL,
  MaximumBatchingWindowInSeconds = NULL,
  ParallelizationFactor = NULL,
  StartingPosition = NULL,
  StartingPositionTimestamp = NULL,
  DestinationConfig = NULL,
  MaximumRecordAgeInSeconds = NULL,
  BisectBatchOnFunctionError = NULL,
  MaximumRetryAttempts = NULL,
  TumblingWindowInSeconds = NULL,
  Topics = NULL,
  Queues = NULL,
  SourceAccessConfigurations = NULL,
  SelfManagedEventSource = NULL,
  FunctionResponseTypes = NULL,
  AmazonManagedKafkaEventSourceConfig = NULL,
  SelfManagedKafkaEventSourceConfig = NULL,
  ScalingConfig = NULL,
  DocumentDBEventSourceConfig = NULL
)
}
\arguments{
\item{EventSourceArn}{The Amazon Resource Name (ARN) of the event source.
\itemize{
\item \strong{Amazon Kinesis} – The ARN of the data stream or a stream
consumer.
\item \strong{Amazon DynamoDB Streams} – The ARN of the stream.
\item \strong{Amazon Simple Queue Service} – The ARN of the queue.
\item \strong{Amazon Managed Streaming for Apache Kafka} – The ARN of the
cluster.
\item \strong{Amazon MQ} – The ARN of the broker.
\item \strong{Amazon DocumentDB} – The ARN of the DocumentDB change stream.
}}

\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \code{MyFunction}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} – \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{When true, the event source mapping is active. When false, Lambda pauses
polling and invocation.

Default: True}

\item{BatchSize}{The maximum number of records in each batch that Lambda pulls from your
stream or queue and sends to your function. Lambda passes all of the
records in the batch to the function in a single call, up to the payload
limit for synchronous invocation (6 MB).
\itemize{
\item \strong{Amazon Kinesis} – Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} – Default 100. Max 10,000.
\item \strong{Amazon Simple Queue Service} – Default 10. For standard queues
the max is 10,000. For FIFO queues the max is 10.
\item \strong{Amazon Managed Streaming for Apache Kafka} – Default 100. Max
10,000.
\item \strong{Self-managed Apache Kafka} – Default 100. Max 10,000.
\item \strong{Amazon MQ (ActiveMQ and RabbitMQ)} – Default 100. Max 10,000.
\item \strong{DocumentDB} – Default 100. Max 10,000.
}}

\item{FilterCriteria}{An object that defines the filter criteria that determine whether Lambda
should process an event. For more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html}{Lambda event filtering}.}

\item{MaximumBatchingWindowInSeconds}{The maximum amount of time, in seconds, that Lambda spends gathering
records before invoking the function. You can configure
\code{MaximumBatchingWindowInSeconds} to any value from 0 seconds to 300
seconds in increments of seconds.

For streams and Amazon SQS event sources, the default batching window is
0 seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and
DocumentDB event sources, the default batching window is 500 ms. Note
that because you can only change \code{MaximumBatchingWindowInSeconds} in
increments of seconds, you cannot revert back to the 500 ms default
batching window after you have changed it. To restore the default
batching window, you must create a new event source mapping.

Related setting: For streams and Amazon SQS event sources, when you set
\code{BatchSize} to a value greater than 10, you must set
\code{MaximumBatchingWindowInSeconds} to at least 1.}

\item{ParallelizationFactor}{(Kinesis and DynamoDB Streams only) The number of batches to process
from each shard concurrently.}

\item{StartingPosition}{The position in a stream from which to start reading. Required for
Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources.
\code{AT_TIMESTAMP} is supported only for Amazon Kinesis streams and Amazon
DocumentDB.}

\item{StartingPositionTimestamp}{With \code{StartingPosition} set to \code{AT_TIMESTAMP}, the time from which to
start reading.}

\item{DestinationConfig}{(Kinesis and DynamoDB Streams only) A standard Amazon SQS queue or
standard Amazon SNS topic destination for discarded records.}

\item{MaximumRecordAgeInSeconds}{(Kinesis and DynamoDB Streams only) Discard records older than the
specified age. The default value is infinite (-1).}

\item{BisectBatchOnFunctionError}{(Kinesis and DynamoDB Streams only) If the function returns an error,
split the batch in two and retry.}

\item{MaximumRetryAttempts}{(Kinesis and DynamoDB Streams only) Discard records after the specified
number of retries. The default value is infinite (-1). When set to
infinite (-1), failed records are retried until the record expires.}

\item{TumblingWindowInSeconds}{(Kinesis and DynamoDB Streams only) The duration in seconds of a
processing window for DynamoDB and Kinesis Streams event sources. A
value of 0 seconds indicates no tumbling window.}

\item{Topics}{The name of the Kafka topic.}

\item{Queues}{(MQ) The name of the Amazon MQ broker destination queue to consume.}

\item{SourceAccessConfigurations}{An array of authentication protocols or VPC components required to
secure your event source.}

\item{SelfManagedEventSource}{The self-managed Apache Kafka cluster to receive records from.}

\item{FunctionResponseTypes}{(Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response
type enums applied to the event source mapping.}

\item{AmazonManagedKafkaEventSourceConfig}{Specific configuration settings for an Amazon Managed Streaming for
Apache Kafka (Amazon MSK) event source.}

\item{SelfManagedKafkaEventSourceConfig}{Specific configuration settings for a self-managed Apache Kafka event
source.}

\item{ScalingConfig}{(Amazon SQS only) The scaling configuration for the event source. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency}{Configuring maximum concurrency for Amazon SQS event sources}.}

\item{DocumentDBEventSourceConfig}{Specific configuration settings for a DocumentDB event source.}
}
\description{
Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and invokes the function.

See \url{https://www.paws-r-sdk.com/docs/lambda_create_event_source_mapping/} for full documentation.
}
\keyword{internal}
