% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_create_image_pipeline}
\alias{imagebuilder_create_image_pipeline}
\title{Creates a new image pipeline}
\usage{
imagebuilder_create_image_pipeline(
  name,
  description = NULL,
  imageRecipeArn = NULL,
  containerRecipeArn = NULL,
  infrastructureConfigurationArn,
  distributionConfigurationArn = NULL,
  imageTestsConfiguration = NULL,
  enhancedImageMetadataEnabled = NULL,
  schedule = NULL,
  status = NULL,
  tags = NULL,
  clientToken,
  imageScanningConfiguration = NULL,
  workflows = NULL,
  executionRole = NULL
)
}
\arguments{
\item{name}{[required] The name of the image pipeline.}

\item{description}{The description of the image pipeline.}

\item{imageRecipeArn}{The Amazon Resource Name (ARN) of the image recipe that will be used to
configure images created by this image pipeline.}

\item{containerRecipeArn}{The Amazon Resource Name (ARN) of the container recipe that is used to
configure images created by this container pipeline.}

\item{infrastructureConfigurationArn}{[required] The Amazon Resource Name (ARN) of the infrastructure configuration that
will be used to build images created by this image pipeline.}

\item{distributionConfigurationArn}{The Amazon Resource Name (ARN) of the distribution configuration that
will be used to configure and distribute images created by this image
pipeline.}

\item{imageTestsConfiguration}{The image test configuration of the image pipeline.}

\item{enhancedImageMetadataEnabled}{Collects additional information about the image being created, including
the operating system (OS) version and package list. This information is
used to enhance the overall experience of using EC2 Image Builder.
Enabled by default.}

\item{schedule}{The schedule of the image pipeline.}

\item{status}{The status of the image pipeline.}

\item{tags}{The tags of the image pipeline.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}

\item{imageScanningConfiguration}{Contains settings for vulnerability scans.}

\item{workflows}{Contains an array of workflow configuration objects.}

\item{executionRole}{The name or Amazon Resource Name (ARN) for the IAM role you create that
grants Image Builder access to perform workflow actions.}
}
\description{
Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_create_image_pipeline/} for full documentation.
}
\keyword{internal}
