% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_discovered_public_addresses}
\alias{ec2_get_ipam_discovered_public_addresses}
\title{Gets the public IP addresses that have been discovered by IPAM}
\usage{
ec2_get_ipam_discovered_public_addresses(
  DryRun = NULL,
  IpamResourceDiscoveryId,
  AddressRegion,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamResourceDiscoveryId}{[required] An IPAM resource discovery ID.}

\item{AddressRegion}{[required] The Amazon Web Services Region for the IP address.}

\item{Filters}{Filters.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of IPAM discovered public addresses to return in one
page of results.}
}
\description{
Gets the public IP addresses that have been discovered by IPAM.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_ipam_discovered_public_addresses/} for full documentation.
}
\keyword{internal}
