% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_services_by_namespace}
\alias{ecs_list_services_by_namespace}
\title{This operation lists all of the services that are associated with a
Cloud Map namespace}
\usage{
ecs_list_services_by_namespace(namespace, nextToken = NULL, maxResults = NULL)
}
\arguments{
\item{namespace}{[required] The namespace name or full Amazon Resource Name (ARN) of the Cloud Map
namespace to list the services in.

Tasks that run in a namespace can use short names to connect to services
in the namespace. Tasks can connect to services across all of the
clusters in the namespace. Tasks connect through a managed proxy
container that collects logs and metrics for increased visibility. Only
the tasks that Amazon ECS services create are supported with Service
Connect. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html}{Service Connect}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{nextToken}{The \code{nextToken} value that's returned from a
\code{\link[=ecs_list_services_by_namespace]{list_services_by_namespace}} request.
It indicates that more results are available to fulfill the request and
further calls are needed. If \code{maxResults} is returned, it is possible
the number of results is less than \code{maxResults}.}

\item{maxResults}{The maximum number of service results that
\code{\link[=ecs_list_services_by_namespace]{list_services_by_namespace}} returns
in paginated output. When this parameter is used,
\code{\link[=ecs_list_services_by_namespace]{list_services_by_namespace}} only
returns \code{maxResults} results in a single page along with a \code{nextToken}
response element. The remaining results of the initial request can be
seen by sending another
\code{\link[=ecs_list_services_by_namespace]{list_services_by_namespace}} request
with the returned \code{nextToken} value. This value can be between 1 and
100. If this parameter isn't used, then
\code{\link[=ecs_list_services_by_namespace]{list_services_by_namespace}} returns
up to 10 results and a \code{nextToken} value if applicable.}
}
\description{
This operation lists all of the services that are associated with a Cloud Map namespace. This list might include services in different clusters. In contrast, \code{\link[=ecs_list_services]{list_services}} can only list services in one cluster at a time. If you need to filter the list of services in a single cluster by various parameters, use \code{\link[=ecs_list_services]{list_services}}. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html}{Service Connect} in the \emph{Amazon Elastic Container Service Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/ecs_list_services_by_namespace/} for full documentation.
}
\keyword{internal}
