% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_describe_cost_category_definition}
\alias{costexplorer_describe_cost_category_definition}
\title{Returns the name, ARN, rules, definition, and effective dates of a Cost
Category that's defined in the account}
\usage{
costexplorer_describe_cost_category_definition(CostCategoryArn,
  EffectiveOn)
}
\arguments{
\item{CostCategoryArn}{[required] The unique identifier for your Cost Category.}

\item{EffectiveOn}{The date when the Cost Category was effective.}
}
\value{
A list with the following syntax:\preformatted{list(
  CostCategory = list(
    CostCategoryArn = "string",
    EffectiveStart = "string",
    EffectiveEnd = "string",
    Name = "string",
    RuleVersion = "CostCategoryExpression.v1",
    Rules = list(
      list(
        Value = "string",
        Rule = list(
          Or = list(
            list()
          ),
          And = list(
            list()
          ),
          Not = list(),
          Dimensions = list(
            Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
            Values = list(
              "string"
            ),
            MatchOptions = list(
              "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
            )
          ),
          Tags = list(
            Key = "string",
            Values = list(
              "string"
            ),
            MatchOptions = list(
              "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
            )
          ),
          CostCategories = list(
            Key = "string",
            Values = list(
              "string"
            ),
            MatchOptions = list(
              "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
            )
          )
        )
      )
    ),
    ProcessingStatus = list(
      list(
        Component = "COST_EXPLORER",
        Status = "PROCESSING"|"APPLIED"
      )
    )
  )
)
}
}
\description{
Returns the name, ARN, rules, definition, and effective dates of a Cost
Category that's defined in the account.

You have the option to use \code{EffectiveOn} to return a Cost Category that
is active on a specific date. If there is no \code{EffectiveOn} specified,
you’ll see a Cost Category that is effective on the current date. If
Cost Category is still effective, \code{EffectiveEnd} is omitted in the
response.
}
\section{Request syntax}{
\preformatted{svc$describe_cost_category_definition(
  CostCategoryArn = "string",
  EffectiveOn = "string"
)
}
}

\keyword{internal}
