% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacemetering_operations.R
\name{marketplacemetering_meter_usage}
\alias{marketplacemetering_meter_usage}
\title{API to emit metering records}
\usage{
marketplacemetering_meter_usage(
  ProductCode,
  Timestamp,
  UsageDimension,
  UsageQuantity = NULL,
  DryRun = NULL,
  UsageAllocations = NULL
)
}
\arguments{
\item{ProductCode}{[required] Product code is used to uniquely identify a product in AWS Marketplace.
The product code should be the same as the one used during the
publishing of a new product.}

\item{Timestamp}{[required] Timestamp, in UTC, for which the usage is being reported. Your
application can meter usage for up to one hour in the past. Make sure
the \code{timestamp} value is not before the start of the software usage.}

\item{UsageDimension}{[required] It will be one of the fcp dimension name provided during the publishing
of the product.}

\item{UsageQuantity}{Consumption value for the hour. Defaults to \code{0} if not specified.}

\item{DryRun}{Checks whether you have the permissions required for the action, but
does not make the request. If you have the permissions, the request
returns \code{DryRunOperation}; otherwise, it returns
\code{UnauthorizedException}. Defaults to \code{false} if not specified.}

\item{UsageAllocations}{The set of \code{UsageAllocations} to submit.

The sum of all \code{UsageAllocation} quantities must equal the
\code{UsageQuantity} of the \code{\link[=marketplacemetering_meter_usage]{meter_usage}}
request, and each \code{UsageAllocation} must have a unique set of tags
(include no tags).}
}
\description{
API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.

See \url{https://www.paws-r-sdk.com/docs/marketplacemetering_meter_usage/} for full documentation.
}
\keyword{internal}
