# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include pinpointemail_service.R
NULL

#' Create a configuration set
#'
#' Create a configuration set. *Configuration sets* are groups of rules
#' that you can apply to the emails you send using Amazon Pinpoint. You
#' apply a configuration set to an email by including a reference to the
#' configuration set in the headers of the email. When you apply a
#' configuration set to an email, all of the rules in that configuration
#' set are applied to the email.
#'
#' @usage
#' pinpointemail_create_configuration_set(ConfigurationSetName,
#'   TrackingOptions, DeliveryOptions, ReputationOptions, SendingOptions,
#'   Tags)
#'
#' @param ConfigurationSetName The name of the configuration set.
#' @param TrackingOptions An object that defines the open and click tracking options for emails
#' that you send using the configuration set.
#' @param DeliveryOptions An object that defines the dedicated IP pool that is used to send emails
#' that you send using the configuration set.
#' @param ReputationOptions An object that defines whether or not Amazon Pinpoint collects
#' reputation metrics for the emails that you send that use the
#' configuration set.
#' @param SendingOptions An object that defines whether or not Amazon Pinpoint can send email
#' that you send using the configuration set.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set(
#'   ConfigurationSetName = "string",
#'   TrackingOptions = list(
#'     CustomRedirectDomain = "string"
#'   ),
#'   DeliveryOptions = list(
#'     SendingPoolName = "string"
#'   ),
#'   ReputationOptions = list(
#'     ReputationMetricsEnabled = TRUE|FALSE,
#'     LastFreshStart = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   SendingOptions = list(
#'     SendingEnabled = TRUE|FALSE
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_configuration_set
pinpointemail_create_configuration_set <- function(ConfigurationSetName = NULL, TrackingOptions = NULL, DeliveryOptions = NULL, ReputationOptions = NULL, SendingOptions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/v1/email/configuration-sets",
    paginator = list()
  )
  input <- .pinpointemail$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions, DeliveryOptions = DeliveryOptions, ReputationOptions = ReputationOptions, SendingOptions = SendingOptions, Tags = Tags)
  output <- .pinpointemail$create_configuration_set_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_configuration_set <- pinpointemail_create_configuration_set

#' Create an event destination
#'
#' Create an event destination. In Amazon Pinpoint, *events* include
#' message sends, deliveries, opens, clicks, bounces, and complaints.
#' *Event destinations* are places that you can send information about
#' these events to. For example, you can send event data to Amazon SNS to
#' receive notifications when you receive bounces or complaints, or you can
#' use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
#' long-term storage.
#' 
#' A single configuration set can include more than one event destination.
#'
#' @usage
#' pinpointemail_create_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestinationName, EventDestination)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to add an event
#' destination to.
#' @param EventDestinationName &#91;required&#93; A name that identifies the event destination within the configuration
#' set.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestinationName = "string",
#'   EventDestination = list(
#'     Enabled = TRUE|FALSE,
#'     MatchingEventTypes = list(
#'       "SEND"|"REJECT"|"BOUNCE"|"COMPLAINT"|"DELIVERY"|"OPEN"|"CLICK"|"RENDERING_FAILURE"
#'     ),
#'     KinesisFirehoseDestination = list(
#'       IamRoleArn = "string",
#'       DeliveryStreamArn = "string"
#'     ),
#'     CloudWatchDestination = list(
#'       DimensionConfigurations = list(
#'         list(
#'           DimensionName = "string",
#'           DimensionValueSource = "MESSAGE_TAG"|"EMAIL_HEADER"|"LINK_TAG",
#'           DefaultDimensionValue = "string"
#'         )
#'       )
#'     ),
#'     SnsDestination = list(
#'       TopicArn = "string"
#'     ),
#'     PinpointDestination = list(
#'       ApplicationArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_configuration_set_event_destination
pinpointemail_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    paginator = list()
  )
  input <- .pinpointemail$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .pinpointemail$create_configuration_set_event_destination_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_configuration_set_event_destination <- pinpointemail_create_configuration_set_event_destination

#' Create a new pool of dedicated IP addresses
#'
#' Create a new pool of dedicated IP addresses. A pool can include one or
#' more dedicated IP addresses that are associated with your Amazon
#' Pinpoint account. You can associate a pool with a configuration set.
#' When you send an email that uses that configuration set, Amazon Pinpoint
#' sends it using only the IP addresses in the associated pool.
#'
#' @usage
#' pinpointemail_create_dedicated_ip_pool(PoolName, Tags)
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the pool.
#'
#' @section Request syntax:
#' ```
#' svc$create_dedicated_ip_pool(
#'   PoolName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_dedicated_ip_pool
pinpointemail_create_dedicated_ip_pool <- function(PoolName, Tags = NULL) {
  op <- new_operation(
    name = "CreateDedicatedIpPool",
    http_method = "POST",
    http_path = "/v1/email/dedicated-ip-pools",
    paginator = list()
  )
  input <- .pinpointemail$create_dedicated_ip_pool_input(PoolName = PoolName, Tags = Tags)
  output <- .pinpointemail$create_dedicated_ip_pool_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_dedicated_ip_pool <- pinpointemail_create_dedicated_ip_pool

#' Create a new predictive inbox placement test
#'
#' Create a new predictive inbox placement test. Predictive inbox placement
#' tests can help you predict how your messages will be handled by various
#' email providers around the world. When you perform a predictive inbox
#' placement test, you provide a sample message that contains the content
#' that you plan to send to your customers. Amazon Pinpoint then sends that
#' message to special email addresses spread across several major email
#' providers. After about 24 hours, the test is complete, and you can use
#' the `GetDeliverabilityTestReport` operation to view the results of the
#' test.
#'
#' @usage
#' pinpointemail_create_deliverability_test_report(ReportName,
#'   FromEmailAddress, Content, Tags)
#'
#' @param ReportName A unique name that helps you to identify the predictive inbox placement
#' test when you retrieve the results.
#' @param FromEmailAddress &#91;required&#93; The email address that the predictive inbox placement test email was
#' sent from.
#' @param Content &#91;required&#93; The HTML body of the message that you sent when you performed the
#' predictive inbox placement test.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the predictive inbox placement test.
#'
#' @section Request syntax:
#' ```
#' svc$create_deliverability_test_report(
#'   ReportName = "string",
#'   FromEmailAddress = "string",
#'   Content = list(
#'     Simple = list(
#'       Subject = list(
#'         Data = "string",
#'         Charset = "string"
#'       ),
#'       Body = list(
#'         Text = list(
#'           Data = "string",
#'           Charset = "string"
#'         ),
#'         Html = list(
#'           Data = "string",
#'           Charset = "string"
#'         )
#'       )
#'     ),
#'     Raw = list(
#'       Data = raw
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_deliverability_test_report
pinpointemail_create_deliverability_test_report <- function(ReportName = NULL, FromEmailAddress, Content, Tags = NULL) {
  op <- new_operation(
    name = "CreateDeliverabilityTestReport",
    http_method = "POST",
    http_path = "/v1/email/deliverability-dashboard/test",
    paginator = list()
  )
  input <- .pinpointemail$create_deliverability_test_report_input(ReportName = ReportName, FromEmailAddress = FromEmailAddress, Content = Content, Tags = Tags)
  output <- .pinpointemail$create_deliverability_test_report_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_deliverability_test_report <- pinpointemail_create_deliverability_test_report

#' Verifies an email identity for use with Amazon Pinpoint
#'
#' Verifies an email identity for use with Amazon Pinpoint. In Amazon
#' Pinpoint, an identity is an email address or domain that you use when
#' you send email. Before you can use an identity to send email with Amazon
#' Pinpoint, you first have to verify it. By verifying an address, you
#' demonstrate that you\'re the owner of the address, and that you\'ve
#' given Amazon Pinpoint permission to send email from the address.
#' 
#' When you verify an email address, Amazon Pinpoint sends an email to the
#' address. Your email address is verified as soon as you follow the link
#' in the verification email.
#' 
#' When you verify a domain, this operation provides a set of DKIM tokens,
#' which you can convert into CNAME tokens. You add these CNAME tokens to
#' the DNS configuration for your domain. Your domain is verified when
#' Amazon Pinpoint detects these records in the DNS configuration for your
#' domain. It usually takes around 72 hours to complete the domain
#' verification process.
#'
#' @usage
#' pinpointemail_create_email_identity(EmailIdentity, Tags)
#'
#' @param EmailIdentity &#91;required&#93; The email address or domain that you want to verify.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the email identity.
#'
#' @section Request syntax:
#' ```
#' svc$create_email_identity(
#'   EmailIdentity = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_email_identity
pinpointemail_create_email_identity <- function(EmailIdentity, Tags = NULL) {
  op <- new_operation(
    name = "CreateEmailIdentity",
    http_method = "POST",
    http_path = "/v1/email/identities",
    paginator = list()
  )
  input <- .pinpointemail$create_email_identity_input(EmailIdentity = EmailIdentity, Tags = Tags)
  output <- .pinpointemail$create_email_identity_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_email_identity <- pinpointemail_create_email_identity

#' Delete an existing configuration set
#'
#' Delete an existing configuration set.
#' 
#' In Amazon Pinpoint, *configuration sets* are groups of rules that you
#' can apply to the emails you send. You apply a configuration set to an
#' email by including a reference to the configuration set in the headers
#' of the email. When you apply a configuration set to an email, all of the
#' rules in that configuration set are applied to the email.
#'
#' @usage
#' pinpointemail_delete_configuration_set(ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_configuration_set
pinpointemail_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "DELETE",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}",
    paginator = list()
  )
  input <- .pinpointemail$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$delete_configuration_set_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_configuration_set <- pinpointemail_delete_configuration_set

#' Delete an event destination
#'
#' Delete an event destination.
#' 
#' In Amazon Pinpoint, *events* include message sends, deliveries, opens,
#' clicks, bounces, and complaints. *Event destinations* are places that
#' you can send information about these events to. For example, you can
#' send event data to Amazon SNS to receive notifications when you receive
#' bounces or complaints, or you can use Amazon Kinesis Data Firehose to
#' stream data to Amazon S3 for long-term storage.
#'
#' @usage
#' pinpointemail_delete_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestinationName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to delete.
#' @param EventDestinationName &#91;required&#93; The name of the event destination that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_configuration_set_event_destination
pinpointemail_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "DELETE",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    paginator = list()
  )
  input <- .pinpointemail$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .pinpointemail$delete_configuration_set_event_destination_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_configuration_set_event_destination <- pinpointemail_delete_configuration_set_event_destination

#' Delete a dedicated IP pool
#'
#' Delete a dedicated IP pool.
#'
#' @usage
#' pinpointemail_delete_dedicated_ip_pool(PoolName)
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dedicated_ip_pool(
#'   PoolName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_dedicated_ip_pool
pinpointemail_delete_dedicated_ip_pool <- function(PoolName) {
  op <- new_operation(
    name = "DeleteDedicatedIpPool",
    http_method = "DELETE",
    http_path = "/v1/email/dedicated-ip-pools/{PoolName}",
    paginator = list()
  )
  input <- .pinpointemail$delete_dedicated_ip_pool_input(PoolName = PoolName)
  output <- .pinpointemail$delete_dedicated_ip_pool_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_dedicated_ip_pool <- pinpointemail_delete_dedicated_ip_pool

#' Deletes an email identity that you previously verified for use with
#' Amazon Pinpoint
#'
#' Deletes an email identity that you previously verified for use with
#' Amazon Pinpoint. An identity can be either an email address or a domain
#' name.
#'
#' @usage
#' pinpointemail_delete_email_identity(EmailIdentity)
#'
#' @param EmailIdentity &#91;required&#93; The identity (that is, the email address or domain) that you want to
#' delete from your Amazon Pinpoint account.
#'
#' @section Request syntax:
#' ```
#' svc$delete_email_identity(
#'   EmailIdentity = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_email_identity
pinpointemail_delete_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "DeleteEmailIdentity",
    http_method = "DELETE",
    http_path = "/v1/email/identities/{EmailIdentity}",
    paginator = list()
  )
  input <- .pinpointemail$delete_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .pinpointemail$delete_email_identity_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_email_identity <- pinpointemail_delete_email_identity

#' Obtain information about the email-sending status and capabilities of
#' your Amazon Pinpoint account in the current AWS Region
#'
#' Obtain information about the email-sending status and capabilities of
#' your Amazon Pinpoint account in the current AWS Region.
#'
#' @usage
#' pinpointemail_get_account()
#'
#' @section Request syntax:
#' ```
#' svc$get_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_account
pinpointemail_get_account <- function() {
  op <- new_operation(
    name = "GetAccount",
    http_method = "GET",
    http_path = "/v1/email/account",
    paginator = list()
  )
  input <- .pinpointemail$get_account_input()
  output <- .pinpointemail$get_account_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_account <- pinpointemail_get_account

#' Retrieve a list of the blacklists that your dedicated IP addresses
#' appear on
#'
#' Retrieve a list of the blacklists that your dedicated IP addresses
#' appear on.
#'
#' @usage
#' pinpointemail_get_blacklist_reports(BlacklistItemNames)
#'
#' @param BlacklistItemNames &#91;required&#93; A list of IP addresses that you want to retrieve blacklist information
#' about. You can only specify the dedicated IP addresses that you use to
#' send email using Amazon Pinpoint or Amazon SES.
#'
#' @section Request syntax:
#' ```
#' svc$get_blacklist_reports(
#'   BlacklistItemNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_blacklist_reports
pinpointemail_get_blacklist_reports <- function(BlacklistItemNames) {
  op <- new_operation(
    name = "GetBlacklistReports",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/blacklist-report",
    paginator = list()
  )
  input <- .pinpointemail$get_blacklist_reports_input(BlacklistItemNames = BlacklistItemNames)
  output <- .pinpointemail$get_blacklist_reports_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_blacklist_reports <- pinpointemail_get_blacklist_reports

#' Get information about an existing configuration set, including the
#' dedicated IP pool that it's associated with, whether or not it's enabled
#' for sending email, and more
#'
#' Get information about an existing configuration set, including the
#' dedicated IP pool that it\'s associated with, whether or not it\'s
#' enabled for sending email, and more.
#' 
#' In Amazon Pinpoint, *configuration sets* are groups of rules that you
#' can apply to the emails you send. You apply a configuration set to an
#' email by including a reference to the configuration set in the headers
#' of the email. When you apply a configuration set to an email, all of the
#' rules in that configuration set are applied to the email.
#'
#' @usage
#' pinpointemail_get_configuration_set(ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to obtain more
#' information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_configuration_set(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_configuration_set
pinpointemail_get_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSet",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}",
    paginator = list()
  )
  input <- .pinpointemail$get_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$get_configuration_set_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_configuration_set <- pinpointemail_get_configuration_set

#' Retrieve a list of event destinations that are associated with a
#' configuration set
#'
#' Retrieve a list of event destinations that are associated with a
#' configuration set.
#' 
#' In Amazon Pinpoint, *events* include message sends, deliveries, opens,
#' clicks, bounces, and complaints. *Event destinations* are places that
#' you can send information about these events to. For example, you can
#' send event data to Amazon SNS to receive notifications when you receive
#' bounces or complaints, or you can use Amazon Kinesis Data Firehose to
#' stream data to Amazon S3 for long-term storage.
#'
#' @usage
#' pinpointemail_get_configuration_set_event_destinations(
#'   ConfigurationSetName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination.
#'
#' @section Request syntax:
#' ```
#' svc$get_configuration_set_event_destinations(
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_configuration_set_event_destinations
pinpointemail_get_configuration_set_event_destinations <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSetEventDestinations",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    paginator = list()
  )
  input <- .pinpointemail$get_configuration_set_event_destinations_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$get_configuration_set_event_destinations_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_configuration_set_event_destinations <- pinpointemail_get_configuration_set_event_destinations

#' Get information about a dedicated IP address, including the name of the
#' dedicated IP pool that it's associated with, as well information about
#' the automatic warm-up process for the address
#'
#' Get information about a dedicated IP address, including the name of the
#' dedicated IP pool that it\'s associated with, as well information about
#' the automatic warm-up process for the address.
#'
#' @usage
#' pinpointemail_get_dedicated_ip(Ip)
#'
#' @param Ip &#91;required&#93; The IP address that you want to obtain more information about. The value
#' you specify has to be a dedicated IP address that\'s assocaited with
#' your Amazon Pinpoint account.
#'
#' @section Request syntax:
#' ```
#' svc$get_dedicated_ip(
#'   Ip = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_dedicated_ip
pinpointemail_get_dedicated_ip <- function(Ip) {
  op <- new_operation(
    name = "GetDedicatedIp",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ips/{IP}",
    paginator = list()
  )
  input <- .pinpointemail$get_dedicated_ip_input(Ip = Ip)
  output <- .pinpointemail$get_dedicated_ip_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_dedicated_ip <- pinpointemail_get_dedicated_ip

#' List the dedicated IP addresses that are associated with your Amazon
#' Pinpoint account
#'
#' List the dedicated IP addresses that are associated with your Amazon
#' Pinpoint account.
#'
#' @usage
#' pinpointemail_get_dedicated_ips(PoolName, NextToken, PageSize)
#'
#' @param PoolName The name of the IP pool that the dedicated IP address is associated
#' with.
#' @param NextToken A token returned from a previous call to `GetDedicatedIps` to indicate
#' the position of the dedicated IP pool in the list of IP pools.
#' @param PageSize The number of results to show in a single call to
#' `GetDedicatedIpsRequest`. If the number of results is larger than the
#' number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#'
#' @section Request syntax:
#' ```
#' svc$get_dedicated_ips(
#'   PoolName = "string",
#'   NextToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_dedicated_ips
pinpointemail_get_dedicated_ips <- function(PoolName = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "GetDedicatedIps",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ips",
    paginator = list()
  )
  input <- .pinpointemail$get_dedicated_ips_input(PoolName = PoolName, NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$get_dedicated_ips_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_dedicated_ips <- pinpointemail_get_dedicated_ips

#' Show the status of the Deliverability dashboard
#'
#' Show the status of the Deliverability dashboard. When the Deliverability
#' dashboard is enabled, you gain access to reputation metrics for the
#' domains that you use to send email using Amazon Pinpoint. You also gain
#' the ability to perform predictive inbox placement tests.
#' 
#' When you use the Deliverability dashboard, you pay a monthly charge of
#' USD\\$1,250.00, in addition to any other fees that you accrue by using
#' Amazon Pinpoint. If you enable the Deliverability dashboard after the
#' first day of a calendar month, AWS prorates the monthly charge based on
#' how many days have elapsed in the current calendar month.
#'
#' @usage
#' pinpointemail_get_deliverability_dashboard_options()
#'
#' @section Request syntax:
#' ```
#' svc$get_deliverability_dashboard_options()
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_deliverability_dashboard_options
pinpointemail_get_deliverability_dashboard_options <- function() {
  op <- new_operation(
    name = "GetDeliverabilityDashboardOptions",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard",
    paginator = list()
  )
  input <- .pinpointemail$get_deliverability_dashboard_options_input()
  output <- .pinpointemail$get_deliverability_dashboard_options_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_deliverability_dashboard_options <- pinpointemail_get_deliverability_dashboard_options

#' Retrieve the results of a predictive inbox placement test
#'
#' Retrieve the results of a predictive inbox placement test.
#'
#' @usage
#' pinpointemail_get_deliverability_test_report(ReportId)
#'
#' @param ReportId &#91;required&#93; A unique string that identifies the predictive inbox placement test.
#'
#' @section Request syntax:
#' ```
#' svc$get_deliverability_test_report(
#'   ReportId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_deliverability_test_report
pinpointemail_get_deliverability_test_report <- function(ReportId) {
  op <- new_operation(
    name = "GetDeliverabilityTestReport",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/test-reports/{ReportId}",
    paginator = list()
  )
  input <- .pinpointemail$get_deliverability_test_report_input(ReportId = ReportId)
  output <- .pinpointemail$get_deliverability_test_report_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_deliverability_test_report <- pinpointemail_get_deliverability_test_report

#' Retrieve inbox placement and engagement rates for the domains that you
#' use to send email
#'
#' Retrieve inbox placement and engagement rates for the domains that you
#' use to send email.
#'
#' @usage
#' pinpointemail_get_domain_statistics_report(Domain, StartDate, EndDate)
#'
#' @param Domain &#91;required&#93; The domain that you want to obtain deliverability metrics for.
#' @param StartDate &#91;required&#93; The first day (in Unix time) that you want to obtain domain
#' deliverability metrics for.
#' @param EndDate &#91;required&#93; The last day (in Unix time) that you want to obtain domain
#' deliverability metrics for. The `EndDate` that you specify has to be
#' less than or equal to 30 days after the `StartDate`.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain_statistics_report(
#'   Domain = "string",
#'   StartDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndDate = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_domain_statistics_report
pinpointemail_get_domain_statistics_report <- function(Domain, StartDate, EndDate) {
  op <- new_operation(
    name = "GetDomainStatisticsReport",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/statistics-report/{Domain}",
    paginator = list()
  )
  input <- .pinpointemail$get_domain_statistics_report_input(Domain = Domain, StartDate = StartDate, EndDate = EndDate)
  output <- .pinpointemail$get_domain_statistics_report_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_domain_statistics_report <- pinpointemail_get_domain_statistics_report

#' Provides information about a specific identity associated with your
#' Amazon Pinpoint account, including the identity's verification status,
#' its DKIM authentication status, and its custom Mail-From settings
#'
#' Provides information about a specific identity associated with your
#' Amazon Pinpoint account, including the identity\'s verification status,
#' its DKIM authentication status, and its custom Mail-From settings.
#'
#' @usage
#' pinpointemail_get_email_identity(EmailIdentity)
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to retrieve details for.
#'
#' @section Request syntax:
#' ```
#' svc$get_email_identity(
#'   EmailIdentity = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_email_identity
pinpointemail_get_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "GetEmailIdentity",
    http_method = "GET",
    http_path = "/v1/email/identities/{EmailIdentity}",
    paginator = list()
  )
  input <- .pinpointemail$get_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .pinpointemail$get_email_identity_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_email_identity <- pinpointemail_get_email_identity

#' List all of the configuration sets associated with your Amazon Pinpoint
#' account in the current region
#'
#' List all of the configuration sets associated with your Amazon Pinpoint
#' account in the current region.
#' 
#' In Amazon Pinpoint, *configuration sets* are groups of rules that you
#' can apply to the emails you send. You apply a configuration set to an
#' email by including a reference to the configuration set in the headers
#' of the email. When you apply a configuration set to an email, all of the
#' rules in that configuration set are applied to the email.
#'
#' @usage
#' pinpointemail_list_configuration_sets(NextToken, PageSize)
#'
#' @param NextToken A token returned from a previous call to `ListConfigurationSets` to
#' indicate the position in the list of configuration sets.
#' @param PageSize The number of results to show in a single call to
#' `ListConfigurationSets`. If the number of results is larger than the
#' number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_sets(
#'   NextToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_configuration_sets
pinpointemail_list_configuration_sets <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets",
    paginator = list()
  )
  input <- .pinpointemail$list_configuration_sets_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_configuration_sets_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_configuration_sets <- pinpointemail_list_configuration_sets

#' List all of the dedicated IP pools that exist in your Amazon Pinpoint
#' account in the current AWS Region
#'
#' List all of the dedicated IP pools that exist in your Amazon Pinpoint
#' account in the current AWS Region.
#'
#' @usage
#' pinpointemail_list_dedicated_ip_pools(NextToken, PageSize)
#'
#' @param NextToken A token returned from a previous call to `ListDedicatedIpPools` to
#' indicate the position in the list of dedicated IP pools.
#' @param PageSize The number of results to show in a single call to
#' `ListDedicatedIpPools`. If the number of results is larger than the
#' number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#'
#' @section Request syntax:
#' ```
#' svc$list_dedicated_ip_pools(
#'   NextToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_dedicated_ip_pools
pinpointemail_list_dedicated_ip_pools <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDedicatedIpPools",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ip-pools",
    paginator = list()
  )
  input <- .pinpointemail$list_dedicated_ip_pools_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_dedicated_ip_pools_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_dedicated_ip_pools <- pinpointemail_list_dedicated_ip_pools

#' Show a list of the predictive inbox placement tests that you've
#' performed, regardless of their statuses
#'
#' Show a list of the predictive inbox placement tests that you\'ve
#' performed, regardless of their statuses. For predictive inbox placement
#' tests that are complete, you can use the `GetDeliverabilityTestReport`
#' operation to view the results.
#'
#' @usage
#' pinpointemail_list_deliverability_test_reports(NextToken, PageSize)
#'
#' @param NextToken A token returned from a previous call to `ListDeliverabilityTestReports`
#' to indicate the position in the list of predictive inbox placement
#' tests.
#' @param PageSize The number of results to show in a single call to
#' `ListDeliverabilityTestReports`. If the number of results is larger than
#' the number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @section Request syntax:
#' ```
#' svc$list_deliverability_test_reports(
#'   NextToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_deliverability_test_reports
pinpointemail_list_deliverability_test_reports <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDeliverabilityTestReports",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/test-reports",
    paginator = list()
  )
  input <- .pinpointemail$list_deliverability_test_reports_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_deliverability_test_reports_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_deliverability_test_reports <- pinpointemail_list_deliverability_test_reports

#' Returns a list of all of the email identities that are associated with
#' your Amazon Pinpoint account
#'
#' Returns a list of all of the email identities that are associated with
#' your Amazon Pinpoint account. An identity can be either an email address
#' or a domain. This operation returns identities that are verified as well
#' as those that aren\'t.
#'
#' @usage
#' pinpointemail_list_email_identities(NextToken, PageSize)
#'
#' @param NextToken A token returned from a previous call to `ListEmailIdentities` to
#' indicate the position in the list of identities.
#' @param PageSize The number of results to show in a single call to `ListEmailIdentities`.
#' If the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @section Request syntax:
#' ```
#' svc$list_email_identities(
#'   NextToken = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_email_identities
pinpointemail_list_email_identities <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListEmailIdentities",
    http_method = "GET",
    http_path = "/v1/email/identities",
    paginator = list()
  )
  input <- .pinpointemail$list_email_identities_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_email_identities_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_email_identities <- pinpointemail_list_email_identities

#' Retrieve a list of the tags (keys and values) that are associated with a
#' specific resource
#'
#' Retrieve a list of the tags (keys and values) that are associated with a
#' specific resource. AÂ *tag*Â is a label that you optionally define and
#' associate with a resource in Amazon Pinpoint. Each tag consists of a
#' requiredÂ *tag key*Â and an optional associatedÂ *tag value*. A tag key is
#' a general label that acts as a category for more specific tag values. A
#' tag value acts as a descriptor within a tag key.
#'
#' @usage
#' pinpointemail_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tag information for.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_tags_for_resource
pinpointemail_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/email/tags",
    paginator = list()
  )
  input <- .pinpointemail$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpointemail$list_tags_for_resource_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_tags_for_resource <- pinpointemail_list_tags_for_resource

#' Enable or disable the automatic warm-up feature for dedicated IP
#' addresses
#'
#' Enable or disable the automatic warm-up feature for dedicated IP
#' addresses.
#'
#' @usage
#' pinpointemail_put_account_dedicated_ip_warmup_attributes(
#'   AutoWarmupEnabled)
#'
#' @param AutoWarmupEnabled Enables or disables the automatic warm-up feature for dedicated IP
#' addresses that are associated with your Amazon Pinpoint account in the
#' current AWS Region. Set to `true` to enable the automatic warm-up
#' feature, or set to `false` to disable it.
#'
#' @section Request syntax:
#' ```
#' svc$put_account_dedicated_ip_warmup_attributes(
#'   AutoWarmupEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_account_dedicated_ip_warmup_attributes
pinpointemail_put_account_dedicated_ip_warmup_attributes <- function(AutoWarmupEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v1/email/account/dedicated-ips/warmup",
    paginator = list()
  )
  input <- .pinpointemail$put_account_dedicated_ip_warmup_attributes_input(AutoWarmupEnabled = AutoWarmupEnabled)
  output <- .pinpointemail$put_account_dedicated_ip_warmup_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_account_dedicated_ip_warmup_attributes <- pinpointemail_put_account_dedicated_ip_warmup_attributes

#' Enable or disable the ability of your account to send email
#'
#' Enable or disable the ability of your account to send email.
#'
#' @usage
#' pinpointemail_put_account_sending_attributes(SendingEnabled)
#'
#' @param SendingEnabled Enables or disables your account\'s ability to send email. Set to `true`
#' to enable email sending, or set to `false` to disable email sending.
#' 
#' If AWS paused your account\'s ability to send email, you can\'t use this
#' operation to resume your account\'s ability to send email.
#'
#' @section Request syntax:
#' ```
#' svc$put_account_sending_attributes(
#'   SendingEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_account_sending_attributes
pinpointemail_put_account_sending_attributes <- function(SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountSendingAttributes",
    http_method = "PUT",
    http_path = "/v1/email/account/sending",
    paginator = list()
  )
  input <- .pinpointemail$put_account_sending_attributes_input(SendingEnabled = SendingEnabled)
  output <- .pinpointemail$put_account_sending_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_account_sending_attributes <- pinpointemail_put_account_sending_attributes

#' Associate a configuration set with a dedicated IP pool
#'
#' Associate a configuration set with a dedicated IP pool. You can use
#' dedicated IP pools to create groups of dedicated IP addresses for
#' sending specific types of email.
#'
#' @usage
#' pinpointemail_put_configuration_set_delivery_options(
#'   ConfigurationSetName, SendingPoolName)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to associate with a
#' dedicated IP pool.
#' @param SendingPoolName The name of the dedicated IP pool that you want to associate with the
#' configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_set_delivery_options(
#'   ConfigurationSetName = "string",
#'   SendingPoolName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_delivery_options
pinpointemail_put_configuration_set_delivery_options <- function(ConfigurationSetName, SendingPoolName = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetDeliveryOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/delivery-options",
    paginator = list()
  )
  input <- .pinpointemail$put_configuration_set_delivery_options_input(ConfigurationSetName = ConfigurationSetName, SendingPoolName = SendingPoolName)
  output <- .pinpointemail$put_configuration_set_delivery_options_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_delivery_options <- pinpointemail_put_configuration_set_delivery_options

#' Enable or disable collection of reputation metrics for emails that you
#' send using a particular configuration set in a specific AWS Region
#'
#' Enable or disable collection of reputation metrics for emails that you
#' send using a particular configuration set in a specific AWS Region.
#'
#' @usage
#' pinpointemail_put_configuration_set_reputation_options(
#'   ConfigurationSetName, ReputationMetricsEnabled)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to enable or disable
#' reputation metric tracking for.
#' @param ReputationMetricsEnabled If `true`, tracking of reputation metrics is enabled for the
#' configuration set. If `false`, tracking of reputation metrics is
#' disabled for the configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_set_reputation_options(
#'   ConfigurationSetName = "string",
#'   ReputationMetricsEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_reputation_options
pinpointemail_put_configuration_set_reputation_options <- function(ConfigurationSetName, ReputationMetricsEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetReputationOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/reputation-options",
    paginator = list()
  )
  input <- .pinpointemail$put_configuration_set_reputation_options_input(ConfigurationSetName = ConfigurationSetName, ReputationMetricsEnabled = ReputationMetricsEnabled)
  output <- .pinpointemail$put_configuration_set_reputation_options_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_reputation_options <- pinpointemail_put_configuration_set_reputation_options

#' Enable or disable email sending for messages that use a particular
#' configuration set in a specific AWS Region
#'
#' Enable or disable email sending for messages that use a particular
#' configuration set in a specific AWS Region.
#'
#' @usage
#' pinpointemail_put_configuration_set_sending_options(
#'   ConfigurationSetName, SendingEnabled)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to enable or disable
#' email sending for.
#' @param SendingEnabled If `true`, email sending is enabled for the configuration set. If
#' `false`, email sending is disabled for the configuration set.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_set_sending_options(
#'   ConfigurationSetName = "string",
#'   SendingEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_sending_options
pinpointemail_put_configuration_set_sending_options <- function(ConfigurationSetName, SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetSendingOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/sending",
    paginator = list()
  )
  input <- .pinpointemail$put_configuration_set_sending_options_input(ConfigurationSetName = ConfigurationSetName, SendingEnabled = SendingEnabled)
  output <- .pinpointemail$put_configuration_set_sending_options_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_sending_options <- pinpointemail_put_configuration_set_sending_options

#' Specify a custom domain to use for open and click tracking elements in
#' email that you send using Amazon Pinpoint
#'
#' Specify a custom domain to use for open and click tracking elements in
#' email that you send using Amazon Pinpoint.
#'
#' @usage
#' pinpointemail_put_configuration_set_tracking_options(
#'   ConfigurationSetName, CustomRedirectDomain)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to add a custom tracking
#' domain to.
#' @param CustomRedirectDomain The domain that you want to use to track open and click events.
#'
#' @section Request syntax:
#' ```
#' svc$put_configuration_set_tracking_options(
#'   ConfigurationSetName = "string",
#'   CustomRedirectDomain = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_tracking_options
pinpointemail_put_configuration_set_tracking_options <- function(ConfigurationSetName, CustomRedirectDomain = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetTrackingOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options",
    paginator = list()
  )
  input <- .pinpointemail$put_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, CustomRedirectDomain = CustomRedirectDomain)
  output <- .pinpointemail$put_configuration_set_tracking_options_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_tracking_options <- pinpointemail_put_configuration_set_tracking_options

#' Move a dedicated IP address to an existing dedicated IP pool
#'
#' Move a dedicated IP address to an existing dedicated IP pool.
#' 
#' The dedicated IP address that you specify must already exist, and must
#' be associated with your Amazon Pinpoint account.
#' 
#' The dedicated IP pool you specify must already exist. You can create a
#' new pool by using the `CreateDedicatedIpPool` operation.
#'
#' @usage
#' pinpointemail_put_dedicated_ip_in_pool(Ip, DestinationPoolName)
#'
#' @param Ip &#91;required&#93; The IP address that you want to move to the dedicated IP pool. The value
#' you specify has to be a dedicated IP address that\'s associated with
#' your Amazon Pinpoint account.
#' @param DestinationPoolName &#91;required&#93; The name of the IP pool that you want to add the dedicated IP address
#' to. You have to specify an IP pool that already exists.
#'
#' @section Request syntax:
#' ```
#' svc$put_dedicated_ip_in_pool(
#'   Ip = "string",
#'   DestinationPoolName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_dedicated_ip_in_pool
pinpointemail_put_dedicated_ip_in_pool <- function(Ip, DestinationPoolName) {
  op <- new_operation(
    name = "PutDedicatedIpInPool",
    http_method = "PUT",
    http_path = "/v1/email/dedicated-ips/{IP}/pool",
    paginator = list()
  )
  input <- .pinpointemail$put_dedicated_ip_in_pool_input(Ip = Ip, DestinationPoolName = DestinationPoolName)
  output <- .pinpointemail$put_dedicated_ip_in_pool_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_dedicated_ip_in_pool <- pinpointemail_put_dedicated_ip_in_pool

#' Put dedicated ip warmup attributes
#'
#' 
#'
#' @usage
#' pinpointemail_put_dedicated_ip_warmup_attributes(Ip, WarmupPercentage)
#'
#' @param Ip &#91;required&#93; The dedicated IP address that you want to update the warm-up attributes
#' for.
#' @param WarmupPercentage &#91;required&#93; The warm-up percentage that you want to associate with the dedicated IP
#' address.
#'
#' @section Request syntax:
#' ```
#' svc$put_dedicated_ip_warmup_attributes(
#'   Ip = "string",
#'   WarmupPercentage = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_dedicated_ip_warmup_attributes
pinpointemail_put_dedicated_ip_warmup_attributes <- function(Ip, WarmupPercentage) {
  op <- new_operation(
    name = "PutDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v1/email/dedicated-ips/{IP}/warmup",
    paginator = list()
  )
  input <- .pinpointemail$put_dedicated_ip_warmup_attributes_input(Ip = Ip, WarmupPercentage = WarmupPercentage)
  output <- .pinpointemail$put_dedicated_ip_warmup_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_dedicated_ip_warmup_attributes <- pinpointemail_put_dedicated_ip_warmup_attributes

#' Enable or disable the Deliverability dashboard
#'
#' Enable or disable the Deliverability dashboard. When you enable the
#' Deliverability dashboard, you gain access to reputation metrics for the
#' domains that you use to send email using Amazon Pinpoint. You also gain
#' the ability to perform predictive inbox placement tests.
#' 
#' When you use the Deliverability dashboard, you pay a monthly charge of
#' USD\\$1,250.00, in addition to any other fees that you accrue by using
#' Amazon Pinpoint. If you enable the Deliverability dashboard after the
#' first day of a calendar month, we prorate the monthly charge based on
#' how many days have elapsed in the current calendar month.
#'
#' @usage
#' pinpointemail_put_deliverability_dashboard_option(DashboardEnabled)
#'
#' @param DashboardEnabled &#91;required&#93; Indicates whether the Deliverability dashboard is enabled. If the value
#' is `true`, then the dashboard is enabled.
#'
#' @section Request syntax:
#' ```
#' svc$put_deliverability_dashboard_option(
#'   DashboardEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_deliverability_dashboard_option
pinpointemail_put_deliverability_dashboard_option <- function(DashboardEnabled) {
  op <- new_operation(
    name = "PutDeliverabilityDashboardOption",
    http_method = "PUT",
    http_path = "/v1/email/deliverability-dashboard",
    paginator = list()
  )
  input <- .pinpointemail$put_deliverability_dashboard_option_input(DashboardEnabled = DashboardEnabled)
  output <- .pinpointemail$put_deliverability_dashboard_option_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_deliverability_dashboard_option <- pinpointemail_put_deliverability_dashboard_option

#' Used to enable or disable DKIM authentication for an email identity
#'
#' Used to enable or disable DKIM authentication for an email identity.
#'
#' @usage
#' pinpointemail_put_email_identity_dkim_attributes(EmailIdentity,
#'   SigningEnabled)
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to change the DKIM settings for.
#' @param SigningEnabled Sets the DKIM signing configuration for the identity.
#' 
#' When you set this value `true`, then the messages that Amazon Pinpoint
#' sends from the identity are DKIM-signed. When you set this value to
#' `false`, then the messages that Amazon Pinpoint sends from the identity
#' aren\'t DKIM-signed.
#'
#' @section Request syntax:
#' ```
#' svc$put_email_identity_dkim_attributes(
#'   EmailIdentity = "string",
#'   SigningEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_dkim_attributes
pinpointemail_put_email_identity_dkim_attributes <- function(EmailIdentity, SigningEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityDkimAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/dkim",
    paginator = list()
  )
  input <- .pinpointemail$put_email_identity_dkim_attributes_input(EmailIdentity = EmailIdentity, SigningEnabled = SigningEnabled)
  output <- .pinpointemail$put_email_identity_dkim_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_dkim_attributes <- pinpointemail_put_email_identity_dkim_attributes

#' Used to enable or disable feedback forwarding for an identity
#'
#' Used to enable or disable feedback forwarding for an identity. This
#' setting determines what happens when an identity is used to send an
#' email that results in a bounce or complaint event.
#' 
#' When you enable feedback forwarding, Amazon Pinpoint sends you email
#' notifications when bounce or complaint events occur. Amazon Pinpoint
#' sends this notification to the address that you specified in the
#' Return-Path header of the original email.
#' 
#' When you disable feedback forwarding, Amazon Pinpoint sends
#' notifications through other mechanisms, such as by notifying an Amazon
#' SNS topic. You\'re required to have a method of tracking bounces and
#' complaints. If you haven\'t set up another mechanism for receiving
#' bounce or complaint notifications, Amazon Pinpoint sends an email
#' notification when these events occur (even if this setting is disabled).
#'
#' @usage
#' pinpointemail_put_email_identity_feedback_attributes(EmailIdentity,
#'   EmailForwardingEnabled)
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to configure bounce and complaint
#' feedback forwarding for.
#' @param EmailForwardingEnabled Sets the feedback forwarding configuration for the identity.
#' 
#' If the value is `true`, Amazon Pinpoint sends you email notifications
#' when bounce or complaint events occur. Amazon Pinpoint sends this
#' notification to the address that you specified in the Return-Path header
#' of the original email.
#' 
#' When you set this value to `false`, Amazon Pinpoint sends notifications
#' through other mechanisms, such as by notifying an Amazon SNS topic or
#' another event destination. You\'re required to have a method of tracking
#' bounces and complaints. If you haven\'t set up another mechanism for
#' receiving bounce or complaint notifications, Amazon Pinpoint sends an
#' email notification when these events occur (even if this setting is
#' disabled).
#'
#' @section Request syntax:
#' ```
#' svc$put_email_identity_feedback_attributes(
#'   EmailIdentity = "string",
#'   EmailForwardingEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_feedback_attributes
pinpointemail_put_email_identity_feedback_attributes <- function(EmailIdentity, EmailForwardingEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityFeedbackAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/feedback",
    paginator = list()
  )
  input <- .pinpointemail$put_email_identity_feedback_attributes_input(EmailIdentity = EmailIdentity, EmailForwardingEnabled = EmailForwardingEnabled)
  output <- .pinpointemail$put_email_identity_feedback_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_feedback_attributes <- pinpointemail_put_email_identity_feedback_attributes

#' Used to enable or disable the custom Mail-From domain configuration for
#' an email identity
#'
#' Used to enable or disable the custom Mail-From domain configuration for
#' an email identity.
#'
#' @usage
#' pinpointemail_put_email_identity_mail_from_attributes(EmailIdentity,
#'   MailFromDomain, BehaviorOnMxFailure)
#'
#' @param EmailIdentity &#91;required&#93; The verified email identity that you want to set up the custom MAIL FROM
#' domain for.
#' @param MailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
#' The MAIL FROM domain must meet the following criteria:
#' 
#' -   It has to be a subdomain of the verified identity.
#' 
#' -   It can\'t be used to receive email.
#' 
#' -   It can\'t be used in a \"From\" address if the MAIL FROM domain is a
#'     destination for feedback forwarding emails.
#' @param BehaviorOnMxFailure The action that you want Amazon Pinpoint to take if it can\'t read the
#' required MX record when you send an email. When you set this value to
#' `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM
#' domain. When you set this value to `RejectMessage`, Amazon Pinpoint
#' returns a `MailFromDomainNotVerified` error, and doesn\'t attempt to
#' deliver the email.
#' 
#' These behaviors are taken when the custom MAIL FROM domain configuration
#' is in the `Pending`, `Failed`, and `TemporaryFailure` states.
#'
#' @section Request syntax:
#' ```
#' svc$put_email_identity_mail_from_attributes(
#'   EmailIdentity = "string",
#'   MailFromDomain = "string",
#'   BehaviorOnMxFailure = "USE_DEFAULT_VALUE"|"REJECT_MESSAGE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_mail_from_attributes
pinpointemail_put_email_identity_mail_from_attributes <- function(EmailIdentity, MailFromDomain = NULL, BehaviorOnMxFailure = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityMailFromAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/mail-from",
    paginator = list()
  )
  input <- .pinpointemail$put_email_identity_mail_from_attributes_input(EmailIdentity = EmailIdentity, MailFromDomain = MailFromDomain, BehaviorOnMxFailure = BehaviorOnMxFailure)
  output <- .pinpointemail$put_email_identity_mail_from_attributes_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_mail_from_attributes <- pinpointemail_put_email_identity_mail_from_attributes

#' Sends an email message
#'
#' Sends an email message. You can use the Amazon Pinpoint Email API to
#' send two types of messages:
#' 
#' -   **Simple** -- A standard email message. When you create this type of
#'     message, you specify the sender, the recipient, and the message
#'     body, and Amazon Pinpoint assembles the message for you.
#' 
#' -   **Raw** -- A raw, MIME-formatted email message. When you send this
#'     type of email, you have to specify all of the message headers, as
#'     well as the message body. You can use this message type to send
#'     messages that contain attachments. The message that you specify has
#'     to be a valid MIME message.
#'
#' @usage
#' pinpointemail_send_email(FromEmailAddress, Destination,
#'   ReplyToAddresses, FeedbackForwardingEmailAddress, Content, EmailTags,
#'   ConfigurationSetName)
#'
#' @param FromEmailAddress The email address that you want to use as the \"From\" address for the
#' email. The address that you specify has to be verified.
#' @param Destination &#91;required&#93; An object that contains the recipients of the email message.
#' @param ReplyToAddresses The \"Reply-to\" email addresses for the message. When the recipient
#' replies to the message, each Reply-to address receives the reply.
#' @param FeedbackForwardingEmailAddress The address that Amazon Pinpoint should send bounce and complaint
#' notifications to.
#' @param Content &#91;required&#93; An object that contains the body of the message. You can send either a
#' Simple message or a Raw message.
#' @param EmailTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using the `SendEmail` operation. Tags correspond to
#' characteristics of the email that you define, so that you can publish
#' email sending events.
#' @param ConfigurationSetName The name of the configuration set that you want to use when sending the
#' email.
#'
#' @section Request syntax:
#' ```
#' svc$send_email(
#'   FromEmailAddress = "string",
#'   Destination = list(
#'     ToAddresses = list(
#'       "string"
#'     ),
#'     CcAddresses = list(
#'       "string"
#'     ),
#'     BccAddresses = list(
#'       "string"
#'     )
#'   ),
#'   ReplyToAddresses = list(
#'     "string"
#'   ),
#'   FeedbackForwardingEmailAddress = "string",
#'   Content = list(
#'     Simple = list(
#'       Subject = list(
#'         Data = "string",
#'         Charset = "string"
#'       ),
#'       Body = list(
#'         Text = list(
#'           Data = "string",
#'           Charset = "string"
#'         ),
#'         Html = list(
#'           Data = "string",
#'           Charset = "string"
#'         )
#'       )
#'     ),
#'     Raw = list(
#'       Data = raw
#'     )
#'   ),
#'   EmailTags = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ConfigurationSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_send_email
pinpointemail_send_email <- function(FromEmailAddress = NULL, Destination, ReplyToAddresses = NULL, FeedbackForwardingEmailAddress = NULL, Content, EmailTags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendEmail",
    http_method = "POST",
    http_path = "/v1/email/outbound-emails",
    paginator = list()
  )
  input <- .pinpointemail$send_email_input(FromEmailAddress = FromEmailAddress, Destination = Destination, ReplyToAddresses = ReplyToAddresses, FeedbackForwardingEmailAddress = FeedbackForwardingEmailAddress, Content = Content, EmailTags = EmailTags, ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$send_email_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$send_email <- pinpointemail_send_email

#' Add one or more tags (keys and values) to one or more specified
#' resources
#'
#' Add one or more tags (keys and values) to one or more specified
#' resources. A *tag*Â is a label that you optionally define and associate
#' with a resource in Amazon Pinpoint. Tags can help you categorize and
#' manage resources in different ways, such as by purpose, owner,
#' environment, or other criteria. A resource can have as many as 50 tags.
#' 
#' Each tag consists of a requiredÂ *tag key*Â and an associatedÂ *tag value*,
#' both of which you define. A tag key is a general label that acts as a
#' category for more specific tag values. A tag value acts as a descriptor
#' within a tag key.
#'
#' @usage
#' pinpointemail_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to add one
#' or more tags to.
#' @param Tags &#91;required&#93; A list of the tags that you want to add to the resource. A tag consists
#' of a required tag key (`Key`) and an associated tag value (`Value`). The
#' maximum length of a tag key is 128 characters. The maximum length of a
#' tag value is 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_tag_resource
pinpointemail_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/email/tags",
    paginator = list()
  )
  input <- .pinpointemail$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .pinpointemail$tag_resource_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$tag_resource <- pinpointemail_tag_resource

#' Remove one or more tags (keys and values) from a specified resource
#'
#' Remove one or more tags (keys and values) from a specified resource.
#'
#' @usage
#' pinpointemail_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' one or more tags from.
#' @param TagKeys &#91;required&#93; The tags (tag keys) that you want to remove from the resource. When you
#' specify a tag key, the action removes both that key and its associated
#' tag value.
#' 
#' To remove more than one tag from the resource, append the `TagKeys`
#' parameter and argument for each additional tag to remove, separated by
#' an ampersand. For example:
#' `/v1/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2`
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_untag_resource
pinpointemail_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/email/tags",
    paginator = list()
  )
  input <- .pinpointemail$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpointemail$untag_resource_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$untag_resource <- pinpointemail_untag_resource

#' Update the configuration of an event destination for a configuration set
#'
#' Update the configuration of an event destination for a configuration
#' set.
#' 
#' In Amazon Pinpoint, *events* include message sends, deliveries, opens,
#' clicks, bounces, and complaints. *Event destinations* are places that
#' you can send information about these events to. For example, you can
#' send event data to Amazon SNS to receive notifications when you receive
#' bounces or complaints, or you can use Amazon Kinesis Data Firehose to
#' stream data to Amazon S3 for long-term storage.
#'
#' @usage
#' pinpointemail_update_configuration_set_event_destination(
#'   ConfigurationSetName, EventDestinationName, EventDestination)
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to modify.
#' @param EventDestinationName &#91;required&#93; The name of the event destination that you want to modify.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_set_event_destination(
#'   ConfigurationSetName = "string",
#'   EventDestinationName = "string",
#'   EventDestination = list(
#'     Enabled = TRUE|FALSE,
#'     MatchingEventTypes = list(
#'       "SEND"|"REJECT"|"BOUNCE"|"COMPLAINT"|"DELIVERY"|"OPEN"|"CLICK"|"RENDERING_FAILURE"
#'     ),
#'     KinesisFirehoseDestination = list(
#'       IamRoleArn = "string",
#'       DeliveryStreamArn = "string"
#'     ),
#'     CloudWatchDestination = list(
#'       DimensionConfigurations = list(
#'         list(
#'           DimensionName = "string",
#'           DimensionValueSource = "MESSAGE_TAG"|"EMAIL_HEADER"|"LINK_TAG",
#'           DefaultDimensionValue = "string"
#'         )
#'       )
#'     ),
#'     SnsDestination = list(
#'       TopicArn = "string"
#'     ),
#'     PinpointDestination = list(
#'       ApplicationArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpointemail_update_configuration_set_event_destination
pinpointemail_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    paginator = list()
  )
  input <- .pinpointemail$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .pinpointemail$update_configuration_set_event_destination_output()
  svc <- .pinpointemail$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$update_configuration_set_event_destination <- pinpointemail_update_configuration_set_event_destination
