% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_create_configuration_set}
\alias{pinpointemail_create_configuration_set}
\title{Create a configuration set}
\usage{
pinpointemail_create_configuration_set(ConfigurationSetName,
  TrackingOptions, DeliveryOptions, ReputationOptions, SendingOptions,
  Tags)
}
\arguments{
\item{ConfigurationSetName}{The name of the configuration set.}

\item{TrackingOptions}{An object that defines the open and click tracking options for emails
that you send using the configuration set.}

\item{DeliveryOptions}{An object that defines the dedicated IP pool that is used to send emails
that you send using the configuration set.}

\item{ReputationOptions}{An object that defines whether or not Amazon Pinpoint collects
reputation metrics for the emails that you send that use the
configuration set.}

\item{SendingOptions}{An object that defines whether or not Amazon Pinpoint can send email
that you send using the configuration set.}

\item{Tags}{An object that defines the tags (keys and values) that you want to
associate with the configuration set.}
}
\description{
Create a configuration set. \emph{Configuration sets} are groups of rules
that you can apply to the emails you send using Amazon Pinpoint. You
apply a configuration set to an email by including a reference to the
configuration set in the headers of the email. When you apply a
configuration set to an email, all of the rules in that configuration
set are applied to the email.
}
\section{Request syntax}{
\preformatted{svc$create_configuration_set(
  ConfigurationSetName = "string",
  TrackingOptions = list(
    CustomRedirectDomain = "string"
  ),
  DeliveryOptions = list(
    SendingPoolName = "string"
  ),
  ReputationOptions = list(
    ReputationMetricsEnabled = TRUE|FALSE,
    LastFreshStart = as.POSIXct(
      "2015-01-01"
    )
  ),
  SendingOptions = list(
    SendingEnabled = TRUE|FALSE
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
