% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_journey_execution_metrics}
\alias{pinpoint_get_journey_execution_metrics}
\title{Retrieves (queries) pre-aggregated data for a standard execution metric
that applies to a journey}
\usage{
pinpoint_get_journey_execution_metrics(ApplicationId, JourneyId,
  NextToken, PageSize)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{JourneyId}{[required] The unique identifier for the journey.}

\item{NextToken}{The string that specifies which page of results to return in a paginated
response. This parameter is currently not supported for application,
campaign, and journey metrics.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is currently not supported for application,
campaign, and journey metrics.}
}
\description{
Retrieves (queries) pre-aggregated data for a standard execution metric
that applies to a journey.
}
\section{Request syntax}{
\preformatted{svc$get_journey_execution_metrics(
  ApplicationId = "string",
  JourneyId = "string",
  NextToken = "string",
  PageSize = "string"
)
}
}

\keyword{internal}
