% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_verify_domain_identity}
\alias{ses_verify_domain_identity}
\title{Adds a domain to the list of identities for your Amazon SES account in
the current AWS Region and attempts to verify it}
\usage{
ses_verify_domain_identity(Domain)
}
\arguments{
\item{Domain}{[required] The domain to be verified.}
}
\description{
Adds a domain to the list of identities for your Amazon SES account in
the current AWS Region and attempts to verify it. For more information
about verifying domains, see \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html}{Verifying Email Addresses and Domains}
in the \emph{Amazon SES Developer Guide.}
}
\details{
You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$verify_domain_identity(
  Domain = "string"
)
}
}

\examples{
\dontrun{
# The following example starts the domain verification process with Amazon
# SES:
svc$verify_domain_identity(
  Domain = "example.com"
)
}

}
\keyword{internal}
