% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectparticipant_operations.R
\name{connectparticipant_start_attachment_upload}
\alias{connectparticipant_start_attachment_upload}
\title{Provides a pre-signed Amazon S3 URL in response for uploading the file
directly to S3}
\usage{
connectparticipant_start_attachment_upload(
  ContentType,
  AttachmentSizeInBytes,
  AttachmentName,
  ClientToken,
  ConnectionToken
)
}
\arguments{
\item{ContentType}{[required] Describes the MIME file type of the attachment. For a list of supported
file types, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits}{Feature specifications}
in the \emph{Amazon Connect Administrator Guide}.}

\item{AttachmentSizeInBytes}{[required] The size of the attachment in bytes.}

\item{AttachmentName}{[required] A case-sensitive name of the attachment being uploaded.}

\item{ClientToken}{[required] A unique case sensitive identifier to support idempotency of request.}

\item{ConnectionToken}{[required] The authentication token associated with the participant's connection.}
}
\description{
Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.

See \url{https://paws-r.github.io/docs/connectparticipant/start_attachment_upload.html} for full documentation.
}
\keyword{internal}
