% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_domain}
\alias{customerprofiles_create_domain}
\title{Creates a domain, which is a container for all customer data, such as
customer profile attributes, object types, profile keys, and encryption
keys}
\usage{
customerprofiles_create_domain(
  DomainName,
  DefaultExpirationDays,
  DefaultEncryptionKey = NULL,
  DeadLetterQueueUrl = NULL,
  Matching = NULL,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{DefaultExpirationDays}{[required] The default number of days until the data within the domain expires.}

\item{DefaultEncryptionKey}{The default encryption key, which is an AWS managed key, is used when no
specific type of encryption key is specified. It is used to encrypt all
data before it is placed in permanent or semi-permanent storage.}

\item{DeadLetterQueueUrl}{The URL of the SQS dead letter queue, which is used for reporting errors
associated with ingesting data from third party applications. You must
set up a policy on the DeadLetterQueue for the SendMessage operation to
enable Amazon Connect Customer Profiles to send messages to the
DeadLetterQueue.}

\item{Matching}{The process of matching duplicate profiles. If \code{Matching} = \code{true},
Amazon Connect Customer Profiles starts a weekly batch process called
Identity Resolution Job. If you do not specify a date and time for
Identity Resolution Job to run, by default it runs every Saturday at
12AM UTC to detect duplicate profiles in your domains.

After the Identity Resolution Job completes, use the
\code{\link[=customerprofiles_get_matches]{get_matches}} API to return and review
the results. Or, if you have configured \code{ExportingConfig} in the
\code{MatchingRequest}, you can download the results from S3.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.

See \url{https://paws-r.github.io/docs/customerprofiles/create_domain.html} for full documentation.
}
\keyword{internal}
