% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_replicate_instance}
\alias{connect_replicate_instance}
\title{Replicates an Amazon Connect instance in the specified Amazon Web
Services Region}
\usage{
connect_replicate_instance(
  InstanceId,
  ReplicaRegion,
  ClientToken = NULL,
  ReplicaAlias
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance. You can provide the
\code{InstanceId}, or the entire ARN.}

\item{ReplicaRegion}{[required] The Amazon Web Services Region where to replicate the Amazon Connect
instance.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ReplicaAlias}{[required] The alias for the replicated instance. The \code{ReplicaAlias} must be
unique.}
}
\description{
Replicates an Amazon Connect instance in the specified Amazon Web Services Region.

See \url{https://www.paws-r-sdk.com/docs/connect_replicate_instance/} for full documentation.
}
\keyword{internal}
